/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.asset.model;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Properties;
import org.adempiere.core.domains.models.X_A_Asset_Transfer;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.asset.exceptions.AssetAlreadyDepreciatedException;
import org.compiere.asset.model.MAssetAcct;
import org.compiere.asset.model.MDepreciationExp;
import org.compiere.asset.model.MDepreciationWorkfile;
import org.compiere.model.MPeriod;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.process.DocAction;
import org.compiere.process.DocumentEngine;
import org.compiere.util.Env;

public class MAssetTransfer
extends X_A_Asset_Transfer
implements DocAction {
    private static final long serialVersionUID = 6542200284709386238L;
    private boolean m_justPrepared = false;
    private String m_processMsg = null;

    public MAssetTransfer(Properties ctx, int X_A_Asset_Transfer_ID, String trxName) {
        super(ctx, X_A_Asset_Transfer_ID, trxName);
        if (X_A_Asset_Transfer_ID == 0) {
            this.setDocStatus("DR");
            this.setDocAction("CO");
            this.setProcessed(false);
        }
    }

    public MAssetTransfer(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    protected boolean beforeSave(boolean newRecord) {
        this.setC_Period_ID();
        return true;
    }

    public void setC_Period_ID() {
        MPeriod period = MPeriod.get((Properties)this.getCtx(), (Timestamp)this.getDateAcct(), (int)this.getAD_Org_ID());
        if (period == null) {
            throw new AdempiereException("@NotFound@ @C_Period_ID@");
        }
        this.setC_Period_ID(period.get_ID());
    }

    public boolean approveIt() {
        return false;
    }

    public boolean closeIt() {
        this.setDocAction("--");
        return true;
    }

    public File createPDF() {
        return null;
    }

    public BigDecimal getApprovalAmt() {
        return Env.ZERO;
    }

    public int getC_Currency_ID() {
        return 0;
    }

    public int getDoc_User_ID() {
        return this.getCreatedBy();
    }

    public String getDocumentInfo() {
        return this.getDocumentNo() + "/" + String.valueOf(this.getDateAcct());
    }

    public String getProcessMsg() {
        return this.m_processMsg;
    }

    public String getSummary() {
        StringBuffer sb = new StringBuffer();
        sb.append("@DocumentNo@ #").append(this.getDocumentNo());
        return sb.toString();
    }

    public boolean invalidateIt() {
        return false;
    }

    public String prepareIt() {
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        MPeriod.testPeriodOpen((Properties)this.getCtx(), (Timestamp)this.getDateAcct(), (String)"GLJ", (int)this.getAD_Org_ID());
        MDepreciationWorkfile assetwk = MDepreciationWorkfile.get(this.getCtx(), this.getA_Asset_ID(), this.getPostingType());
        if (assetwk.isDepreciated(this.getDateAcct())) {
            throw new AssetAlreadyDepreciatedException();
        }
        MAssetAcct assetAcct = MAssetAcct.forA_Asset_ID(this.getCtx(), this.getA_Asset_ID(), this.getPostingType(), this.getDateAcct(), this.get_TrxName());
        if (assetAcct.getA_Asset_Acct() != this.getA_Asset_Acct() || assetAcct.getA_Accumdepreciation_Acct() != this.getA_Accumdepreciation_Acct() || assetAcct.getA_Depreciation_Acct() != this.getA_Depreciation_Acct() || assetAcct.getA_Disposal_Revenue_Acct() != this.getA_Disposal_Revenue_Acct() || assetAcct.getA_Disposal_Loss_Acct() != this.getA_Disposal_Loss_Acct()) {
            throw new AdempiereException("The accounts have been changed");
        }
        MAssetAcct acct = MAssetAcct.forA_Asset_ID(this.getCtx(), this.getA_Asset_ID(), this.getPostingType(), this.getDateAcct(), this.get_TrxName());
        if (acct.getA_Asset_Acct() == this.getA_Asset_New_Acct() && acct.getA_Accumdepreciation_Acct() == this.getA_Accumdepreciation_New_Acct() && acct.getA_Depreciation_Acct() == this.getA_Depreciation_New_Acct() && acct.getA_Disposal_Revenue_Acct() == this.getA_Disposal_Revenue_New_Acct() && acct.getA_Disposal_Loss_Acct() == this.getA_Disposal_Loss_New_Acct()) {
            throw new AdempiereException("An account has been changed");
        }
        if (assetwk.getDateAcct().equals(this.getDateAcct())) {
            throw new AdempiereException("Last day of month. Accounts will be changed next month");
        }
        MDepreciationExp.checkExistsNotProcessedEntries(this.getCtx(), this.getA_Asset_ID(), this.getDateAcct(), this.getPostingType(), this.get_TrxName());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 8);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.m_justPrepared = true;
        if (!"CO".equals(this.getDocAction())) {
            this.setDocAction("CO");
        }
        return "IP";
    }

    public String completeIt() {
        String status;
        if (!this.m_justPrepared && !"IP".equals(status = this.prepareIt())) {
            return status;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 7);
        if (this.m_processMsg != null) {
            return "IN";
        }
        MAssetAcct assetAcctPrev = MAssetAcct.forA_Asset_ID(this.getCtx(), this.getA_Asset_ID(), this.getPostingType(), this.getDateAcct(), this.get_TrxName());
        MAssetAcct assetAcct = new MAssetAcct(this.getCtx(), 0, this.get_TrxName());
        PO.copyValues((PO)assetAcctPrev, (PO)assetAcct);
        assetAcct.setA_Asset_Acct(this.getA_Asset_New_Acct());
        assetAcct.setA_Accumdepreciation_Acct(this.getA_Accumdepreciation_New_Acct());
        assetAcct.setValidFrom(this.getDateAcct());
        assetAcct.saveEx();
        MDepreciationWorkfile wk = MDepreciationWorkfile.get(this.getCtx(), this.getA_Asset_ID(), this.getPostingType(), this.get_TrxName());
        String valid = ModelValidationEngine.get().fireDocValidate((PO)this, 9);
        if (valid != null) {
            this.m_processMsg = valid;
            return "IN";
        }
        this.setProcessed(true);
        this.setDocAction("CL");
        return "CO";
    }

    public boolean processIt(String action) throws Exception {
        this.m_processMsg = null;
        DocumentEngine engine = new DocumentEngine((DocAction)this, this.getDocStatus());
        return engine.processIt(action, this.getDocAction());
    }

    public boolean reActivateIt() {
        return false;
    }

    public boolean rejectIt() {
        return false;
    }

    public boolean reverseAccrualIt() {
        return false;
    }

    public boolean reverseCorrectIt() {
        return false;
    }

    public boolean unlockIt() {
        return false;
    }

    public boolean voidIt() {
        return false;
    }

    public String getDocumentNo() {
        return null;
    }
}

