/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.asset.model;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.util.Properties;
import org.adempiere.exceptions.NoCurrencyConversionException;
import org.compiere.asset.model.SetGetModel;
import org.compiere.asset.model.SetGetUtil;
import org.compiere.model.MClient;
import org.compiere.model.MConversionRate;
import org.compiere.model.MCurrency;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.Env;

public class MConversionRateUtil {
    private static final CLogger s_log = CLogger.getCLogger(MConversionRateUtil.class);

    public static BigDecimal convertBase(SetGetModel model, String DateName, String SourceAmtName, String AmtName, String changedColumnName) {
        BigDecimal sourceAmt;
        if (changedColumnName != null && "C_Currency_ID".equalsIgnoreCase(changedColumnName)) {
            model.set_AttrValue("CurrencyRate", Env.ZERO);
        }
        if ((sourceAmt = SetGetUtil.get_AttrValueAsBigDecimal(model, SourceAmtName)) == null || sourceAmt.signum() == 0) {
            if (AmtName != null) {
                model.set_AttrValue(AmtName, Env.ZERO);
            }
            return Env.ZERO;
        }
        int AD_Client_ID = SetGetUtil.get_AttrValueAsInt(model, "AD_Client_ID");
        int C_Currency_ID_To = MClient.get((Properties)model.getCtx(), (int)AD_Client_ID).getAcctSchema().getC_Currency_ID();
        BigDecimal rate = SetGetUtil.get_AttrValueAsBigDecimal(model, "CurrencyRate");
        if (rate == null || rate.signum() == 0) {
            int AD_Org_ID = SetGetUtil.get_AttrValueAsInt(model, "AD_Client_ID");
            Timestamp ConvDate = SetGetUtil.get_AttrValueAsDate(model, DateName);
            int C_Currency_ID = SetGetUtil.get_AttrValueAsInt(model, "C_Currency_ID");
            if (C_Currency_ID == C_Currency_ID_To) {
                rate = Env.ONE;
            } else {
                int C_ConversionType_ID = SetGetUtil.get_AttrValueAsInt(model, "C_ConversionType_ID");
                rate = MConversionRate.getRate(C_Currency_ID, C_Currency_ID_To, ConvDate, C_ConversionType_ID, AD_Client_ID, AD_Org_ID);
                if (rate == null) {
                    throw new NoCurrencyConversionException(C_Currency_ID, C_Currency_ID_To, ConvDate, C_ConversionType_ID, AD_Client_ID, AD_Org_ID);
                }
            }
        }
        model.set_AttrValue("CurrencyRate", rate);
        BigDecimal amt = sourceAmt.multiply(rate);
        int stdPrecision = MCurrency.getStdPrecision((Properties)model.getCtx(), (int)C_Currency_ID_To);
        amt = amt.setScale(stdPrecision, RoundingMode.HALF_UP);
        if (AmtName != null) {
            model.set_AttrValue(AmtName, amt);
        }
        if (CLogMgt.isLevelFine()) {
            s_log.fine("amt=" + String.valueOf(sourceAmt) + " * " + String.valueOf(rate) + "=" + String.valueOf(amt) + ", scale=" + stdPrecision);
        }
        return amt;
    }
}

