/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.asset.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.adempiere.core.domains.models.X_A_Depreciation_Exp;
import org.compiere.asset.exceptions.AssetException;
import org.compiere.asset.exceptions.AssetNotActiveException;
import org.compiere.asset.model.MAsset;
import org.compiere.asset.model.MAssetAcct;
import org.compiere.asset.model.MDepreciationEntry;
import org.compiere.asset.model.MDepreciationWorkfile;
import org.compiere.model.MPeriod;
import org.compiere.model.Query;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;

public class MDepreciationExp
extends X_A_Depreciation_Exp {
    private static final long serialVersionUID = 1L;
    private static CLogger s_log = CLogger.getCLogger(MDepreciationExp.class);
    private CLogger log = CLogger.getCLogger(((Object)((Object)this)).getClass());

    public MDepreciationExp(Properties ctx, int depreciationExpId, String trxName) {
        super(ctx, depreciationExpId, trxName);
    }

    public MDepreciationExp(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public static MDepreciationExp get(Properties ctx, int depreciationExpId) {
        if (depreciationExpId <= 0) {
            return null;
        }
        MDepreciationExp depexp = new MDepreciationExp(ctx, depreciationExpId, null);
        if (depexp.get_ID() != depreciationExpId) {
            depexp = null;
        }
        return depexp;
    }

    public static MDepreciationExp createEntry(Properties ctx, String entryType, int assetId, int assetPeriod, Timestamp dateAcct, String postingType, int debitAcct, int creditAcct, BigDecimal expense, String description, MDepreciationWorkfile assetBalanace) {
        MDepreciationExp depexp = new MDepreciationExp(ctx, 0, null);
        depexp.setA_Entry_Type(entryType);
        depexp.setA_Asset_ID(assetId);
        depexp.setDR_Account_ID(debitAcct);
        depexp.setCR_Account_ID(creditAcct);
        depexp.setA_Account_Number_Acct(debitAcct);
        depexp.setPostingType(postingType);
        depexp.setExpense(expense);
        depexp.setDescription(Msg.parseTranslation((Properties)ctx, (String)description));
        depexp.setA_Period(assetPeriod);
        depexp.setIsDepreciated(true);
        depexp.setDateAcct(dateAcct);
        depexp.updateFrom(assetBalanace);
        s_log.fine("depexp=" + String.valueOf((Object)depexp));
        return depexp;
    }

    public void updateFrom(MDepreciationWorkfile assetBalance) {
        this.setA_Asset_Cost(assetBalance.getA_Asset_Cost());
        this.setA_Accumulated_Depr(assetBalance.getA_Accumulated_Depr());
        this.setA_Accumulated_Depr_F(assetBalance.getA_Accumulated_Depr_F());
        this.setUseLifeMonths(assetBalance.getUseLifeMonths());
        this.setUseLifeMonths_F(assetBalance.getUseLifeMonths_F());
        this.setA_Asset_Remaining(assetBalance.getA_Asset_Remaining());
        this.setA_Asset_Remaining_F(assetBalance.getA_Asset_Remaining_F());
    }

    private MDepreciationWorkfile getA_Depreciation_Workfile() {
        return MDepreciationWorkfile.get(this.getCtx(), this.getA_Asset_ID(), this.getPostingType(), this.get_TrxName());
    }

    public static Collection<MDepreciationExp> createDepreciation(MDepreciationWorkfile assetBalance, int periodNo, Timestamp dateAcct, BigDecimal amt, BigDecimal amtFiscal, BigDecimal accumAmt, BigDecimal accumAmtFiscal, String help, String trxName) {
        ArrayList<MDepreciationExp> list = new ArrayList<MDepreciationExp>();
        Properties ctx = assetBalance.getCtx();
        MAssetAcct assetAcct = assetBalance.getA_AssetAcct(dateAcct, trxName);
        MDepreciationExp depexp = null;
        depexp = MDepreciationExp.createEntry(ctx, "DEP", assetBalance.getA_Asset_ID(), periodNo, dateAcct, assetBalance.getPostingType(), assetAcct.getA_Depreciation_Acct(), assetAcct.getA_Accumdepreciation_Acct(), amt, "@AssetDepreciationAmt@", assetBalance);
        if (depexp != null) {
            MAsset asset = MAsset.get(ctx, assetBalance.getA_Asset_ID(), trxName);
            depexp.setAD_Org_ID(asset.getAD_Org_ID());
            if (accumAmt != null) {
                depexp.setA_Accumulated_Depr(accumAmt);
            }
            if (accumAmtFiscal != null) {
                depexp.setA_Accumulated_Depr_F(accumAmtFiscal);
            }
            if (help != null && help.length() > 0) {
                depexp.setHelp(help);
            }
            depexp.setExpense_F(amtFiscal);
            depexp.setA_Accumulated_Depr_Delta(amt);
            depexp.setA_Accumulated_Depr_F_Delta(amtFiscal);
            depexp.saveEx(assetBalance.get_TrxName());
            list.add(depexp);
        }
        return list;
    }

    public void process() {
        if (this.isProcessed()) {
            this.log.fine("@AlreadyProcessed@");
            return;
        }
        MDepreciationWorkfile assetBalance = this.getA_Depreciation_Workfile();
        if (assetBalance == null) {
            throw new AssetException("@NotFound@ @A_Depreciation_Workfile_ID@");
        }
        String entryType = this.getA_Entry_Type();
        if ("DEP".equals(entryType)) {
            MDepreciationExp.checkExistsNotProcessedEntries(this.getCtx(), this.getA_Asset_ID(), this.getDateAcct(), this.getPostingType(), this.get_TrxName());
            if (!assetBalance.getAsset().getA_Asset_Status().equals("AC")) {
                throw new AssetNotActiveException(assetBalance.getAsset().get_ID());
            }
            this.setDateAcct(assetBalance.getDateAcct());
            assetBalance.adjustAccumulatedDepr(this.getExpense(), this.getExpense_F(), false);
        }
        this.setProcessed(true);
        this.updateFrom(assetBalance);
        this.saveEx();
        assetBalance.setA_Current_Period();
        assetBalance.saveEx();
    }

    protected boolean beforeDelete() {
        if (this.isProcessed()) {
            MDepreciationWorkfile assetwk = this.getA_Depreciation_Workfile();
            assetwk.adjustAccumulatedDepr(this.getA_Accumulated_Depr().negate(), this.getA_Accumulated_Depr_F().negate(), false);
            assetwk.saveEx();
        }
        if (this.isPosted()) {
            MPeriod.testPeriodOpen((Properties)this.getCtx(), (Timestamp)this.getDateAcct(), (String)"GLD", (int)this.getAD_Org_ID());
            MDepreciationEntry.deleteFacts(this);
        }
        return true;
    }

    protected boolean afterDelete(boolean success) {
        if (!success) {
            return false;
        }
        if (this.isProcessed()) {
            MDepreciationWorkfile wk = this.getA_Depreciation_Workfile();
            wk.setA_Current_Period();
            wk.saveEx();
        }
        return true;
    }

    protected boolean isPosted() {
        return this.isProcessed() && this.getA_Depreciation_Entry_ID() > 0;
    }

    public static void checkExistsNotProcessedEntries(Properties ctx, int assetId, Timestamp dateAcct, String postingType, String trxName) {
        String whereClause = "A_Asset_ID=? AND TRUNC(DateAcct,'MONTH')<? AND PostingType=? AND Processed=?";
        boolean match = new Query(ctx, "A_Depreciation_Exp", "A_Asset_ID=? AND TRUNC(DateAcct,'MONTH')<? AND PostingType=? AND Processed=?", trxName).setParameters(new Object[]{assetId, TimeUtil.getMonthFirstDay((Timestamp)dateAcct), postingType, false}).match();
        if (match) {
            throw new AssetException("There are unprocessed records to date");
        }
    }

    public static List<MDepreciationExp> getNotProcessedEntries(Properties ctx, int assetId, String postingType, String trxName) {
        String whereClause = "A_Asset_ID=? AND PostingType=? AND Processed=?";
        List list = new Query(ctx, "A_Depreciation_Exp", "A_Asset_ID=? AND PostingType=? AND Processed=?", trxName).setParameters(new Object[]{assetId, postingType, false}).list();
        return list;
    }

    public static List<MDepreciationExp> getEntries(Properties ctx, int assetId, String postingType, String trxName) {
        String whereClause = "A_Asset_ID=? AND PostingType=?";
        return new Query(ctx, "A_Depreciation_Exp", "A_Asset_ID=? AND PostingType=?", trxName).setParameters(new Object[]{assetId, postingType}).setOrderBy("A_Period").list();
    }

    public void setProcessed(boolean Processed) {
        super.setProcessed(Processed);
        if (this.get_ID() > 0) {
            String sql = "UPDATE A_Depreciation_Exp SET Processed=? WHERE A_Depreciation_Exp_ID=?";
            DB.executeUpdateEx((String)"UPDATE A_Depreciation_Exp SET Processed=? WHERE A_Depreciation_Exp_ID=?", (Object[])new Object[]{Processed, this.get_ID()}, (String)this.get_TrxName());
        }
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "[" + this.get_ID() + ",A_Asset_ID=" + this.getA_Asset_ID() + ",A_Period=" + this.getA_Period() + ",DateAcct=" + String.valueOf(this.getDateAcct()) + ",Expense=" + String.valueOf(this.getExpense()) + ",Entry_ID=" + this.getA_Depreciation_Entry_ID() + "]";
    }
}

