/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.util.Properties;
import org.compiere.model.CalloutEngine;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.MOrderLine;
import org.compiere.model.MPriceList;
import org.compiere.model.MProduct;
import org.compiere.model.MProductPricing;
import org.compiere.model.MStorage;
import org.compiere.model.MUOM;
import org.compiere.model.MUOMConversion;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class EkStockValidator
extends CalloutEngine {
    private boolean steps = false;

    public String amt(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        MProduct product;
        if (this.isCalloutActive() || value == null) {
            return "";
        }
        if (this.steps) {
            this.log.warning("init");
        }
        int uOMToId = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"C_UOM_ID");
        int productId = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"M_Product_ID");
        int priceListId = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"M_PriceList_ID");
        int standardPrecision = MPriceList.getStandardPrecision((Properties)ctx, (int)priceListId);
        BigDecimal quantityEntered = (BigDecimal)mTab.getValue("QtyEntered");
        BigDecimal quantityOrdered = (BigDecimal)mTab.getValue("QtyOrdered");
        this.log.fine("QtyEntered=" + String.valueOf(quantityEntered) + ", Ordered=" + String.valueOf(quantityOrdered) + ", UOM=" + uOMToId);
        BigDecimal priceEntered = (BigDecimal)mTab.getValue("PriceEntered");
        BigDecimal priceActual = (BigDecimal)mTab.getValue("PriceActual");
        BigDecimal discount = (BigDecimal)mTab.getValue("Discount");
        BigDecimal priceLimit = (BigDecimal)mTab.getValue("PriceLimit");
        BigDecimal priceList = (BigDecimal)mTab.getValue("PriceList");
        this.log.fine("PriceList=" + String.valueOf(priceList) + ", Limit=" + String.valueOf(priceLimit) + ", Precision=" + standardPrecision);
        this.log.fine("PriceEntered=" + String.valueOf(priceEntered) + ", Actual=" + String.valueOf(priceActual) + ", Discount=" + String.valueOf(discount));
        if (productId == 0) {
            if (mField.getColumnName().equals("PriceActual")) {
                priceEntered = (BigDecimal)value;
                mTab.setValue("PriceEntered", value);
            } else if (mField.getColumnName().equals("PriceEntered")) {
                priceActual = (BigDecimal)value;
                mTab.setValue("PriceActual", value);
            }
        } else if ((mField.getColumnName().equals("QtyOrdered") || mField.getColumnName().equals("QtyEntered") || mField.getColumnName().equals("C_UOM_ID") || mField.getColumnName().equals("M_Product_ID")) && !"N".equals(Env.getContext((Properties)ctx, (int)WindowNo, (String)"DiscountSchema"))) {
            int C_BPartner_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"C_BPartner_ID");
            if (mField.getColumnName().equals("QtyEntered")) {
                quantityOrdered = MUOMConversion.convertProductFrom((Properties)ctx, (int)productId, (int)uOMToId, (BigDecimal)quantityEntered);
            }
            if (quantityOrdered == null) {
                quantityOrdered = quantityEntered;
            }
            boolean IsSOTrx = Env.getContext((Properties)ctx, (int)WindowNo, (String)"IsSOTrx").equals("Y");
            MProductPricing pp = new MProductPricing(productId, C_BPartner_ID, quantityOrdered, IsSOTrx, null);
            pp.setM_PriceList_ID(priceListId);
            int priceListVersionId = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"M_PriceList_Version_ID");
            pp.setM_PriceList_Version_ID(priceListVersionId);
            Timestamp date = (Timestamp)mTab.getValue("DateOrdered");
            pp.setPriceDate(date);
            if (pp.getPriceStd().compareTo(Env.ZERO) > 0) {
                priceEntered = MUOMConversion.convertProductFrom((Properties)ctx, (int)productId, (int)uOMToId, (BigDecimal)pp.getPriceStd());
                if (priceEntered == null) {
                    priceEntered = pp.getPriceStd();
                }
                this.log.fine("QtyChanged -> PriceActual=" + String.valueOf(pp.getPriceStd()) + ", PriceEntered=" + String.valueOf(priceEntered) + ", Discount=" + String.valueOf(pp.getDiscount()));
                priceActual = pp.getPriceStd();
                mTab.setValue("PriceActual", (Object)pp.getPriceStd());
                mTab.setValue("Discount", (Object)pp.getDiscount());
                mTab.setValue("PriceEntered", (Object)priceEntered);
            }
            Env.setContext((Properties)ctx, (int)WindowNo, (String)"DiscountSchema", (String)(pp.isDiscountSchema() ? "Y" : "N"));
        } else if (mField.getColumnName().equals("PriceActual")) {
            priceActual = (BigDecimal)value;
            priceEntered = MUOMConversion.convertProductFrom((Properties)ctx, (int)productId, (int)uOMToId, (BigDecimal)priceActual);
            if (priceEntered == null) {
                priceEntered = priceActual;
            }
            this.log.fine("PriceActual=" + String.valueOf(priceActual) + " -> PriceEntered=" + String.valueOf(priceEntered));
            mTab.setValue("PriceEntered", (Object)priceEntered);
        } else if (mField.getColumnName().equals("PriceEntered")) {
            priceEntered = (BigDecimal)value;
            priceActual = MUOMConversion.convertProductTo((Properties)ctx, (int)productId, (int)uOMToId, (BigDecimal)priceEntered);
            if (priceActual == null) {
                priceActual = priceEntered;
            }
            this.log.fine("PriceEntered=" + String.valueOf(priceEntered) + " -> PriceActual=" + String.valueOf(priceActual));
            mTab.setValue("PriceActual", (Object)priceActual);
        }
        if (mField.getColumnName().equals("Discount")) {
            if (priceList.doubleValue() != 0.0) {
                priceActual = new BigDecimal((100.0 - discount.doubleValue()) / 100.0 * priceList.doubleValue());
            }
            if (priceActual.scale() > standardPrecision) {
                priceActual = priceActual.setScale(standardPrecision, RoundingMode.HALF_UP);
            }
            if ((priceEntered = MUOMConversion.convertProductFrom((Properties)ctx, (int)productId, (int)uOMToId, (BigDecimal)priceActual)) == null) {
                priceEntered = priceActual;
            }
            mTab.setValue("PriceActual", (Object)priceActual);
            mTab.setValue("PriceEntered", (Object)priceEntered);
        } else {
            discount = priceList.intValue() == 0 ? Env.ZERO : new BigDecimal((priceList.doubleValue() - priceActual.doubleValue()) / priceList.doubleValue() * 100.0);
            if (discount.scale() > 2) {
                discount = discount.setScale(2, RoundingMode.HALF_UP);
            }
            mTab.setValue("Discount", (Object)discount);
        }
        this.log.fine("PriceEntered=" + String.valueOf(priceEntered) + ", Actual=" + String.valueOf(priceActual) + ", Discount=" + String.valueOf(discount));
        if (MPriceList.isCheckPriceLimit((Integer)priceListId).booleanValue() && priceLimit.doubleValue() != 0.0 && priceActual.compareTo(priceLimit) < 0) {
            priceActual = priceLimit;
            priceEntered = MUOMConversion.convertProductFrom((Properties)ctx, (int)productId, (int)uOMToId, (BigDecimal)priceLimit);
            if (priceEntered == null) {
                priceEntered = priceLimit;
            }
            this.log.fine("(under) PriceEntered=" + String.valueOf(priceEntered) + ", Actual" + String.valueOf(priceLimit));
            mTab.setValue("PriceActual", (Object)priceLimit);
            mTab.setValue("PriceEntered", (Object)priceEntered);
            mTab.fireDataStatusEEvent("UnderLimitPrice", "", false);
            if (priceList.intValue() != 0) {
                discount = new BigDecimal((priceList.doubleValue() - priceActual.doubleValue()) / priceList.doubleValue() * 100.0);
                if (discount.scale() > 2) {
                    discount = discount.setScale(2, RoundingMode.HALF_UP);
                }
                mTab.setValue("Discount", (Object)discount);
            }
        }
        BigDecimal lineNetAmount = null;
        if (productId != 0 && (product = MProduct.get(ctx, productId)).getC_UOM_ID() != uOMToId && priceEntered != null && !priceEntered.equals(Env.ZERO) && quantityEntered != null && !quantityEntered.equals(Env.ZERO)) {
            lineNetAmount = quantityEntered.multiply(priceEntered);
        }
        if (lineNetAmount == null) {
            lineNetAmount = quantityOrdered.multiply(priceActual);
        }
        if (lineNetAmount.scale() > standardPrecision) {
            lineNetAmount = lineNetAmount.setScale(standardPrecision, RoundingMode.HALF_UP);
        }
        this.log.info("LineNetAmt=" + String.valueOf(lineNetAmount));
        mTab.setValue("LineNetAmt", (Object)lineNetAmount);
        return "";
    }

    public String qty(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        int C_UOM_To_ID;
        System.out.println("Inicio del m\u00e9todo qty");
        if (value == null) {
            System.out.println("El valor recibido es nulo, terminando ejecuci\u00f3n.");
            return "";
        }
        int M_Product_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"M_Product_ID");
        System.out.println("Producto ID: " + M_Product_ID);
        BigDecimal QtyOrdered = Env.ZERO;
        if (M_Product_ID == 0) {
            BigDecimal QtyEntered;
            System.out.println("Producto ID es 0, asignando valores predeterminados.");
            QtyOrdered = QtyEntered = (BigDecimal)mTab.getValue("QtyEntered");
            mTab.setValue("QtyOrdered", (Object)QtyOrdered);
        } else if (mField.getColumnName().equals("C_UOM_ID")) {
            BigDecimal PriceActual;
            BigDecimal PriceEntered;
            System.out.println("Cambio en la unidad de medida (C_UOM_ID).");
            C_UOM_To_ID = (Integer)value;
            BigDecimal QtyEntered = (BigDecimal)mTab.getValue("QtyEntered");
            BigDecimal QtyEntered1 = QtyEntered.setScale(MUOM.getPrecision((Properties)ctx, (int)C_UOM_To_ID), RoundingMode.HALF_UP);
            if (QtyEntered.compareTo(QtyEntered1) != 0) {
                System.out.println("Corrigiendo escala de QtyEntered.");
                QtyEntered = QtyEntered1;
                mTab.setValue("QtyEntered", (Object)QtyEntered);
            }
            if ((QtyOrdered = MUOMConversion.convertProductFrom((Properties)ctx, (int)M_Product_ID, (int)C_UOM_To_ID, (BigDecimal)QtyEntered)) == null) {
                QtyOrdered = QtyEntered;
            }
            if ((PriceEntered = MUOMConversion.convertProductFrom((Properties)ctx, (int)M_Product_ID, (int)C_UOM_To_ID, (BigDecimal)(PriceActual = (BigDecimal)mTab.getValue("PriceActual")))) == null) {
                PriceEntered = PriceActual;
            }
            System.out.println("UOM conversion: QtyOrdered=" + String.valueOf(QtyOrdered) + ", PriceEntered=" + String.valueOf(PriceEntered));
            mTab.setValue("QtyOrdered", (Object)QtyOrdered);
            mTab.setValue("PriceEntered", (Object)PriceEntered);
        } else if (mField.getColumnName().equals("QtyEntered")) {
            System.out.println("Cambio en QtyEntered.");
            C_UOM_To_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"C_UOM_ID");
            BigDecimal QtyEntered = (BigDecimal)value;
            BigDecimal QtyEntered1 = QtyEntered.setScale(MUOM.getPrecision((Properties)ctx, (int)C_UOM_To_ID), RoundingMode.HALF_UP);
            if (QtyEntered.compareTo(QtyEntered1) != 0) {
                System.out.println("Corrigiendo escala de QtyEntered.");
                QtyEntered = QtyEntered1;
                mTab.setValue("QtyEntered", (Object)QtyEntered);
            }
            if ((QtyOrdered = MUOMConversion.convertProductFrom((Properties)ctx, (int)M_Product_ID, (int)C_UOM_To_ID, (BigDecimal)QtyEntered)) == null) {
                QtyOrdered = QtyEntered;
            }
            System.out.println("QtyEntered=" + String.valueOf(QtyEntered) + " -> QtyOrdered=" + String.valueOf(QtyOrdered));
            mTab.setValue("QtyOrdered", (Object)QtyOrdered);
        } else if (mField.getColumnName().equals("QtyOrdered")) {
            BigDecimal QtyEntered;
            System.out.println("Cambio en QtyOrdered.");
            C_UOM_To_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"C_UOM_ID");
            QtyOrdered = (BigDecimal)value;
            int precision = MProduct.get(ctx, M_Product_ID).getUOMPrecision();
            BigDecimal QtyOrdered1 = QtyOrdered.setScale(precision, RoundingMode.HALF_UP);
            if (QtyOrdered.compareTo(QtyOrdered1) != 0) {
                System.out.println("Corrigiendo escala de QtyOrdered.");
                QtyOrdered = QtyOrdered1;
                mTab.setValue("QtyOrdered", (Object)QtyOrdered);
            }
            if ((QtyEntered = MUOMConversion.convertProductTo((Properties)ctx, (int)M_Product_ID, (int)C_UOM_To_ID, (BigDecimal)QtyOrdered)) == null) {
                QtyEntered = QtyOrdered;
            }
            System.out.println("QtyOrdered=" + String.valueOf(QtyOrdered) + " -> QtyEntered=" + String.valueOf(QtyEntered));
            mTab.setValue("QtyEntered", (Object)QtyEntered);
        } else {
            System.out.println("No hubo cambios en QtyEntered o QtyOrdered.");
            QtyOrdered = (BigDecimal)mTab.getValue("QtyOrdered");
        }
        if (M_Product_ID != 0 && Env.isSOTrx((Properties)ctx, (int)WindowNo) && QtyOrdered.signum() > 0) {
            System.out.println("Verificando stock disponible.");
            MProduct product = MProduct.get(ctx, M_Product_ID);
            if (product.isStocked()) {
                int M_AttributeSetInstance_ID;
                int M_Warehouse_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"M_Warehouse_ID");
                BigDecimal available = MStorage.getQtyAvailable(M_Warehouse_ID, M_Product_ID, M_AttributeSetInstance_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"M_AttributeSetInstance_ID"), null);
                if (available == null) {
                    available = Env.ZERO;
                }
                System.out.println("Stock disponible: " + String.valueOf(available));
                if (available.signum() == 0) {
                    String info = Msg.parseTranslation((Properties)ctx, (String)("@QtyAvailable@=" + String.valueOf(available)));
                    mTab.fireDataStatusEEvent("InsufficientQtyAvailable", info, true);
                } else if (available.compareTo(QtyOrdered) < 0) {
                    String info = Msg.parseTranslation((Properties)ctx, (String)("@QtyAvailable@=" + String.valueOf(available)));
                    mTab.fireDataStatusEEvent("InsufficientQtyAvailable", info, true);
                } else {
                    BigDecimal notReserved;
                    Integer C_OrderLine_ID = (Integer)mTab.getValue("C_OrderLine_ID");
                    if (C_OrderLine_ID == null) {
                        C_OrderLine_ID = 0;
                    }
                    if ((notReserved = MOrderLine.getNotReserved(ctx, M_Warehouse_ID, M_Product_ID, M_AttributeSetInstance_ID, C_OrderLine_ID)) == null) {
                        notReserved = Env.ZERO;
                    }
                    BigDecimal total = available.subtract(notReserved);
                    System.out.println("Stock despu\u00e9s de reservas: " + String.valueOf(total));
                    if (total.compareTo(QtyOrdered) < 0) {
                        String info = Msg.parseTranslation((Properties)ctx, (String)("@QtyAvailable@=" + String.valueOf(available)));
                        mTab.fireDataStatusEEvent("InsufficientQtyAvailable", info, true);
                    }
                }
            }
        }
        System.out.println("Fin del m\u00e9todo qty");
        return "";
    }
}

