/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.core.domains.models.X_C_BankStatementMatcher;
import org.compiere.impexp.BankStatementMatcherInterface;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.Env;

public class MBankStatementMatcher
extends X_C_BankStatementMatcher {
    private static final long serialVersionUID = -3756318777177414260L;
    private static CCache<String, List<MBankStatementMatcher>> cache = new CCache("C_BankStatementMatcher", 40, 5);
    private static CCache<Integer, MBankStatementMatcher> matchersCacheIds = new CCache("C_BankStatementMatcher", 30);
    private static CLogger s_log = CLogger.getCLogger(MBankStatementMatcher.class);
    private BankStatementMatcherInterface m_matcher = null;
    private Boolean m_matcherValid = null;

    public static MBankStatementMatcher[] getMatchers(Properties ctx, String trxName) {
        List<MBankStatementMatcher> list = MBankStatementMatcher.getMatchersList(ctx, 0);
        if (list != null) {
            MBankStatementMatcher[] retValue = new MBankStatementMatcher[list.size()];
            list.toArray(retValue);
            return retValue;
        }
        return null;
    }

    public static List<MBankStatementMatcher> getMatchersList(Properties ctx, int bankId) {
        String key = Env.getAD_Client_ID((Properties)ctx) + "|" + bankId;
        List matcherList = (List)cache.get((Object)key);
        if (matcherList == null) {
            s_log.fine("Not from cache");
            StringBuffer whereClause = new StringBuffer();
            if (bankId > 0) {
                whereClause.append("EXISTS(SELECT 1 FROM C_BankMatcher bm WHERE bm.C_Bank_ID = ").append(bankId).append(" AND bm.C_BankStatementMatcher_ID = C_BankStatementMatcher.C_BankStatementMatcher_ID)");
            }
            if ((matcherList = new Query(ctx, "C_BankStatementMatcher", whereClause.toString(), null).setOrderBy("SeqNo").setClient_ID().setOnlyActiveRecords(true).list()) != null) {
                cache.put((Object)key, (Object)matcherList);
            }
        }
        return matcherList;
    }

    public MBankStatementMatcher(Properties ctx, int C_BankStatementMatcher_ID, String trxName) {
        super(ctx, C_BankStatementMatcher_ID, trxName);
    }

    public MBankStatementMatcher(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public boolean isMatcherValid() {
        if (this.m_matcherValid == null) {
            this.getMatcher();
        }
        return this.m_matcherValid;
    }

    public BankStatementMatcherInterface getMatcher() {
        if (this.m_matcher != null || this.m_matcherValid != null && this.m_matcherValid.booleanValue()) {
            return this.m_matcher;
        }
        String className = this.getClassname();
        if (className == null || className.length() == 0) {
            return null;
        }
        try {
            Class<?> matcherClass = Class.forName(className);
            this.m_matcher = (BankStatementMatcherInterface)matcherClass.newInstance();
            this.m_matcherValid = Boolean.TRUE;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, className, (Throwable)e);
            this.m_matcher = null;
            this.m_matcherValid = Boolean.FALSE;
        }
        return this.m_matcher;
    }

    public static MBankStatementMatcher getById(Properties ctx, int matcherId) {
        if (matcherId <= 0) {
            return null;
        }
        MBankStatementMatcher matcher = (MBankStatementMatcher)((Object)matchersCacheIds.get((Object)matcherId));
        if (matcher != null && matcher.get_ID() > 0) {
            return matcher;
        }
        matcher = (MBankStatementMatcher)new Query(ctx, "C_BankStatementMatcher", "C_BankStatementMatcher_ID=?", null).setClient_ID().setParameters(new Object[]{matcherId}).first();
        if (matcher != null && matcher.get_ID() > 0) {
            matchersCacheIds.put((Object)matcher.get_ID(), (Object)matcher);
        }
        return matcher;
    }
}

