/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.Properties;
import org.adempiere.core.domains.models.X_C_ElementValue;
import org.adempiere.core.domains.models.X_I_ElementValue;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MAccount;
import org.compiere.model.MClient;
import org.compiere.model.PO;
import org.compiere.model.POResultSet;
import org.compiere.model.Query;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MElementValue
extends X_C_ElementValue {
    private static final long serialVersionUID = 4765839867934329276L;

    public MElementValue(Properties ctx, int C_ElementValue_ID, String trxName) {
        super(ctx, C_ElementValue_ID, trxName);
        if (C_ElementValue_ID == 0) {
            this.setIsSummary(false);
            this.setAccountSign("N");
            this.setAccountType("E");
            this.setIsDocControlled(false);
            this.setIsForeignCurrency(false);
            this.setIsBankAccount(false);
            this.setPostActual(true);
            this.setPostBudget(true);
            this.setPostEncumbrance(true);
            this.setPostStatistical(true);
        }
    }

    public MElementValue(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MElementValue(Properties ctx, String Value, String Name2, String Description, String AccountType, String AccountSign, boolean IsDocControlled, boolean IsSummary, String trxName) {
        this(ctx, 0, trxName);
        this.setValue(Value);
        this.setName(Name2);
        this.setDescription(Description);
        this.setAccountType(AccountType);
        this.setAccountSign(AccountSign);
        this.setIsDocControlled(IsDocControlled);
        this.setIsSummary(IsSummary);
    }

    public MElementValue(X_I_ElementValue imp) {
        this(imp.getCtx(), 0, imp.get_TrxName());
        this.setClientOrg((PO)imp);
        this.set(imp);
    }

    public void set(X_I_ElementValue imp) {
        this.setValue(imp.getValue());
        this.setName(imp.getName());
        this.setDescription(imp.getDescription());
        this.setAccountType(imp.getAccountType());
        this.setAccountSign(imp.getAccountSign());
        this.setIsSummary(imp.isSummary());
        this.setIsDocControlled(imp.isDocControlled());
        this.setC_Element_ID(imp.getC_Element_ID());
        this.setPostActual(imp.isPostActual());
        this.setPostBudget(imp.isPostBudget());
        this.setPostEncumbrance(imp.isPostEncumbrance());
        this.setPostStatistical(imp.isPostStatistical());
    }

    public boolean isBalanceSheet() {
        String accountType = this.getAccountType();
        return "A".equals(accountType) || "L".equals(accountType) || "O".equals(accountType);
    }

    public boolean isActiva() {
        return "A".equals(this.getAccountType());
    }

    public boolean isPassiva() {
        String accountType = this.getAccountType();
        return "L".equals(accountType) || "O".equals(accountType);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getValue()).append(" - ").append(this.getName());
        return sb.toString();
    }

    public String toStringX() {
        StringBuffer sb = new StringBuffer("MElementValue[");
        sb.append(this.get_ID()).append(",").append(this.getValue()).append(" - ").append(this.getName()).append("]");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean beforeSave(boolean newRecord) {
        if (this.getAD_Org_ID() != 0) {
            this.setAD_Org_ID(0);
        }
        if (!newRecord && this.isSummary() && this.is_ValueChanged("IsSummary")) {
            boolean match = new Query(this.getCtx(), "Fact_Acct", "Account_ID=?", this.get_TrxName()).setParameters(new Object[]{this.getC_ElementValue_ID()}).match();
            if (match) {
                throw new AdempiereException("@AlreadyPostedTo@");
            }
            String whereClause = "Account_ID=?";
            try (POResultSet rs = new Query(this.getCtx(), "C_ValidCombination", whereClause, this.get_TrxName()).setParameters(new Object[]{this.get_ID()}).scroll();){
                while (rs.hasNext()) {
                    ((MAccount)rs.next()).deleteEx(true);
                }
            }
        }
        return true;
    }

    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!newRecord && (this.is_ValueChanged("Value") || this.is_ValueChanged("Name"))) {
            MAccount.updateValueDescription((Properties)this.getCtx(), (String)("Account_ID=" + this.getC_ElementValue_ID()), (String)this.get_TrxName());
            if ("Y".equals(Env.getContext((Properties)this.getCtx(), (String)"$Element_U1"))) {
                MAccount.updateValueDescription((Properties)this.getCtx(), (String)("User1_ID=" + this.getC_ElementValue_ID()), (String)this.get_TrxName());
            }
            if ("Y".equals(Env.getContext((Properties)this.getCtx(), (String)"$Element_U2"))) {
                MAccount.updateValueDescription((Properties)this.getCtx(), (String)("User2_ID=" + this.getC_ElementValue_ID()), (String)this.get_TrxName());
            }
            if ("Y".equals(Env.getContext((Properties)this.getCtx(), (String)"$Element_U3"))) {
                MAccount.updateValueDescription((Properties)this.getCtx(), (String)("User3_ID=" + this.getC_ElementValue_ID()), (String)this.get_TrxName());
            }
            if ("Y".equals(Env.getContext((Properties)this.getCtx(), (String)"$Element_U4"))) {
                MAccount.updateValueDescription((Properties)this.getCtx(), (String)("User4_ID=" + this.getC_ElementValue_ID()), (String)this.get_TrxName());
            }
        }
        return success;
    }

    public void CreateCombination() {
        int Scheme = DB.getSQLValue(null, (String)("select C_AcctSchema_ID from C_AcctSchema where isactive='Y' and AD_Client_ID=" + this.getAD_Client_ID()));
        MAccount acct = MAccount.get((Properties)this.getCtx(), (int)this.getAD_Client_ID(), (int)0, (int)Scheme, (int)this.getC_ElementValue_ID(), (int)0, (int)0, (int)0, (int)0, (int)0, (int)0, (int)0, (int)0, (int)0, (int)0, (int)0, (int)0, (int)0, (int)0, (int)0, (int)0, (String)this.get_TrxName());
        MClient mClient = MClient.get((Properties)this.getCtx());
        acct.setAlias(mClient.getValue() + "-" + this.getValue());
        acct.setCombination(this.getValue() + "-" + this.getName());
        acct.save();
    }
}

