/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.File;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.TreeSet;
import java.util.logging.Level;
import org.adempiere.core.domains.models.I_C_Order;
import org.adempiere.core.domains.models.I_C_OrderLine;
import org.adempiere.core.domains.models.I_M_InOutLine;
import org.adempiere.core.domains.models.X_M_InOut;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.PeriodClosedException;
import org.compiere.model.MAttributeSet;
import org.compiere.model.MAttributeSetInstance;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MDocType;
import org.compiere.model.MDocTypeCounter;
import org.compiere.model.MInOutConfirm;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInOutLineMA;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MMatchInv;
import org.compiere.model.MMatchPO;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MOrg;
import org.compiere.model.MOrgInfo;
import org.compiere.model.MPeriod;
import org.compiere.model.MProduct;
import org.compiere.model.MRMA;
import org.compiere.model.MRMALine;
import org.compiere.model.MRefList;
import org.compiere.model.MStorage;
import org.compiere.model.MSysConfig;
import org.compiere.model.MTransaction;
import org.compiere.model.MUser;
import org.compiere.model.MWarehouse;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.print.ReportEngine;
import org.compiere.process.DocAction;
import org.compiere.process.DocumentEngine;
import org.compiere.process.DocumentReversalEnabled;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class MInOut
extends X_M_InOut
implements DocAction,
DocumentReversalEnabled {
    private static final long serialVersionUID = -239302197968535277L;
    private MInOutLine[] m_lines = null;
    private MInOutConfirm[] m_confirms = null;
    private MBPartner m_partner = null;
    private boolean isReversal = false;
    private String processMsg = null;
    private boolean justPrepared = false;
    ArrayList<PO> docsPostProcess = new ArrayList();

    public static MInOut createFrom(MOrder order, Timestamp movementDate, boolean forceDelivery, boolean allAttributeInstances, Timestamp minGuaranteeDate, boolean complete, String trxName) {
        if (order == null) {
            throw new IllegalArgumentException("No Order");
        }
        if (!forceDelivery && "L".equals(order.getDeliveryRule())) {
            return null;
        }
        MInOut retValue = new MInOut(order, 0, movementDate);
        retValue.setDocAction(complete ? "CO" : "PR");
        MOrderLine[] oLines = order.getLines(true, "M_Product_ID");
        block0: for (int i = 0; i < oLines.length; ++i) {
            BigDecimal qty = oLines[i].getQtyOrdered().subtract(oLines[i].getQtyDelivered());
            if (qty.signum() == 0) continue;
            MStorage[] storages = null;
            MProduct product = oLines[i].getProduct();
            if (product == null || product.get_ID() == 0 || !product.isStocked()) continue;
            String MMPolicy = product.getMMPolicy();
            storages = MStorage.getWarehouse(order.getCtx(), order.getM_Warehouse_ID(), oLines[i].getM_Product_ID(), oLines[i].getM_AttributeSetInstance_ID(), minGuaranteeDate, "F".equals(MMPolicy), true, 0, trxName);
            if (!forceDelivery) {
                BigDecimal maxQty = Env.ZERO;
                for (int ll = 0; ll < storages.length; ++ll) {
                    maxQty = maxQty.add(storages[ll].getQtyOnHand());
                }
                if ("A".equals(order.getDeliveryRule())) {
                    if (maxQty.compareTo(qty) < 0) {
                        qty = maxQty;
                    }
                } else if ("L".equals(order.getDeliveryRule()) && maxQty.compareTo(qty) < 0) continue;
            }
            if (retValue.get_ID() == 0) {
                retValue.save(trxName);
            }
            for (int ll = 0; ll < storages.length; ++ll) {
                BigDecimal lineQty = storages[ll].getQtyOnHand();
                if (lineQty.compareTo(qty) > 0) {
                    lineQty = qty;
                }
                MInOutLine inOutLine = new MInOutLine(retValue);
                inOutLine.setOrderLine(oLines[i], storages[ll].getM_Locator_ID(), order.isSOTrx() ? lineQty : Env.ZERO);
                inOutLine.setQty(lineQty);
                if (oLines[i].getQtyEntered().compareTo(oLines[i].getQtyOrdered()) != 0) {
                    inOutLine.setQtyEntered(lineQty.multiply(oLines[i].getQtyEntered()).divide(oLines[i].getQtyOrdered(), 12, RoundingMode.HALF_UP));
                }
                inOutLine.setC_Project_ID(oLines[i].getC_Project_ID());
                inOutLine.save(trxName);
                qty = qty.subtract(lineQty);
                if (qty.signum() == 0) continue block0;
            }
        }
        if (retValue.get_ID() == 0) {
            return null;
        }
        return retValue;
    }

    public static MInOut copyFrom(MInOut inOutfrom, Timestamp dateDoc, Timestamp dateAcct, int C_DocType_ID, boolean isSOTrx, boolean counter, boolean isReversal, String trxName, boolean setOrder) {
        MDocType docType;
        MInOut inOutTo = new MInOut(inOutfrom.getCtx(), 0, null);
        inOutTo.set_TrxName(trxName);
        MInOut.copyValues((PO)inOutfrom, (PO)inOutTo, (int)inOutfrom.getAD_Client_ID(), (int)inOutfrom.getAD_Org_ID());
        inOutTo.set_ValueNoCheck("M_InOut_ID", I_ZERO);
        inOutTo.set_ValueNoCheck("DocumentNo", null);
        if (isReversal) {
            inOutTo.setReversal(true);
            inOutTo.setReversal_ID(inOutfrom.getC_Invoice_ID());
            docType = MDocType.get((Properties)inOutfrom.getCtx(), (int)inOutfrom.getC_DocType_ID());
            if (docType.isCopyDocNoOnReversal()) {
                inOutTo.setDocumentNo(inOutfrom.getDocumentNo() + Msg.getMsg((Properties)inOutfrom.getCtx(), (String)"^"));
            }
        }
        inOutTo.setDocStatus("DR");
        inOutTo.setDocAction("CO");
        inOutTo.setC_DocType_ID(C_DocType_ID);
        inOutTo.setIsSOTrx(isSOTrx);
        if (counter) {
            docType = MDocType.get((Properties)inOutfrom.getCtx(), (int)C_DocType_ID);
            if ("MMS".equals(docType.getDocBaseType())) {
                inOutTo.setMovementType(isSOTrx ? "C-" : "V-");
            } else if ("MMR".equals(docType.getDocBaseType())) {
                inOutTo.setMovementType(isSOTrx ? "C+" : "V+");
            }
        }
        inOutTo.setDateOrdered(dateDoc);
        inOutTo.setDateAcct(dateAcct);
        inOutTo.setMovementDate(dateDoc);
        inOutTo.setDatePrinted(null);
        inOutTo.setIsPrinted(false);
        inOutTo.setDateReceived(null);
        inOutTo.setNoPackages(0);
        inOutTo.setShipDate(null);
        inOutTo.setPickDate(null);
        inOutTo.setIsInTransit(false);
        inOutTo.setIsApproved(false);
        inOutTo.setC_Invoice_ID(0);
        inOutTo.setTrackingNo(null);
        inOutTo.setIsInDispute(false);
        inOutTo.setPosted(false);
        inOutTo.setProcessed(false);
        inOutTo.setProcessing(false);
        inOutTo.setC_Order_ID(0);
        inOutTo.setM_RMA_ID(0);
        if (counter) {
            DocAction peer;
            inOutTo.setC_Order_ID(0);
            inOutTo.setRef_InOut_ID(inOutfrom.getM_InOut_ID());
            if (inOutfrom.getC_Order_ID() != 0 && (peer = new MOrder(inOutfrom.getCtx(), inOutfrom.getC_Order_ID(), inOutfrom.get_TrxName())).getRef_Order_ID() != 0) {
                inOutTo.setC_Order_ID(peer.getRef_Order_ID());
            }
            if (inOutfrom.getC_Invoice_ID() != 0 && (peer = new MInvoice(inOutfrom.getCtx(), inOutfrom.getC_Invoice_ID(), inOutfrom.get_TrxName())).getRef_Invoice_ID() != 0) {
                inOutTo.setC_Invoice_ID(peer.getRef_Invoice_ID());
            }
            if (inOutfrom.getM_RMA_ID() != 0 && (peer = new MRMA(inOutfrom.getCtx(), inOutfrom.getM_RMA_ID(), inOutfrom.get_TrxName())).getRef_RMA_ID() > 0) {
                inOutTo.setM_RMA_ID(peer.getRef_RMA_ID());
            }
        } else {
            inOutTo.setRef_InOut_ID(0);
            if (setOrder) {
                inOutTo.setC_Order_ID(inOutfrom.getC_Order_ID());
                inOutTo.setM_RMA_ID(inOutfrom.getM_RMA_ID());
            }
        }
        inOutTo.saveEx(trxName);
        if (counter) {
            inOutfrom.setRef_InOut_ID(inOutTo.getM_InOut_ID());
        }
        if (inOutTo.copyLinesFrom(inOutfrom, counter, setOrder) <= 0) {
            throw new IllegalStateException("Could not create Shipment Lines");
        }
        return inOutTo;
    }

    public MInOut(Properties ctx, int inOutId, String trxName) {
        super(ctx, inOutId, trxName);
        if (inOutId == 0) {
            this.setIsSOTrx(false);
            this.setMovementDate(new Timestamp(System.currentTimeMillis()));
            this.setDateAcct(this.getMovementDate());
            this.setDeliveryRule("A");
            this.setDeliveryViaRule("P");
            this.setFreightCostRule("I");
            this.setDocStatus("DR");
            this.setDocAction("CO");
            this.setPriorityRule("5");
            this.setNoPackages(0);
            this.setIsInTransit(false);
            this.setIsPrinted(false);
            this.setSendEMail(false);
            this.setIsInDispute(false);
            this.setIsApproved(false);
            super.setProcessed(false);
            this.setProcessing(false);
            this.setPosted(false);
        }
    }

    public MInOut(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MInOut(MOrder order, int docTypeShipmentId, Timestamp movementDate) {
        this(order.getCtx(), 0, order.get_TrxName());
        this.setClientOrg((PO)order);
        this.setC_BPartner_ID(order.getC_BPartner_ID());
        this.setC_BPartner_Location_ID(order.getC_BPartner_Location_ID());
        this.setAD_User_ID(order.getAD_User_ID());
        this.setM_Warehouse_ID(order.getM_Warehouse_ID());
        this.setIsSOTrx(order.isSOTrx());
        if (docTypeShipmentId == 0) {
            docTypeShipmentId = DB.getSQLValue(null, (String)"SELECT C_DocTypeShipment_ID FROM C_DocType WHERE C_DocType_ID=?", (int)order.getC_DocType_ID());
        }
        this.setC_DocType_ID(docTypeShipmentId);
        String movementTypeShipment = null;
        MDocType dtShipment = new MDocType(order.getCtx(), docTypeShipmentId, order.get_TrxName());
        if (dtShipment.getDocBaseType().equals("MMS")) {
            movementTypeShipment = dtShipment.isSOTrx() ? "C-" : "V-";
        } else if (dtShipment.getDocBaseType().equals("MMR")) {
            movementTypeShipment = dtShipment.isSOTrx() ? "C+" : "V+";
        }
        this.setMovementType(movementTypeShipment);
        if (movementDate != null) {
            this.setMovementDate(movementDate);
        }
        this.setDateAcct(this.getMovementDate());
        this.setC_Order_ID(order.getC_Order_ID());
        this.setDeliveryRule(order.getDeliveryRule());
        this.setDeliveryViaRule(order.getDeliveryViaRule());
        this.setM_Shipper_ID(order.getM_Shipper_ID());
        this.setFreightCostRule(order.getFreightCostRule());
        this.setFreightAmt(order.getFreightAmt());
        this.setM_FreightCategory_ID(order.getM_FreightCategory_ID());
        this.setSalesRep_ID(order.getSalesRep_ID());
        this.setC_Activity_ID(order.getC_Activity_ID());
        this.setC_Campaign_ID(order.getC_Campaign_ID());
        this.setC_Charge_ID(order.getC_Charge_ID());
        this.setChargeAmt(order.getChargeAmt());
        this.setC_Project_ID(order.getC_Project_ID());
        this.setDateOrdered(order.getDateOrdered());
        this.setDescription(order.getDescription());
        this.setPOReference(order.getPOReference());
        this.setSalesRep_ID(order.getSalesRep_ID());
        this.setAD_OrgTrx_ID(order.getAD_OrgTrx_ID());
        this.setUser1_ID(order.getUser1_ID());
        this.setUser2_ID(order.getUser2_ID());
        this.setUser3_ID(order.getUser3_ID());
        this.setUser4_ID(order.getUser4_ID());
        this.setPriorityRule(order.getPriorityRule());
        this.setIsDropShip(order.isDropShip());
        this.setDropShip_BPartner_ID(order.getDropShip_BPartner_ID());
        this.setDropShip_Location_ID(order.getDropShip_Location_ID());
        this.setDropShip_User_ID(order.getDropShip_User_ID());
    }

    public MInOut(MInvoice invoice, int C_DocTypeShipment_ID, Timestamp movementDate, int M_Warehouse_ID) {
        this(invoice.getCtx(), 0, invoice.get_TrxName());
        this.setClientOrg((PO)invoice);
        this.setC_BPartner_ID(invoice.getC_BPartner_ID());
        this.setC_BPartner_Location_ID(invoice.getC_BPartner_Location_ID());
        this.setAD_User_ID(invoice.getAD_User_ID());
        this.setM_Warehouse_ID(M_Warehouse_ID);
        this.setIsSOTrx(invoice.isSOTrx());
        this.setMovementType(invoice.isSOTrx() ? "C-" : "V+");
        MOrder order = null;
        if (invoice.getC_Order_ID() != 0) {
            order = new MOrder(invoice.getCtx(), invoice.getC_Order_ID(), invoice.get_TrxName());
        }
        if (C_DocTypeShipment_ID == 0 && order != null) {
            C_DocTypeShipment_ID = DB.getSQLValue(null, (String)"SELECT C_DocTypeShipment_ID FROM C_DocType WHERE C_DocType_ID=?", (int)order.getC_DocType_ID());
        }
        if (C_DocTypeShipment_ID != 0) {
            this.setC_DocType_ID(C_DocTypeShipment_ID);
        } else {
            this.setC_DocType_ID();
        }
        if (movementDate != null) {
            this.setMovementDate(movementDate);
        }
        this.setDateAcct(this.getMovementDate());
        this.setC_Order_ID(invoice.getC_Order_ID());
        this.setSalesRep_ID(invoice.getSalesRep_ID());
        this.setC_Activity_ID(invoice.getC_Activity_ID());
        this.setC_Campaign_ID(invoice.getC_Campaign_ID());
        this.setC_Charge_ID(invoice.getC_Charge_ID());
        this.setChargeAmt(invoice.getChargeAmt());
        this.setC_Project_ID(invoice.getC_Project_ID());
        this.setDateOrdered(invoice.getDateOrdered());
        this.setDescription(invoice.getDescription());
        this.setPOReference(invoice.getPOReference());
        this.setAD_OrgTrx_ID(invoice.getAD_OrgTrx_ID());
        this.setUser1_ID(invoice.getUser1_ID());
        this.setUser2_ID(invoice.getUser2_ID());
        this.setUser3_ID(invoice.getUser3_ID());
        this.setUser4_ID(invoice.getUser4_ID());
        if (order != null) {
            this.setDeliveryRule(order.getDeliveryRule());
            this.setDeliveryViaRule(order.getDeliveryViaRule());
            this.setM_Shipper_ID(order.getM_Shipper_ID());
            this.setFreightCostRule(order.getFreightCostRule());
            this.setFreightAmt(order.getFreightAmt());
            this.setIsDropShip(order.isDropShip());
            this.setDropShip_BPartner_ID(order.getDropShip_BPartner_ID());
            this.setDropShip_Location_ID(order.getDropShip_Location_ID());
            this.setDropShip_User_ID(order.getDropShip_User_ID());
        }
    }

    public MInOut(MInOut original, int C_DocTypeShipment_ID, Timestamp movementDate) {
        this(original.getCtx(), 0, original.get_TrxName());
        this.setClientOrg((PO)original);
        this.setC_BPartner_ID(original.getC_BPartner_ID());
        this.setC_BPartner_Location_ID(original.getC_BPartner_Location_ID());
        this.setAD_User_ID(original.getAD_User_ID());
        this.setM_Warehouse_ID(original.getM_Warehouse_ID());
        this.setIsSOTrx(original.isSOTrx());
        this.setMovementType(original.getMovementType());
        if (C_DocTypeShipment_ID == 0) {
            this.setC_DocType_ID(original.getC_DocType_ID());
        } else {
            this.setC_DocType_ID(C_DocTypeShipment_ID);
        }
        if (movementDate != null) {
            this.setMovementDate(movementDate);
        }
        this.setDateAcct(this.getMovementDate());
        this.setC_Order_ID(original.getC_Order_ID());
        this.setDeliveryRule(original.getDeliveryRule());
        this.setDeliveryViaRule(original.getDeliveryViaRule());
        this.setM_Shipper_ID(original.getM_Shipper_ID());
        this.setFreightCostRule(original.getFreightCostRule());
        this.setFreightAmt(original.getFreightAmt());
        this.setSalesRep_ID(original.getSalesRep_ID());
        this.setC_Activity_ID(original.getC_Activity_ID());
        this.setC_Campaign_ID(original.getC_Campaign_ID());
        this.setC_Charge_ID(original.getC_Charge_ID());
        this.setChargeAmt(original.getChargeAmt());
        this.setC_Project_ID(original.getC_Project_ID());
        this.setDateOrdered(original.getDateOrdered());
        this.setDescription(original.getDescription());
        this.setPOReference(original.getPOReference());
        this.setSalesRep_ID(original.getSalesRep_ID());
        this.setAD_OrgTrx_ID(original.getAD_OrgTrx_ID());
        this.setUser1_ID(original.getUser1_ID());
        this.setUser2_ID(original.getUser2_ID());
        this.setUser3_ID(original.getUser3_ID());
        this.setUser4_ID(original.getUser4_ID());
        this.setIsDropShip(original.isDropShip());
        this.setDropShip_BPartner_ID(original.getDropShip_BPartner_ID());
        this.setDropShip_Location_ID(original.getDropShip_Location_ID());
        this.setDropShip_User_ID(original.getDropShip_User_ID());
    }

    public String getDocStatusName() {
        return MRefList.getListName((Properties)this.getCtx(), (int)131, (String)this.getDocStatus());
    }

    public void addDescription(String description) {
        String desc = this.getDescription();
        if (desc == null) {
            this.setDescription(description);
        } else {
            this.setDescription(desc + " | " + description);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MInOut[").append(this.get_ID()).append("-").append(this.getDocumentNo()).append(",DocStatus=").append(this.getDocStatus()).append("]");
        return sb.toString();
    }

    public String getDocumentInfo() {
        MDocType dt = MDocType.get((Properties)this.getCtx(), (int)this.getC_DocType_ID());
        return dt.getName() + " " + this.getDocumentNo();
    }

    public File createPDF() {
        try {
            File temp = File.createTempFile(this.get_TableName() + this.get_ID() + "_", ".pdf");
            return this.createPDF(temp);
        }
        catch (Exception e) {
            this.log.severe("Could not create PDF - " + e.getMessage());
            return null;
        }
    }

    public File createPDF(File file) {
        ReportEngine re = ReportEngine.get((Properties)this.getCtx(), (int)1, (int)this.getM_InOut_ID(), (String)this.get_TrxName());
        if (re == null) {
            return null;
        }
        return re.getPDF(file);
    }

    public MInOutLine[] getLines(boolean requery) {
        if (this.m_lines != null && !requery) {
            MInOut.set_TrxName((PO[])this.m_lines, (String)this.get_TrxName());
            return this.m_lines;
        }
        List inOutLines = new Query(this.getCtx(), "M_InOutLine", "M_InOut_ID=?", this.get_TrxName()).setParameters(new Object[]{this.getM_InOut_ID()}).setOrderBy("Line").list();
        this.m_lines = new MInOutLine[inOutLines.size()];
        inOutLines.toArray(this.m_lines);
        return this.m_lines;
    }

    public MInOutLine[] getLines() {
        return this.getLines(false);
    }

    public MInOutConfirm[] getConfirmations(boolean requery) {
        if (this.m_confirms != null && !requery) {
            MInOut.set_TrxName((PO[])this.m_confirms, (String)this.get_TrxName());
            return this.m_confirms;
        }
        List list = new Query(this.getCtx(), "M_InOutConfirm", "M_InOut_ID=?", this.get_TrxName()).setParameters(new Object[]{this.getM_InOut_ID()}).list();
        this.m_confirms = new MInOutConfirm[list.size()];
        list.toArray(this.m_confirms);
        return this.m_confirms;
    }

    public int copyLinesFrom(MInOut inOutFrom, boolean counter, boolean setOrder) {
        if (this.isProcessed() || this.isPosted() || inOutFrom == null) {
            return 0;
        }
        MInOutLine[] fromLines = inOutFrom.getLines(true);
        int count = 0;
        for (int i = 0; i < fromLines.length; ++i) {
            MInOutLine line = new MInOutLine(this);
            MInOutLine fromLine = fromLines[i];
            line.set_TrxName(this.get_TrxName());
            if (counter) {
                PO.copyValues((PO)fromLine, (PO)line, (int)this.getAD_Client_ID(), (int)this.getAD_Org_ID());
            } else {
                PO.copyValues((PO)fromLine, (PO)line, (int)fromLine.getAD_Client_ID(), (int)fromLine.getAD_Org_ID());
            }
            line.setM_InOut_ID(this.getM_InOut_ID());
            line.set_ValueNoCheck("M_InOutLine_ID", I_ZERO);
            if (!setOrder) {
                line.setC_OrderLine_ID(0);
                line.setM_RMALine_ID(0);
            }
            line.setM_AttributeSetInstance_ID(fromLine.getM_AttributeSetInstance_ID());
            line.setRef_InOutLine_ID(0);
            line.setIsInvoiced(false);
            line.setConfirmedQty(Env.ZERO);
            line.setPickedQty(Env.ZERO);
            line.setScrappedQty(Env.ZERO);
            line.setTargetQty(Env.ZERO);
            if (this.getM_Warehouse_ID() != inOutFrom.getM_Warehouse_ID()) {
                line.setM_Locator_ID(0);
                line.setM_Locator_ID(Env.ZERO);
            }
            if (counter) {
                MOrderLine peer;
                line.setRef_InOutLine_ID(fromLine.getM_InOutLine_ID());
                if (fromLine.getC_OrderLine_ID() != 0 && (peer = new MOrderLine(this.getCtx(), fromLine.getC_OrderLine_ID(), this.get_TrxName())).getRef_OrderLine_ID() != 0) {
                    line.setC_OrderLine_ID(peer.getRef_OrderLine_ID());
                }
                if (fromLine.getM_RMALine_ID() != 0 && (peer = new MRMALine(this.getCtx(), fromLine.getM_RMALine_ID(), this.get_TrxName())).getRef_RMALine_ID() > 0) {
                    line.setM_RMALine_ID(peer.getRef_RMALine_ID());
                }
            }
            line.setProcessed(false);
            if (line.save(this.get_TrxName())) {
                ++count;
            }
            if (!counter) continue;
            fromLine.setRef_InOutLine_ID(line.getM_InOutLine_ID());
            fromLine.save(this.get_TrxName());
        }
        if (fromLines.length != count) {
            this.log.log(Level.SEVERE, "Line difference - From=" + fromLines.length + " <> Saved=" + count);
            count = -1;
        }
        return count;
    }

    public void setReversal(boolean isReversal) {
        this.isReversal = isReversal;
    }

    public boolean isReversal() {
        return this.isReversal;
    }

    public void setProcessed(boolean processed) {
        super.setProcessed(processed);
        if (this.get_ID() == 0) {
            return;
        }
        String sql = "UPDATE M_InOutLine SET Processed='" + (processed ? "Y" : "N") + "' WHERE M_InOut_ID=" + this.getM_InOut_ID();
        int noLine = DB.executeUpdate((String)sql, (String)this.get_TrxName());
        this.m_lines = null;
        this.log.fine(processed + " - Lines=" + noLine);
    }

    public MBPartner getBPartner() {
        if (this.m_partner == null) {
            this.m_partner = new MBPartner(this.getCtx(), this.getC_BPartner_ID(), this.get_TrxName());
        }
        return this.m_partner;
    }

    public void setC_DocType_ID(String DocBaseType) {
        String sql = "SELECT C_DocType_ID FROM C_DocType WHERE AD_Client_ID=? AND DocBaseType=? AND IsActive='Y' AND IsSOTrx='" + (this.isSOTrx() ? "Y" : "N") + "' ORDER BY IsDefault DESC";
        int C_DocType_ID = DB.getSQLValue(null, (String)sql, (int)this.getAD_Client_ID(), (String)DocBaseType);
        if (C_DocType_ID <= 0) {
            this.log.log(Level.SEVERE, "Not found for AC_Client_ID=" + this.getAD_Client_ID() + " - " + DocBaseType);
        } else {
            this.log.fine("DocBaseType=" + DocBaseType + " - C_DocType_ID=" + C_DocType_ID);
            this.setC_DocType_ID(C_DocType_ID);
            boolean isSOTrx = "MMS".equals(DocBaseType);
            this.setIsSOTrx(isSOTrx);
        }
    }

    public void setC_DocType_ID() {
        if (this.isSOTrx()) {
            this.setC_DocType_ID("MMS");
        } else {
            this.setC_DocType_ID("MMR");
        }
    }

    public void setBPartner(MBPartner bp) {
        MUser[] contacts;
        if (bp == null) {
            return;
        }
        this.setC_BPartner_ID(bp.getC_BPartner_ID());
        MBPartnerLocation[] locs = bp.getLocations(false);
        if (locs != null) {
            for (int i = 0; i < locs.length; ++i) {
                if (!locs[i].isShipTo()) continue;
                this.setC_BPartner_Location_ID(locs[i].getC_BPartner_Location_ID());
            }
            if (this.getC_BPartner_Location_ID() == 0 && locs.length > 0) {
                this.setC_BPartner_Location_ID(locs[0].getC_BPartner_Location_ID());
            }
        }
        if (this.getC_BPartner_Location_ID() == 0) {
            this.log.log(Level.SEVERE, "Has no To Address: " + String.valueOf(bp));
        }
        if ((contacts = bp.getContacts(false)) != null && contacts.length > 0) {
            this.setAD_User_ID(contacts[0].getAD_User_ID());
        }
    }

    public void createConfirmation() {
        MDocType dt = MDocType.get((Properties)this.getCtx(), (int)this.getC_DocType_ID());
        boolean pick = dt.isPickQAConfirm();
        boolean ship = dt.isShipConfirm();
        if (!pick && !ship) {
            this.log.fine("No need");
            return;
        }
        if (pick && ship) {
            boolean havePick = false;
            boolean haveShip = false;
            MInOutConfirm[] confirmations = this.getConfirmations(false);
            for (int i = 0; i < confirmations.length; ++i) {
                MInOutConfirm confirm = confirmations[i];
                if ("PC".equals(confirm.getConfirmType())) {
                    if (!confirm.isProcessed()) {
                        this.log.fine("Unprocessed: " + String.valueOf(confirm));
                        return;
                    }
                    havePick = true;
                    continue;
                }
                if (!"SC".equals(confirm.getConfirmType())) continue;
                haveShip = true;
            }
            if (!havePick) {
                MInOutConfirm.create((MInOut)this, (String)"PC", (boolean)false);
                return;
            }
            if (!haveShip) {
                MInOutConfirm.create((MInOut)this, (String)"SC", (boolean)false);
                return;
            }
            return;
        }
        if (pick) {
            MInOutConfirm.create((MInOut)this, (String)"PC", (boolean)true);
        } else if (ship) {
            MInOutConfirm.create((MInOut)this, (String)"SC", (boolean)true);
        }
    }

    private void voidConfirmations() {
        for (MInOutConfirm confirm : this.getConfirmations(true)) {
            if (confirm.isProcessed()) continue;
            if (!confirm.processIt("VO")) {
                throw new AdempiereException(confirm.getProcessMsg());
            }
            confirm.saveEx();
        }
    }

    public void setM_Warehouse_ID(int M_Warehouse_ID) {
        if (M_Warehouse_ID == 0) {
            this.log.severe("Ignored - Cannot set AD_Warehouse_ID to 0");
            return;
        }
        super.setM_Warehouse_ID(M_Warehouse_ID);
        MWarehouse warehouse = MWarehouse.get((Properties)this.getCtx(), (int)this.getM_Warehouse_ID());
        if (warehouse.getAD_Org_ID() != this.getAD_Org_ID()) {
            this.log.warning("M_Warehouse_ID=" + M_Warehouse_ID + ", Overwritten AD_Org_ID=" + this.getAD_Org_ID() + "->" + warehouse.getAD_Org_ID());
            this.setAD_Org_ID(warehouse.getAD_Org_ID());
        }
    }

    protected boolean beforeSave(boolean newRecord) {
        MWarehouse warehouse;
        if (newRecord && (warehouse = MWarehouse.get((Properties)this.getCtx(), (int)this.getM_Warehouse_ID())).getAD_Org_ID() != this.getAD_Org_ID()) {
            this.log.saveError("WarehouseOrgConflict", "");
            return false;
        }
        if (this.getC_Order_ID() != 0 && this.getM_RMA_ID() != 0) {
            this.log.saveError("OrderOrRMA", "");
            return false;
        }
        if (!this.getMovementType().contentEquals("C+") && this.isSOTrx() && this.getC_Order_ID() == 0 && this.getM_RMA_ID() == 0) {
            this.log.saveError("FillMandatory", Msg.translate((Properties)this.getCtx(), (String)"C_Order_ID"));
            return false;
        }
        if (this.isSOTrx() && this.getM_RMA_ID() != 0) {
            MRMA rma = new MRMA(this.getCtx(), this.getM_RMA_ID(), this.get_TrxName());
            MDocType docType = MDocType.get((Properties)this.getCtx(), (int)rma.getC_DocType_ID());
            this.setC_DocType_ID(docType.getC_DocTypeShipment_ID());
        }
        return true;
    }

    protected boolean beforeDelete() {
        if (this.isProcessed()) {
            return false;
        }
        Arrays.stream(this.getLines()).forEach(inOutLine -> {
            Optional<MInvoiceLine> maybeInvoiceLine = Optional.ofNullable(MInvoiceLine.getOfInOutLine((MInOutLine)((Object)inOutLine)));
            maybeInvoiceLine.ifPresent(invoiceLine -> {
                invoiceLine.setM_InOutLine_ID(-1);
                invoiceLine.saveEx();
            });
        });
        return true;
    }

    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!success || newRecord) {
            return success;
        }
        if (this.is_ValueChanged("AD_Org_ID")) {
            String sql = "UPDATE M_InOutLine ol SET AD_Org_ID =(SELECT AD_Org_ID FROM M_InOut o WHERE ol.M_InOut_ID=o.M_InOut_ID) WHERE M_InOut_ID=" + this.getC_Order_ID();
            int no = DB.executeUpdate((String)sql, (String)this.get_TrxName());
            this.log.fine("Lines -> #" + no);
        }
        return true;
    }

    public boolean processIt(String processAction) {
        this.processMsg = null;
        DocumentEngine engine = new DocumentEngine((DocAction)this, this.getDocStatus());
        return engine.processIt(processAction, this.getDocAction());
    }

    public boolean unlockIt() {
        this.log.info(this.toString());
        this.setProcessing(false);
        return true;
    }

    public boolean invalidateIt() {
        this.log.info(this.toString());
        this.setDocAction("PR");
        return true;
    }

    public String prepareIt() {
        MInOutLine[] lines;
        I_C_Order order;
        this.log.info(this.toString());
        this.processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 1);
        if (this.processMsg != null) {
            return "IN";
        }
        MDocType dt = MDocType.get((Properties)this.getCtx(), (int)this.getC_DocType_ID());
        if (this.getC_Order_ID() != 0 && this.getM_RMA_ID() != 0) {
            this.processMsg = "@OrderOrRMA@";
            return "IN";
        }
        if (!MPeriod.isOpen((Properties)this.getCtx(), (Timestamp)this.getDateAcct(), (String)dt.getDocBaseType(), (int)this.getAD_Org_ID())) {
            this.processMsg = "@PeriodClosed@";
            return "IN";
        }
        if (this.isSOTrx() && !this.isReversal() && ((order = this.getC_Order()) == null || !"PR".equals(order.getC_DocType().getDocSubTypeSO()) || MSysConfig.getBooleanValue((String)"CHECK_CREDIT_ON_PREPAY_ORDER", (boolean)true, (int)this.getAD_Client_ID(), (int)this.getAD_Org_ID()))) {
            MBPartner bp = new MBPartner(this.getCtx(), this.getC_BPartner_ID(), this.get_TrxName());
            if ("S".equals(bp.getSOCreditStatus())) {
                this.processMsg = "@BPartnerCreditStop@ - @TotalOpenBalance@=" + String.valueOf(bp.getTotalOpenBalance()) + ", @SO_CreditLimit@=" + String.valueOf(bp.getSO_CreditLimit());
                return "IN";
            }
            if ("H".equals(bp.getSOCreditStatus())) {
                this.processMsg = "@BPartnerCreditHold@ - @TotalOpenBalance@=" + String.valueOf(bp.getTotalOpenBalance()) + ", @SO_CreditLimit@=" + String.valueOf(bp.getSO_CreditLimit());
                return "IN";
            }
            BigDecimal notInvoicedAmt = MBPartner.getNotInvoicedAmt((int)this.getC_BPartner_ID());
            if ("H".equals(bp.getSOCreditStatus(notInvoicedAmt))) {
                this.processMsg = "@BPartnerOverSCreditHold@ - @TotalOpenBalance@=" + String.valueOf(bp.getTotalOpenBalance()) + ", @NotInvoicedAmt@=" + String.valueOf(notInvoicedAmt) + ", @SO_CreditLimit@=" + String.valueOf(bp.getSO_CreditLimit());
                return "IN";
            }
        }
        if ((lines = this.getLines(true)) == null || lines.length == 0) {
            this.processMsg = "@NoLines@";
            return "IN";
        }
        BigDecimal Volume = Env.ZERO;
        BigDecimal Weight = Env.ZERO;
        for (int i = 0; i < lines.length; ++i) {
            MInOutLine line = lines[i];
            MProduct product = line.getProduct();
            if (product != null) {
                Volume = Volume.add(product.getVolume().multiply(line.getMovementQty()));
                Weight = Weight.add(product.getWeight().multiply(line.getMovementQty()));
            }
            if (line.getM_AttributeSetInstance_ID() == 0) continue;
        }
        this.setVolume(Volume);
        this.setWeight(Weight);
        if (!this.isReversal()) {
            this.createConfirmation();
        }
        this.processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 8);
        if (this.processMsg != null) {
            return "IN";
        }
        this.justPrepared = true;
        if (!"CO".equals(this.getDocAction())) {
            this.setDocAction("CO");
        }
        return "IP";
    }

    public boolean approveIt() {
        this.log.info(this.toString());
        this.setIsApproved(true);
        return true;
    }

    public boolean rejectIt() {
        this.log.info(this.toString());
        this.setIsApproved(false);
        return true;
    }

    public String completeIt() {
        String valid;
        MInOut dropShipment;
        String status;
        if (!this.justPrepared && !"IP".equals(status = this.prepareIt())) {
            return status;
        }
        this.processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 7);
        if (this.processMsg != null) {
            return "IN";
        }
        MInOutConfirm[] confirmations = this.getConfirmations(true);
        for (int i = 0; i < confirmations.length; ++i) {
            MInOutConfirm confirm = confirmations[i];
            if (confirm.isProcessed() || "XC".equals(confirm.getConfirmType())) continue;
            this.processMsg = "Open @M_InOutConfirm_ID@: " + confirm.getConfirmTypeName() + " - " + confirm.getDocumentNo();
            return "IP";
        }
        if (!this.isApproved()) {
            this.approveIt();
        }
        this.log.info(this.toString());
        StringBuffer info = new StringBuffer();
        TreeSet<Integer> inOutOrders = new TreeSet<Integer>();
        MInOutLine[] lines = this.getLines(true);
        for (int lineIndex = 0; lineIndex < lines.length; ++lineIndex) {
            MInvoiceLine invoiceLine;
            I_M_InOutLine ioLine;
            MInOutLine inOutLine = lines[lineIndex];
            MProduct product = inOutLine.getProduct();
            String MovementType = this.getMovementType();
            BigDecimal quantity = inOutLine.getMovementQty();
            if (MovementType.charAt(1) == '-') {
                quantity = quantity.negate();
            }
            BigDecimal QtySO = Env.ZERO;
            BigDecimal QtyPO = Env.ZERO;
            MRMALine rmaLine = null;
            if (inOutLine.getM_RMALine_ID() > 0 && (rmaLine = new MRMALine(this.getCtx(), inOutLine.getM_RMALine_ID(), this.get_TrxName())).getM_InOutLine_ID() > 0 && (ioLine = rmaLine.getM_InOutLine()).getC_OrderLine_ID() > 0) {
                inOutLine.setC_OrderLine_ID(ioLine.getC_OrderLine_ID());
                inOutLine.saveEx();
            }
            MOrderLine orderLine = null;
            if (inOutLine.getC_OrderLine_ID() != 0) {
                orderLine = new MOrderLine(this.getCtx(), inOutLine.getC_OrderLine_ID(), this.get_TrxName());
                inOutOrders.add(orderLine.getC_Order_ID());
                this.log.fine("OrderLine - Reserved=" + String.valueOf(orderLine.getQtyReserved()) + ", Delivered=" + String.valueOf(orderLine.getQtyDelivered()));
                if (this.isSOTrx() && "C-".equals(MovementType) && inOutLine.getMovementQty().signum() > 0 || this.isSOTrx() && "C+".equals(MovementType) && inOutLine.getMovementQty().signum() < 0) {
                    QtySO = inOutLine.getMovementQty().abs().negate();
                } else if (this.isSOTrx() && "C-".equals(MovementType) && inOutLine.getMovementQty().signum() < 0 || this.isSOTrx() && "C+".equals(MovementType) && inOutLine.getMovementQty().signum() > 0) {
                    QtySO = inOutLine.getMovementQty().abs();
                } else if (!this.isSOTrx() && "V+".equals(MovementType) && inOutLine.getMovementQty().signum() > 0 || !this.isSOTrx() && "V-".equals(MovementType) && inOutLine.getMovementQty().signum() < 0) {
                    QtyPO = inOutLine.getMovementQty().abs().negate();
                } else if (!this.isSOTrx() && "V+".equals(MovementType) && inOutLine.getMovementQty().signum() < 0 || !this.isSOTrx() && "V-".equals(MovementType) && inOutLine.getMovementQty().signum() > 0) {
                    QtyPO = inOutLine.getMovementQty().abs();
                }
            }
            this.log.info("Line=" + inOutLine.getLine() + " - Qty=" + String.valueOf(inOutLine.getMovementQty()));
            if (product != null && product.isStocked()) {
                if (!this.isReversal()) {
                    this.checkMaterialPolicy(inOutLine);
                }
                this.log.fine("Material Transaction");
                MTransaction materialTransaction = null;
                boolean sameWarehouse = true;
                int reservationAttributeSetInstance_ID = 0;
                if (orderLine != null) {
                    reservationAttributeSetInstance_ID = orderLine.getM_AttributeSetInstance_ID();
                    boolean bl = sameWarehouse = orderLine.getM_Warehouse_ID() == this.getM_Warehouse_ID();
                }
                if (inOutLine.getM_AttributeSetInstance_ID() == 0) {
                    List mas = MInOutLineMA.get((Properties)this.getCtx(), (int)inOutLine.getM_InOutLine_ID(), (String)this.get_TrxName());
                    for (MInOutLineMA ma : mas) {
                        BigDecimal QtyMA = ma.getMovementQty();
                        if (MovementType.charAt(1) == '-') {
                            QtyMA = QtyMA.negate();
                        }
                        BigDecimal reservedDiff = Env.ZERO;
                        BigDecimal orderedDiff = Env.ZERO;
                        if (inOutLine.getC_OrderLine_ID() != 0) {
                            if (this.isSOTrx() && "C-".equals(MovementType) && ma.getMovementQty().signum() > 0 || this.isSOTrx() && "C+".equals(MovementType) && ma.getMovementQty().signum() < 0) {
                                reservedDiff = ma.getMovementQty().abs().negate();
                            } else if (this.isSOTrx() && "C-".equals(MovementType) && ma.getMovementQty().signum() < 0 || this.isSOTrx() && "C+".equals(MovementType) && ma.getMovementQty().signum() > 0) {
                                reservedDiff = ma.getMovementQty().abs();
                            } else if (!this.isSOTrx() && "V+".equals(MovementType) && ma.getMovementQty().signum() > 0 || !this.isSOTrx() && "V-".equals(MovementType) && ma.getMovementQty().signum() < 0) {
                                orderedDiff = ma.getMovementQty().abs().negate();
                            } else if (!this.isSOTrx() && "V+".equals(MovementType) && ma.getMovementQty().signum() < 0 || !this.isSOTrx() && "V-".equals(MovementType) && ma.getMovementQty().signum() > 0) {
                                orderedDiff = ma.getMovementQty().abs();
                            }
                        }
                        if (!MStorage.add(this.getCtx(), this.getM_Warehouse_ID(), inOutLine.getM_Locator_ID(), inOutLine.getM_Product_ID(), ma.getM_AttributeSetInstance_ID(), reservationAttributeSetInstance_ID, QtyMA, sameWarehouse ? reservedDiff : Env.ZERO, sameWarehouse ? orderedDiff : Env.ZERO, this.get_TrxName())) {
                            this.processMsg = "Cannot correct Inventory (MA)";
                            return "IN";
                        }
                        if (!sameWarehouse) {
                            MWarehouse warehouse = MWarehouse.get((Properties)this.getCtx(), (int)orderLine.getM_Warehouse_ID());
                            if (!MStorage.add(this.getCtx(), orderLine.getM_Warehouse_ID(), warehouse.getDefaultLocator().getM_Locator_ID(), inOutLine.getM_Product_ID(), ma.getM_AttributeSetInstance_ID(), reservationAttributeSetInstance_ID, Env.ZERO, reservedDiff, orderedDiff, this.get_TrxName())) {
                                this.processMsg = "Cannot correct Inventory (MA) in order warehouse";
                                return "IN";
                            }
                        }
                        materialTransaction = new MTransaction(this.getCtx(), inOutLine.getAD_Org_ID(), MovementType, inOutLine.getM_Locator_ID(), inOutLine.getM_Product_ID(), ma.getM_AttributeSetInstance_ID(), QtyMA, this.getMovementDate(), this.get_TrxName());
                        materialTransaction.setM_InOutLine_ID(inOutLine.getM_InOutLine_ID());
                        if (materialTransaction.save()) continue;
                        this.processMsg = "Could not create Material Transaction (MA)";
                        return "IN";
                    }
                }
                if (materialTransaction == null) {
                    BigDecimal reservedDiff = Env.ZERO;
                    BigDecimal orderedDiff = Env.ZERO;
                    if (inOutLine.getC_OrderLine_ID() != 0 && sameWarehouse && !orderLine.getParent().isReturnOrder()) {
                        if (this.isSOTrx()) {
                            reservedDiff = QtySO;
                        } else {
                            orderedDiff = QtyPO;
                        }
                    }
                    if (!MStorage.add(this.getCtx(), this.getM_Warehouse_ID(), inOutLine.getM_Locator_ID(), inOutLine.getM_Product_ID(), inOutLine.getM_AttributeSetInstance_ID(), reservationAttributeSetInstance_ID, quantity, reservedDiff, orderedDiff, this.get_TrxName())) {
                        this.processMsg = "Cannot correct Inventory";
                        return "IN";
                    }
                    if (!sameWarehouse) {
                        MWarehouse warehouse = MWarehouse.get((Properties)this.getCtx(), (int)orderLine.getM_Warehouse_ID());
                        if (!MStorage.add(this.getCtx(), orderLine.getM_Warehouse_ID(), warehouse.getDefaultLocator().getM_Locator_ID(), inOutLine.getM_Product_ID(), inOutLine.getM_AttributeSetInstance_ID(), reservationAttributeSetInstance_ID, Env.ZERO, QtySO.negate(), QtyPO.negate(), this.get_TrxName())) {
                            this.processMsg = "Cannot correct Inventory";
                            return "IN";
                        }
                    }
                    materialTransaction = new MTransaction(this.getCtx(), inOutLine.getAD_Org_ID(), MovementType, inOutLine.getM_Locator_ID(), inOutLine.getM_Product_ID(), inOutLine.getM_AttributeSetInstance_ID(), quantity, this.getMovementDate(), this.get_TrxName());
                    materialTransaction.setM_InOutLine_ID(inOutLine.getM_InOutLine_ID());
                    if (!materialTransaction.save()) {
                        this.processMsg = CLogger.retrieveErrorString((String)"Could not create Material Transaction");
                        return "IN";
                    }
                }
            }
            if (product != null && product.isStocked() && orderLine != null && this.isSOTrx() && !orderLine.getParent().isReturnOrder()) {
                orderLine.setQtyReserved(orderLine.getQtyReserved().add(QtySO));
            } else if (product != null && product.isStocked() && orderLine != null && !this.isSOTrx() && !orderLine.getParent().isReturnOrder()) {
                orderLine.setQtyReserved(orderLine.getQtyReserved().add(QtyPO));
            }
            if (orderLine != null) {
                if (orderLine.getParent().isReturnOrder()) {
                    quantity = quantity.negate();
                }
                if (this.isSOTrx() || inOutLine.getM_Product_ID() == 0) {
                    if (this.isSOTrx()) {
                        orderLine.setQtyDelivered(orderLine.getQtyDelivered().subtract(quantity));
                    } else {
                        orderLine.setQtyDelivered(orderLine.getQtyDelivered().add(quantity));
                    }
                }
                orderLine.setDateDelivered(this.getMovementDate());
                orderLine.saveEx();
                this.log.fine("OrderLine -> Reserved=" + String.valueOf(orderLine.getQtyReserved()) + ", Delivered=" + String.valueOf(orderLine.getQtyDelivered()));
            } else if (rmaLine != null) {
                if (this.isSOTrx()) {
                    rmaLine.setQtyDelivered(rmaLine.getQtyDelivered().add(quantity));
                } else {
                    rmaLine.setQtyDelivered(rmaLine.getQtyDelivered().subtract(quantity));
                }
                if (!rmaLine.save()) {
                    this.processMsg = "Could not update RMA Line";
                    return "IN";
                }
            }
            if (this.isSOTrx() || inOutLine.getM_Product_ID() == 0 || this.isReversal()) continue;
            BigDecimal matchQty = inOutLine.getMovementQty();
            if (MovementType.charAt(1) == '-') {
                matchQty = matchQty.negate();
            }
            if ((invoiceLine = MInvoiceLine.getOfInOutLine((MInOutLine)inOutLine)) != null && invoiceLine.getM_Product_ID() != 0) {
                MMatchInv[] matches;
                if (matchQty.compareTo(invoiceLine.getQtyInvoiced()) > 0) {
                    matchQty = invoiceLine.getQtyInvoiced();
                }
                if ((matches = MMatchInv.get((Properties)this.getCtx(), (int)inOutLine.getM_InOutLine_ID(), (int)invoiceLine.getC_InvoiceLine_ID(), (String)this.get_TrxName())) == null || matches.length == 0) {
                    MMatchInv matchInv = new MMatchInv(invoiceLine, this.getMovementDate(), matchQty);
                    if (inOutLine.getM_AttributeSetInstance_ID() != invoiceLine.getM_AttributeSetInstance_ID()) {
                        invoiceLine.setM_AttributeSetInstance_ID(inOutLine.getM_AttributeSetInstance_ID());
                        invoiceLine.saveEx();
                        matchInv.setM_AttributeSetInstance_ID(inOutLine.getM_AttributeSetInstance_ID());
                    }
                    matchInv.saveEx(this.get_TrxName());
                    this.addDocsPostProcess((PO)matchInv);
                }
            }
            if (inOutLine.getC_OrderLine_ID() != 0) {
                this.log.fine("PO Matching");
                MMatchPO matchPO = new MMatchPO(inOutLine, this.getMovementDate(), matchQty);
                matchPO.saveEx(this.get_TrxName());
                this.addDocsPostProcess((PO)matchPO);
                if (orderLine == null || orderLine.getM_AttributeSetInstance_ID() != 0 || inOutLine.getMovementQty().compareTo(orderLine.getQtyOrdered()) != 0) continue;
                orderLine.setM_AttributeSetInstance_ID(inOutLine.getM_AttributeSetInstance_ID());
                orderLine.save(this.get_TrxName());
                continue;
            }
            if (invoiceLine == null || invoiceLine.getC_OrderLine_ID() == 0) continue;
            this.log.fine("PO(Inv) Matching");
            inOutLine.setC_OrderLine_ID(invoiceLine.getC_OrderLine_ID());
            MMatchPO matchPO = new MMatchPO(inOutLine, this.getMovementDate(), matchQty);
            matchPO.save(this.get_TrxName());
            orderLine = new MOrderLine(this.getCtx(), matchPO.getC_OrderLine_ID(), this.get_TrxName());
            if (orderLine != null && orderLine.getM_AttributeSetInstance_ID() == 0 && inOutLine.getMovementQty().compareTo(orderLine.getQtyOrdered()) == 0) {
                orderLine.setM_AttributeSetInstance_ID(inOutLine.getM_AttributeSetInstance_ID());
                orderLine.save(this.get_TrxName());
            }
            this.addDocsPostProcess((PO)matchPO);
        }
        MInOut counter = this.createCounterDoc();
        if (counter != null) {
            info.append(" - @CounterDoc@: @M_InOut_ID@=").append(counter.getDocumentNo());
        }
        if ((dropShipment = this.createDropShipment()) != null) {
            info.append(" - @DropShipment@: @M_InOut_ID@=").append(dropShipment.getDocumentNo());
        }
        if ((valid = ModelValidationEngine.get().fireDocValidate((PO)this, 9)) != null) {
            this.processMsg = valid;
            return "IN";
        }
        this.setDefiniteDocumentNo();
        if (inOutOrders.size() > 0) {
            Iterator it = inOutOrders.iterator();
            while (it.hasNext()) {
                MOrder order = new MOrder(this.getCtx(), (Integer)it.next(), this.get_TrxName());
                try {
                    order.updateIsDelivered();
                }
                catch (SQLException ee) {
                    this.log.warning("Could not update isDelivered flag on order " + order.getDocumentNo() + " : " + ee.getMessage());
                }
                order.saveEx(this.get_TrxName());
            }
        }
        this.processMsg = info.toString();
        this.setProcessed(true);
        this.setDocAction("CL");
        return "CO";
    }

    private void addDocsPostProcess(PO doc) {
        this.docsPostProcess.add(doc);
    }

    public ArrayList<PO> getDocsPostProcess() {
        return this.docsPostProcess;
    }

    private MInOut createDropShipment() {
        if (this.isSOTrx() || !this.isDropShip() || this.getC_Order_ID() == 0) {
            return null;
        }
        int C_DocTypeTarget_ID = 0;
        MDocType[] shipmentTypes = MDocType.getOfDocBaseType((Properties)this.getCtx(), (String)"MMS");
        for (int i = 0; i < shipmentTypes.length; ++i) {
            if (!shipmentTypes[i].isSOTrx() || C_DocTypeTarget_ID != 0 && !shipmentTypes[i].isDefault()) continue;
            C_DocTypeTarget_ID = shipmentTypes[i].getC_DocType_ID();
        }
        MInOut dropShipment = MInOut.copyFrom(this, this.getMovementDate(), this.getDateAcct(), C_DocTypeTarget_ID, !this.isSOTrx(), false, false, this.get_TrxName(), true);
        int linkedOrderID = new MOrder(this.getCtx(), this.getC_Order_ID(), this.get_TrxName()).getLink_Order_ID();
        if (linkedOrderID != 0) {
            dropShipment.setC_Order_ID(linkedOrderID);
            int invID = new MOrder(this.getCtx(), linkedOrderID, this.get_TrxName()).getC_Invoice_ID();
            if (invID != 0) {
                dropShipment.setC_Invoice_ID(invID);
            }
        } else {
            return null;
        }
        dropShipment.setC_BPartner_ID(this.getDropShip_BPartner_ID());
        dropShipment.setC_BPartner_Location_ID(this.getDropShip_Location_ID());
        dropShipment.setAD_User_ID(this.getDropShip_User_ID());
        dropShipment.setIsDropShip(false);
        dropShipment.setDropShip_BPartner_ID(0);
        dropShipment.setDropShip_Location_ID(0);
        dropShipment.setDropShip_User_ID(0);
        dropShipment.setMovementType("C-");
        dropShipment.setSalesRep_ID(this.getSalesRep_ID());
        dropShipment.save(this.get_TrxName());
        MInOutLine[] lines = dropShipment.getLines(true);
        for (int i = 0; i < lines.length; ++i) {
            MInOutLine dropLine = lines[i];
            MOrderLine ol = new MOrderLine(this.getCtx(), dropLine.getC_OrderLine_ID(), null);
            if (ol.getC_OrderLine_ID() == 0) continue;
            dropLine.setC_OrderLine_ID(ol.getLink_OrderLine_ID());
            dropLine.saveEx();
        }
        this.log.fine(dropShipment.toString());
        dropShipment.setDocAction("CO");
        dropShipment.processIt("CO");
        dropShipment.saveEx();
        return dropShipment;
    }

    private void setDefiniteDocumentNo() {
        String value;
        Boolean isOverwrite;
        MDocType dt = MDocType.get((Properties)this.getCtx(), (int)this.getC_DocType_ID());
        if (dt.isOverwriteDateOnComplete()) {
            this.setMovementDate(new Timestamp(System.currentTimeMillis()));
        }
        if (dt.isOverwriteSeqOnComplete() && (isOverwrite = Boolean.valueOf(!this.isReversal() || this.isReversal() && !dt.isCopyDocNoOnReversal())).booleanValue() && (value = DB.getDocumentNo((int)this.getC_DocType_ID(), (String)this.get_TrxName(), (boolean)true, (PO)this)) != null) {
            this.setDocumentNo(value);
        }
    }

    private void checkMaterialPolicy(MInOutLine line) {
        String MovementType;
        int no = MInOutLineMA.deleteInOutLineMA((int)line.getM_InOutLine_ID(), (String)this.get_TrxName());
        if (no > 0) {
            this.log.config("Delete old #" + no);
        }
        boolean inTrx = (MovementType = this.getMovementType()).charAt(1) == '+';
        boolean needSave = false;
        MProduct product = line.getProduct();
        if (product == null || product.getM_AttributeSet_ID() == 0) {
            return;
        }
        if (product != null && line.getM_Locator_ID() == 0) {
            line.setM_Warehouse_ID(this.getM_Warehouse_ID());
            line.setM_Locator_ID(inTrx ? Env.ZERO : line.getMovementQty());
            needSave = true;
        }
        if (product != null) {
            if (this.getMovementType().compareTo("C+") == 0 || this.getMovementType().compareTo("V+") == 0) {
                MStorage[] storages;
                MAttributeSetInstance asi = null;
                for (MStorage storage : storages = MStorage.getWarehouse(this.getCtx(), this.getM_Warehouse_ID(), line.getM_Product_ID(), 0, null, "F".equals(product.getMMPolicy()), false, line.getM_Locator_ID(), this.get_TrxName())) {
                    if (storage.getQtyOnHand().signum() >= 0) continue;
                    asi = new MAttributeSetInstance(this.getCtx(), storage.getM_AttributeSetInstance_ID(), this.get_TrxName());
                    break;
                }
                if (asi == null && line.getM_AttributeSetInstance_ID() == 0) {
                    MAttributeSet.validateAttributeSetInstanceMandatory((MProduct)product, (int)MInOutLine.Table_ID, (boolean)this.isSOTrx(), (int)line.getM_AttributeSetInstance_ID());
                    asi = MAttributeSetInstance.create(this.getCtx(), product, this.get_TrxName());
                    line.setM_AttributeSetInstance_ID(asi.getM_AttributeSetInstance_ID());
                    this.log.config("New ASI=" + String.valueOf((Object)line));
                    needSave = true;
                }
            } else if (this.getMovementType().compareTo("V-") == 0 || this.getMovementType().compareTo("C-") == 0) {
                String MMPolicy = product.getMMPolicy();
                Timestamp minGuaranteeDate = this.getMovementDate();
                MStorage[] storages = MStorage.getWarehouse(this.getCtx(), this.getM_Warehouse_ID(), line.getM_Product_ID(), line.getM_AttributeSetInstance_ID(), minGuaranteeDate, "F".equals(MMPolicy), true, line.getM_Locator_ID(), this.get_TrxName());
                BigDecimal qtyToDeliver = line.getMovementQty();
                for (MStorage storage : storages) {
                    MInOutLineMA ma;
                    if (storage.getQtyOnHand().compareTo(qtyToDeliver) >= 0) {
                        ma = new MInOutLineMA(line, storage.getM_AttributeSetInstance_ID(), qtyToDeliver);
                        ma.saveEx();
                        qtyToDeliver = Env.ZERO;
                    } else {
                        ma = new MInOutLineMA(line, storage.getM_AttributeSetInstance_ID(), storage.getQtyOnHand());
                        ma.saveEx();
                        qtyToDeliver = qtyToDeliver.subtract(storage.getQtyOnHand());
                        this.log.fine(String.valueOf(ma) + ", QtyToDeliver=" + String.valueOf(qtyToDeliver));
                    }
                    if (qtyToDeliver.signum() == 0) break;
                }
                if (qtyToDeliver.signum() != 0) {
                    MAttributeSet.validateAttributeSetInstanceMandatory((MProduct)product, (int)MInOutLine.Table_ID, (boolean)this.isSOTrx(), (int)line.getM_AttributeSetInstance_ID());
                    MAttributeSetInstance asi = MAttributeSetInstance.create(this.getCtx(), product, this.get_TrxName());
                    int M_AttributeSetInstance_ID = asi.getM_AttributeSetInstance_ID();
                    MInOutLineMA ma = new MInOutLineMA(line, M_AttributeSetInstance_ID, qtyToDeliver);
                    ma.saveEx();
                    this.log.fine("##: " + String.valueOf(ma));
                }
            }
        }
        if (needSave) {
            line.saveEx();
        }
    }

    private MInOut createCounterDoc() {
        if (this.getRef_InOut_ID() != 0) {
            return null;
        }
        MOrg org = MOrg.get((Properties)this.getCtx(), (int)this.getAD_Org_ID());
        int counterC_BPartner_ID = org.getLinkedC_BPartner_ID(this.get_TrxName());
        if (counterC_BPartner_ID == 0) {
            return null;
        }
        MBPartner bp = new MBPartner(this.getCtx(), this.getC_BPartner_ID(), this.get_TrxName());
        int counterAD_Org_ID = bp.getAD_OrgBP_ID_Int();
        if (counterAD_Org_ID == 0) {
            return null;
        }
        MBPartner counterBP = new MBPartner(this.getCtx(), counterC_BPartner_ID, this.get_TrxName());
        MOrgInfo counterOrgInfo = MOrgInfo.get((Properties)this.getCtx(), (int)counterAD_Org_ID, (String)this.get_TrxName());
        this.log.info("Counter BP=" + counterBP.getName());
        int C_DocTypeTarget_ID = 0;
        MDocTypeCounter counterDT = MDocTypeCounter.getCounterDocType((Properties)this.getCtx(), (int)this.getC_DocType_ID());
        if (counterDT != null) {
            this.log.fine(counterDT.toString());
            if (!counterDT.isCreateCounter() || !counterDT.isValid()) {
                return null;
            }
            C_DocTypeTarget_ID = counterDT.getCounter_C_DocType_ID();
        } else {
            C_DocTypeTarget_ID = MDocTypeCounter.getCounterDocType_ID((Properties)this.getCtx(), (int)this.getC_DocType_ID());
            this.log.fine("Indirect C_DocTypeTarget_ID=" + C_DocTypeTarget_ID);
            if (C_DocTypeTarget_ID <= 0) {
                return null;
            }
        }
        MInOut counter = MInOut.copyFrom(this, this.getMovementDate(), this.getDateAcct(), C_DocTypeTarget_ID, !this.isSOTrx(), true, false, this.get_TrxName(), true);
        counter.setAD_Org_ID(counterAD_Org_ID);
        counter.setM_Warehouse_ID(counterOrgInfo.getM_Warehouse_ID());
        counter.setBPartner(counterBP);
        if (this.isDropShip()) {
            counter.setIsDropShip(true);
            counter.setDropShip_BPartner_ID(this.getDropShip_BPartner_ID());
            counter.setDropShip_Location_ID(this.getDropShip_Location_ID());
            counter.setDropShip_User_ID(this.getDropShip_User_ID());
        }
        counter.setSalesRep_ID(this.getSalesRep_ID());
        counter.save(this.get_TrxName());
        String MovementType = counter.getMovementType();
        boolean inTrx = MovementType.charAt(1) == '+';
        MInOutLine[] counterLines = counter.getLines(true);
        for (int i = 0; i < counterLines.length; ++i) {
            MInOutLine counterLine = counterLines[i];
            counterLine.setClientOrg((PO)counter);
            counterLine.setM_Warehouse_ID(counter.getM_Warehouse_ID());
            counterLine.setM_Locator_ID(0);
            counterLine.setM_Locator_ID(inTrx ? Env.ZERO : counterLine.getMovementQty());
            counterLine.save(this.get_TrxName());
        }
        this.log.fine(counter.toString());
        if (counterDT != null && counterDT.getDocAction() != null) {
            counter.setDocAction(counterDT.getDocAction());
            counter.processIt(counterDT.getDocAction());
            counter.save(this.get_TrxName());
        }
        return counter;
    }

    public boolean voidIt() {
        this.log.info(this.toString());
        if ("CL".equals(this.getDocStatus()) || "RE".equals(this.getDocStatus()) || "VO".equals(this.getDocStatus())) {
            this.processMsg = "Document Closed: " + this.getDocStatus();
            return false;
        }
        if ("DR".equals(this.getDocStatus()) || "IN".equals(this.getDocStatus()) || "IP".equals(this.getDocStatus()) || "AP".equals(this.getDocStatus()) || "NA".equals(this.getDocStatus())) {
            this.processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 2);
            if (this.processMsg != null) {
                return false;
            }
            MInOutLine[] lines = this.getLines(false);
            for (int i = 0; i < lines.length; ++i) {
                MInOutLine line = lines[i];
                BigDecimal old = line.getMovementQty();
                if (old.signum() == 0) continue;
                line.setQty(Env.ZERO);
                line.addDescription("Void (" + String.valueOf(old) + ")");
                line.save(this.get_TrxName());
            }
        } else {
            boolean isAccrual = false;
            try {
                MPeriod.testPeriodOpen((Properties)this.getCtx(), (Timestamp)this.getDateAcct(), (int)this.getC_DocType_ID(), (int)this.getAD_Org_ID());
            }
            catch (PeriodClosedException periodClosedException) {
                isAccrual = true;
            }
            if (isAccrual) {
                return this.reverseAccrualIt();
            }
            return this.reverseCorrectIt();
        }
        this.setDocStatus("VO");
        this.saveEx();
        this.voidConfirmations();
        this.processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 10);
        if (this.processMsg != null) {
            return false;
        }
        this.setProcessed(true);
        this.setDocAction("--");
        return true;
    }

    public boolean closeIt() {
        this.log.info(this.toString());
        this.processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 3);
        if (this.processMsg != null) {
            return false;
        }
        this.setProcessed(true);
        this.setDocAction("--");
        this.processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 11);
        return this.processMsg == null;
    }

    public MInOut reverseIt(boolean isAccrual) {
        MDocType documentType = MDocType.get((Properties)this.getCtx(), (int)this.getC_DocType_ID());
        Timestamp currentDate = new Timestamp(System.currentTimeMillis());
        Optional<Timestamp> loginDateOptional = Optional.of(Env.getContextAsDate((Properties)this.getCtx(), (String)"#Date"));
        Timestamp reversalDate = isAccrual ? loginDateOptional.orElseGet(() -> currentDate) : this.getDateAcct();
        Timestamp reversalMovementDate = isAccrual ? reversalDate : this.getMovementDate();
        MPeriod.testPeriodOpen((Properties)this.getCtx(), (Timestamp)reversalDate, (String)documentType.getDocBaseType(), (int)this.getAD_Org_ID());
        MInOut reversal = MInOut.copyFrom(this, reversalMovementDate, reversalDate, this.getC_DocType_ID(), this.isSOTrx(), false, true, this.get_TrxName(), true);
        if (reversal == null) {
            this.processMsg = "Could not create Ship Reversal";
            return null;
        }
        MInOutLine[] inOutLines = this.getLines(true);
        MInOutLine[] reversalLines = reversal.getLines(true);
        for (int i = 0; i < reversalLines.length; ++i) {
            MInOutLine reversalLine = reversalLines[i];
            reversalLine.setQtyEntered(reversalLine.getQtyEntered().negate());
            reversalLine.setMovementQty(reversalLine.getMovementQty().negate());
            reversalLine.setM_AttributeSetInstance_ID(inOutLines[i].getM_AttributeSetInstance_ID());
            reversalLine.setReversalLine_ID(inOutLines[i].getM_InOutLine_ID());
            reversalLine.saveEx();
            inOutLines[i].setReversalLine_ID(reversalLine.get_ID());
            inOutLines[i].saveEx();
            List mas = MInOutLineMA.get((Properties)this.getCtx(), (int)inOutLines[i].getM_InOutLine_ID(), (String)this.get_TrxName());
            mas.forEach(lineMA -> {
                MInOutLineMA reverseLine = new MInOutLineMA(reversalLine, lineMA.getM_AttributeSetInstance_ID(), lineMA.getMovementQty().negate());
                reverseLine.saveEx();
            });
        }
        if (!this.isSOTrx() && !this.reverseMatching(reversalDate)) {
            return null;
        }
        reversal.setC_Order_ID(this.getC_Order_ID());
        reversal.setM_RMA_ID(this.getM_RMA_ID());
        reversal.addDescription("{->" + this.getDocumentNo() + ")");
        reversal.setReversal_ID(this.getM_InOut_ID());
        reversal.saveEx(this.get_TrxName());
        reversal.docsPostProcess = this.docsPostProcess;
        this.docsPostProcess = new ArrayList();
        if (!reversal.processIt("CO") || !reversal.getDocStatus().equals("CO")) {
            this.processMsg = "Reversal ERROR: " + reversal.getProcessMsg();
            return null;
        }
        reversal.closeIt();
        reversal.setProcessing(false);
        reversal.setDocStatus("RE");
        reversal.setDocAction("--");
        reversal.saveEx(this.get_TrxName());
        this.addDescription("(" + reversal.getDocumentNo() + "<-)");
        this.setDocStatus("RE");
        this.saveEx();
        this.voidConfirmations();
        ArrayList orders = new ArrayList();
        Arrays.asList(this.getLines(false)).stream().filter(ioLine -> ioLine.getC_OrderLine_ID() != 0).forEach(ioLine -> {
            I_C_OrderLine orderLine = ioLine.getC_OrderLine();
            orders.add(orderLine.getC_Order_ID());
        });
        orders.stream().forEach(orderId -> {
            MOrder order = new MOrder(this.getCtx(), (int)orderId, this.get_TrxName());
            try {
                order.updateIsDelivered();
            }
            catch (SQLException exception) {
                this.log.warning("Could not update isDelivered flag on order " + order.getDocumentNo() + " : " + exception.getMessage());
            }
            order.saveEx(this.get_TrxName());
        });
        return reversal;
    }

    protected boolean reverseMatching(Timestamp reversalDate) {
        MMatchInv.getByInOut((Properties)this.getCtx(), (int)this.getM_InOut_ID(), (String)this.get_TrxName()).stream().filter(matchInvoice -> matchInvoice.getReversal_ID() <= 0).forEach(matchInvoice -> {
            String description = matchInvoice.getDescription();
            if (description == null || !description.endsWith("<-)")) {
                MMatchInv matchInvoiceReverse = matchInvoice.reverseIt(reversalDate);
                if (matchInvoiceReverse == null) {
                    this.processMsg = "Failed to create reversal for match invoice " + matchInvoice.getDocumentNo();
                    this.log.log(Level.SEVERE, this.processMsg);
                    throw new AdempiereException(this.processMsg);
                }
                this.addDocsPostProcess((PO)matchInvoiceReverse);
            }
        });
        MMatchPO.getByInOutId((Properties)this.getCtx(), (int)this.getM_InOut_ID(), (String)this.get_TrxName()).stream().filter(matchPO -> matchPO.getReversal_ID() <= 0).forEach(matchPO -> {
            String description = matchPO.getDescription();
            if (description == null || !description.endsWith("<-)")) {
                MMatchPO matchPOReverse = matchPO.reverseIt(reversalDate);
                if (matchPOReverse == null) {
                    this.processMsg = "Failed to create reversal for match purchase order " + matchPO.getDocumentNo();
                    this.log.log(Level.SEVERE, this.processMsg);
                    throw new AdempiereException(this.processMsg);
                }
                this.addDocsPostProcess((PO)matchPOReverse);
            }
        });
        return true;
    }

    public boolean reverseCorrectIt() {
        this.log.info(this.toString());
        this.processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 5);
        if (this.processMsg != null) {
            return false;
        }
        MInOut reversal = this.reverseIt(false);
        if (reversal == null) {
            return false;
        }
        this.processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 13);
        if (this.processMsg != null) {
            return false;
        }
        this.processMsg = reversal.getDocumentNo();
        this.setReversal_ID(reversal.getM_InOut_ID());
        this.setProcessed(true);
        this.setDocStatus("RE");
        this.setDocAction("--");
        return true;
    }

    public boolean reverseAccrualIt() {
        this.log.info(this.toString());
        this.processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 6);
        if (this.processMsg != null) {
            return false;
        }
        MInOut reversal = this.reverseIt(true);
        if (reversal == null) {
            return false;
        }
        this.processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 14);
        if (this.processMsg != null) {
            return false;
        }
        this.processMsg = reversal.getDocumentNo();
        this.setProcessed(true);
        this.setDocStatus("RE");
        this.setDocAction("--");
        return true;
    }

    public boolean reActivateIt() {
        this.log.info(this.toString());
        this.processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 4);
        if (this.processMsg != null) {
            return false;
        }
        this.processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 12);
        if (this.processMsg != null) {
            return false;
        }
        return false;
    }

    public String getSummary() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getDocumentNo());
        sb.append(":").append(" (#").append(this.getLines(false).length).append(")");
        if (this.getDescription() != null && this.getDescription().length() > 0) {
            sb.append(" - ").append(this.getDescription());
        }
        return sb.toString();
    }

    public String getProcessMsg() {
        return this.processMsg;
    }

    public int getDoc_User_ID() {
        return this.getSalesRep_ID();
    }

    public BigDecimal getApprovalAmt() {
        return Env.ZERO;
    }

    public int getC_Currency_ID() {
        return Env.getContextAsInt((Properties)this.getCtx(), (String)"$C_Currency_ID");
    }

    public boolean isComplete() {
        String ds = this.getDocStatus();
        return "CO".equals(ds) || "CL".equals(ds) || "RE".equals(ds);
    }
}

