/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.core.domains.models.X_GL_Journal;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MAcctSchemaGL;
import org.compiere.model.MDocType;
import org.compiere.model.MFactAcct;
import org.compiere.model.MJournalBatch;
import org.compiere.model.MJournalLine;
import org.compiere.model.MPeriod;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.process.DocAction;
import org.compiere.process.DocumentEngine;
import org.compiere.process.DocumentReversalEnabled;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class MJournal
extends X_GL_Journal
implements DocAction,
DocumentReversalEnabled {
    private static final long serialVersionUID = -364132249042527640L;
    private String processMessage = null;
    private boolean justPrepared = false;
    private boolean isReversal = false;

    public MJournal(Properties ctx, int GL_Journal_ID, String trxName) {
        super(ctx, GL_Journal_ID, trxName);
        if (GL_Journal_ID == 0) {
            this.setCurrencyRate(Env.ONE);
            this.setDateAcct(new Timestamp(System.currentTimeMillis()));
            this.setDateDoc(new Timestamp(System.currentTimeMillis()));
            this.setDocAction("CO");
            this.setDocStatus("DR");
            this.setPostingType("A");
            this.setTotalCr(Env.ZERO);
            this.setTotalDr(Env.ZERO);
            this.setIsApproved(false);
            this.setIsPrinted(false);
            this.setPosted(false);
            this.setProcessed(false);
        }
    }

    public MJournal(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MJournal(MJournalBatch parent) {
        this(parent.getCtx(), 0, parent.get_TrxName());
        this.setClientOrg((PO)parent);
        this.setGL_JournalBatch_ID(parent.getGL_JournalBatch_ID());
        this.setC_DocType_ID(parent.getC_DocType_ID());
        this.setPostingType(parent.getPostingType());
        this.setDateDoc(parent.getDateDoc());
        this.setC_Period_ID(parent.getC_Period_ID());
        this.setDateAcct(parent.getDateAcct());
        this.setC_Currency_ID(parent.getC_Currency_ID());
    }

    public MJournal(MJournal original) {
        this(original.getCtx(), 0, original.get_TrxName());
        this.setClientOrg((PO)original);
        this.setGL_JournalBatch_ID(original.getGL_JournalBatch_ID());
        this.setC_AcctSchema_ID(original.getC_AcctSchema_ID());
        this.setGL_Budget_ID(original.getGL_Budget_ID());
        this.setGL_Category_ID(original.getGL_Category_ID());
        this.setPostingType(original.getPostingType());
        this.setDescription(original.getDescription());
        this.setC_DocType_ID(original.getC_DocType_ID());
        this.setControlAmt(original.getControlAmt());
        this.setC_Currency_ID(original.getC_Currency_ID());
        this.setC_ConversionType_ID(original.getC_ConversionType_ID());
        this.setCurrencyRate(original.getCurrencyRate());
    }

    public void setClientOrg(int AD_Client_ID, int AD_Org_ID) {
        super.setClientOrg(AD_Client_ID, AD_Org_ID);
    }

    public void setDateAcct(Timestamp DateAcct) {
        super.setDateAcct(DateAcct);
        if (DateAcct == null) {
            return;
        }
        if (this.getC_Period_ID() != 0) {
            return;
        }
        int C_Period_ID = MPeriod.getC_Period_ID((Properties)this.getCtx(), (Timestamp)DateAcct, (int)this.getAD_Org_ID());
        if (C_Period_ID == 0) {
            this.log.warning("setDateAcct - Period not found");
        } else {
            this.setC_Period_ID(C_Period_ID);
        }
    }

    public void setCurrency(int C_Currency_ID, int C_ConversionType_ID, BigDecimal CurrencyRate) {
        if (C_Currency_ID != 0) {
            this.setC_Currency_ID(C_Currency_ID);
        }
        if (C_ConversionType_ID != 0) {
            this.setC_ConversionType_ID(C_ConversionType_ID);
        }
        if (CurrencyRate != null && CurrencyRate.compareTo(Env.ZERO) == 0) {
            this.setCurrencyRate(CurrencyRate);
        }
    }

    public void addDescription(String description) {
        String desc = this.getDescription();
        if (desc == null) {
            this.setDescription(description);
        } else {
            this.setDescription(desc + " | " + description);
        }
    }

    public MJournalLine[] getLines(boolean requery) {
        String whereClause = "GL_Journal_ID=?";
        List list = new Query(this.getCtx(), "GL_JournalLine", "GL_Journal_ID=?", this.get_TrxName()).setParameters(new Object[]{this.getGL_Journal_ID()}).setOrderBy("Line").list();
        MJournalLine[] retValue = new MJournalLine[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public int copyLinesFrom(MJournal fromJournal, Timestamp dateAcct, char typeCR) {
        if (this.isProcessed() || fromJournal == null) {
            return 0;
        }
        int count = 0;
        MJournalLine[] fromLines = fromJournal.getLines(false);
        for (int i = 0; i < fromLines.length; ++i) {
            MJournalLine toLine = new MJournalLine(this.getCtx(), 0, fromJournal.get_TrxName());
            PO.copyValues((PO)fromLines[i], (PO)toLine, (int)this.getAD_Client_ID(), (int)this.getAD_Org_ID());
            toLine.setGL_Journal_ID(this.getGL_Journal_ID());
            if (dateAcct != null) {
                toLine.setDateAcct(dateAcct);
            }
            if (typeCR == 'C') {
                toLine.setAmtSourceDr(fromLines[i].getAmtSourceDr().negate());
                toLine.setAmtSourceCr(fromLines[i].getAmtSourceCr().negate());
            } else if (typeCR == 'R') {
                toLine.setAmtSourceDr(fromLines[i].getAmtSourceCr());
                toLine.setAmtSourceCr(fromLines[i].getAmtSourceDr());
            }
            toLine.setIsGenerated(true);
            toLine.setProcessed(false);
            if (!toLine.save()) continue;
            ++count;
        }
        if (fromLines.length != count) {
            this.log.log(Level.SEVERE, "Line difference - JournalLines=" + fromLines.length + " <> Saved=" + count);
        }
        return count;
    }

    public void setProcessed(boolean processed) {
        super.setProcessed(processed);
        if (this.get_ID() == 0) {
            return;
        }
        String sql = "UPDATE GL_JournalLine SET Processed='" + (processed ? "Y" : "N") + "' WHERE GL_Journal_ID=" + this.getGL_Journal_ID();
        int noLine = DB.executeUpdate((String)sql, (String)this.get_TrxName());
        this.log.fine(processed + " - Lines=" + noLine);
    }

    protected boolean beforeSave(boolean newRecord) {
        if (this.getDateDoc() == null) {
            if (this.getDateAcct() == null) {
                this.setDateDoc(new Timestamp(System.currentTimeMillis()));
            } else {
                this.setDateDoc(this.getDateAcct());
            }
        }
        if (this.getDateAcct() == null) {
            this.setDateAcct(this.getDateDoc());
        }
        if (this.is_ValueChanged("DateAcct")) {
            int no = DB.executeUpdate((String)"UPDATE GL_JournalLine SET DateAcct=? WHERE GL_Journal_ID=?", (Object[])new Object[]{this.getDateAcct(), this.getGL_Journal_ID()}, (boolean)false, (String)this.get_TrxName());
            this.log.finest("Updated GL_JournalLine.DateAcct #" + no);
        }
        return true;
    }

    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!success) {
            return success;
        }
        return this.updateBatch();
    }

    protected boolean afterDelete(boolean success) {
        if (!success) {
            return success;
        }
        return this.updateBatch();
    }

    private boolean updateBatch() {
        if (this.getGL_JournalBatch_ID() != 0) {
            StringBuilder sql = new StringBuilder("UPDATE GL_JournalBatch jb").append(" SET (TotalDr, TotalCr) = (SELECT COALESCE(SUM(TotalDr),0), COALESCE(SUM(TotalCr),0)").append(" FROM GL_Journal j WHERE j.IsActive='Y' AND jb.GL_JournalBatch_ID=j.GL_JournalBatch_ID) ").append("WHERE GL_JournalBatch_ID=").append(this.getGL_JournalBatch_ID());
            int no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
            if (no != 1) {
                this.log.warning("afterSave - Update Batch #" + no);
            }
            return no == 1;
        }
        return true;
    }

    public boolean processIt(String processAction) {
        this.processMessage = null;
        DocumentEngine engine = new DocumentEngine((DocAction)this, this.getDocStatus());
        return engine.processIt(processAction, this.getDocAction());
    }

    public boolean unlockIt() {
        this.log.info(this.toString());
        this.setProcessing(false);
        return true;
    }

    public boolean invalidateIt() {
        this.log.info(this.toString());
        return true;
    }

    public String prepareIt() {
        MAcctSchemaGL gl;
        MJournalLine[] lines;
        this.log.info(this.toString());
        this.processMessage = ModelValidationEngine.get().fireDocValidate((PO)this, 1);
        if (this.processMessage != null) {
            return "IN";
        }
        MDocType docType = MDocType.get((Properties)this.getCtx(), (int)this.getC_DocType_ID());
        MPeriod currentPeriod = MPeriod.get((Properties)this.getCtx(), (int)this.getC_Period_ID());
        assert (currentPeriod != null);
        if ("A".equals(currentPeriod.getPeriodType())) {
            boolean open = currentPeriod.isOpen(docType.getDocBaseType(), this.getDateAcct());
            if (!open) {
                this.log.warning(currentPeriod.getName() + ": Not open for " + docType.getDocBaseType() + " (" + String.valueOf(this.getDateAcct()) + ")");
                this.processMessage = "@PeriodClosed@";
                return "IN";
            }
        } else {
            MPeriod period = MPeriod.get((Properties)this.getCtx(), (Timestamp)this.getDateAcct(), (int)this.getAD_Org_ID(), (String)this.get_TrxName());
            if (period == null) {
                this.log.warning("No Period for " + String.valueOf(this.getDateAcct()));
                this.processMessage = "@PeriodNotFound@";
                return "IN";
            }
            if (period.getC_Period_ID() != this.getC_Period_ID() && period.isStandardPeriod()) {
                this.processMessage = "@PeriodNotValid@";
                return "IN";
            }
            boolean open = MPeriod.isOpen((Properties)this.getCtx(), (Timestamp)this.getDateAcct(), (String)docType.getDocBaseType(), (int)this.getAD_Org_ID(), (String)this.get_TrxName());
            if (!open) {
                this.log.warning(period.getName() + ": Not open for " + docType.getDocBaseType() + " (" + String.valueOf(this.getDateAcct()) + ")");
                this.processMessage = "@PeriodClosed@";
                return "IN";
            }
        }
        if ((lines = this.getLines(true)).length == 0) {
            this.processMessage = "@NoLines@";
            return "IN";
        }
        BigDecimal amountSourceDr = Env.ZERO;
        BigDecimal amountSourceCr = Env.ZERO;
        for (MJournalLine line : lines) {
            if (!this.isActive()) continue;
            if (line.getAccountElementValue() == null) {
                this.processMessage = "@C_ValidCombination_ID@ @NotFound@";
                return "IN";
            }
            if (!line.getAccountElementValue().isActive()) {
                this.processMessage = "@InActiveAccount@ - @Line@=" + line.getLine() + " - " + String.valueOf((Object)line.getAccountElementValue());
                return "IN";
            }
            if (currentPeriod.isStandardPeriod() && line.isDocControlled() && (this.getPostingType().equals("A") || this.getPostingType().equals("E") || this.getPostingType().equals("R"))) {
                this.processMessage = "@DocControlledError@ - @Line@=" + line.getLine() + " - " + String.valueOf((Object)line.getAccountElementValue());
                return "IN";
            }
            if (this.getPostingType().equals("A") && !line.getAccountElementValue().isPostActual()) {
                this.processMessage = "@PostingTypeActualError@ - @Line@=" + line.getLine() + " - " + String.valueOf((Object)line.getAccountElementValue());
                return "IN";
            }
            if (this.getPostingType().equals("B") && !line.getAccountElementValue().isPostBudget()) {
                this.processMessage = "@PostingTypeBudgetError@ - @Line@=" + line.getLine() + " - " + String.valueOf((Object)line.getAccountElementValue());
                return "IN";
            }
            if (this.getPostingType().equals("S") && !line.getAccountElementValue().isPostStatistical()) {
                this.processMessage = "@PostingTypeStatisticalError@ - @Line@=" + line.getLine() + " - " + String.valueOf((Object)line.getAccountElementValue());
                return "IN";
            }
            amountSourceDr = amountSourceDr.add(line.getAmtSourceDr());
            amountSourceCr = amountSourceCr.add(line.getAmtSourceCr());
        }
        this.setTotalDr(amountSourceDr);
        this.setTotalCr(amountSourceCr);
        if (Env.ZERO.compareTo(this.getControlAmt()) != 0 && this.getControlAmt().compareTo(this.getTotalDr()) != 0) {
            this.processMessage = "@ControlAmtError@";
            return "IN";
        }
        if (!(amountSourceDr.compareTo(amountSourceCr) == 0 || (gl = MAcctSchemaGL.get((Properties)this.getCtx(), (int)this.getC_AcctSchema_ID())) != null && gl.isUseSuspenseBalancing())) {
            this.processMessage = "@UnbalancedJornal@";
            return "IN";
        }
        if (!"CO".equals(this.getDocAction())) {
            this.setDocAction("CO");
        }
        this.processMessage = ModelValidationEngine.get().fireDocValidate((PO)this, 8);
        if (this.processMessage != null) {
            return "IN";
        }
        this.justPrepared = true;
        return "IP";
    }

    public boolean approveIt() {
        this.log.info(this.toString());
        this.setIsApproved(true);
        return true;
    }

    public boolean rejectIt() {
        this.log.info(this.toString());
        this.setIsApproved(false);
        return true;
    }

    public String completeIt() {
        String status;
        if (!this.justPrepared && !"IP".equals(status = this.prepareIt())) {
            return status;
        }
        this.processMessage = ModelValidationEngine.get().fireDocValidate((PO)this, 7);
        if (this.processMessage != null) {
            return "IN";
        }
        if (!this.isApproved()) {
            this.approveIt();
        }
        this.log.info(this.toString());
        String valid = ModelValidationEngine.get().fireDocValidate((PO)this, 9);
        if (valid != null) {
            this.processMessage = valid;
            return "IN";
        }
        this.setDefiniteDocumentNo();
        this.setProcessed(true);
        this.setDocAction("CL");
        return "CO";
    }

    private void setDefiniteDocumentNo() {
        String value;
        Boolean isOverwrite;
        MDocType dt = MDocType.get((Properties)this.getCtx(), (int)this.getC_DocType_ID());
        if (dt.isOverwriteDateOnComplete()) {
            this.setDateDoc(new Timestamp(System.currentTimeMillis()));
        }
        if (dt.isOverwriteSeqOnComplete() && (isOverwrite = Boolean.valueOf(!this.isReversal() || this.isReversal() && !dt.isCopyDocNoOnReversal())).booleanValue() && (value = DB.getDocumentNo((int)this.getC_DocType_ID(), (String)this.get_TrxName(), (boolean)true, (PO)this)) != null) {
            this.setDocumentNo(value);
        }
    }

    public boolean voidIt() {
        this.log.info(this.toString());
        this.processMessage = ModelValidationEngine.get().fireDocValidate((PO)this, 2);
        if (this.processMessage != null) {
            return false;
        }
        boolean ok_to_void = false;
        if (!"DR".equals(this.getDocStatus()) && !"IN".equals(this.getDocStatus())) {
            return false;
        }
        this.setProcessed(true);
        this.setDocAction("--");
        ok_to_void = true;
        this.processMessage = ModelValidationEngine.get().fireDocValidate((PO)this, 10);
        if (this.processMessage != null) {
            return false;
        }
        return ok_to_void;
    }

    public boolean closeIt() {
        this.log.info(this.toString());
        this.processMessage = ModelValidationEngine.get().fireDocValidate((PO)this, 3);
        if (this.processMessage != null) {
            return false;
        }
        boolean ok_to_close = false;
        if (!"CO".equals(this.getDocStatus())) {
            return false;
        }
        this.setProcessed(true);
        this.setDocAction("--");
        ok_to_close = true;
        this.processMessage = ModelValidationEngine.get().fireDocValidate((PO)this, 11);
        if (this.processMessage != null) {
            return false;
        }
        return ok_to_close;
    }

    public MJournal reverseIt(boolean isAccrual) {
        Timestamp currentDate = new Timestamp(System.currentTimeMillis());
        Optional<Timestamp> loginDateOptional = Optional.of(Env.getContextAsDate((Properties)this.getCtx(), (String)"#Date"));
        Timestamp reversalDate = isAccrual ? loginDateOptional.orElseGet(() -> currentDate) : this.getDateAcct();
        MPeriod.testPeriodOpen((Properties)this.getCtx(), (Timestamp)reversalDate, (int)this.getC_DocType_ID(), (int)this.getAD_Org_ID(), (String)this.get_TrxName());
        this.log.info(this.toString());
        MJournal reverse = new MJournal(this);
        reverse.setGL_JournalBatch_ID(this.getGL_JournalBatch_ID());
        reverse.setDateDoc(reversalDate);
        reverse.set_ValueNoCheck("C_Period_ID", null);
        reverse.setDateAcct(reversalDate);
        reverse.setControlAmt(this.getControlAmt().negate());
        reverse.addDescription("(->" + this.getDocumentNo() + ")");
        reverse.setReversal_ID(this.getGL_Journal_ID());
        reverse.set_ValueNoCheck("DocumentNo", null);
        MDocType docType = MDocType.get((Properties)this.getCtx(), (int)this.getC_DocType_ID());
        if (docType.isCopyDocNoOnReversal()) {
            reverse.setDocumentNo(this.getDocumentNo() + Msg.getMsg((Properties)this.getCtx(), (String)"^"));
        }
        reverse.saveEx();
        this.addDescription("(" + reverse.getDocumentNo() + "<-)");
        reverse.copyLinesFrom(this, reversalDate, 'R');
        boolean sucess = reverse.processIt("CO");
        if (!sucess) {
            throw new AdempiereException(reverse.getProcessMsg());
        }
        reverse.closeIt();
        reverse.setProcessing(false);
        reverse.setDocStatus("RE");
        reverse.setDocAction("--");
        reverse.saveEx(this.get_TrxName());
        this.setProcessed(true);
        this.setReversal_ID(reverse.getGL_Journal_ID());
        this.setDocAction("--");
        this.setDocStatus("RE");
        return reverse;
    }

    public boolean reverseCorrectIt() {
        this.processMessage = ModelValidationEngine.get().fireDocValidate((PO)this, 5);
        if (this.processMessage != null) {
            return false;
        }
        MJournal reversal = this.reverseIt(false);
        if (reversal == null) {
            return false;
        }
        this.processMessage = reversal.getDocumentInfo();
        this.processMessage = ModelValidationEngine.get().fireDocValidate((PO)this, 13);
        return this.processMessage == null;
    }

    public boolean reverseAccrualIt() {
        this.processMessage = ModelValidationEngine.get().fireDocValidate((PO)this, 6);
        if (this.processMessage != null) {
            return false;
        }
        MJournal reversal = this.reverseIt(true);
        if (reversal == null) {
            return false;
        }
        this.processMessage = reversal.getDocumentInfo();
        this.processMessage = ModelValidationEngine.get().fireDocValidate((PO)this, 14);
        return this.processMessage == null;
    }

    public void setReversal(boolean isReversal) {
        this.isReversal = isReversal;
    }

    public boolean isReversal() {
        return this.isReversal;
    }

    public MJournal reverseCorrectIt(int GL_JournalBatch_ID) {
        this.log.info(this.toString());
        MJournal reverse = new MJournal(this);
        reverse.setGL_JournalBatch_ID(GL_JournalBatch_ID);
        reverse.setDateDoc(this.getDateDoc());
        reverse.setC_Period_ID(this.getC_Period_ID());
        reverse.setDateAcct(this.getDateAcct());
        reverse.setControlAmt(this.getControlAmt().negate());
        reverse.addDescription("(->" + this.getDocumentNo() + ")");
        reverse.setReversal_ID(this.getGL_Journal_ID());
        reverse.set_ValueNoCheck("DocumentNo", null);
        MDocType docType = MDocType.get((Properties)this.getCtx(), (int)this.getC_DocType_ID());
        if (docType.isCopyDocNoOnReversal()) {
            reverse.setDocumentNo(this.getDocumentNo() + Msg.getMsg((Properties)this.getCtx(), (String)"Cancelled"));
        }
        reverse.saveEx();
        this.addDescription("(" + reverse.getDocumentNo() + "<-)");
        reverse.copyLinesFrom(this, null, 'C');
        boolean sucess = reverse.processIt("CO");
        if (!sucess) {
            throw new AdempiereException(reverse.getProcessMsg());
        }
        reverse.setDocAction("--");
        reverse.setDocStatus("RE");
        reverse.saveEx();
        this.setProcessed(true);
        this.setReversal_ID(reverse.getGL_Journal_ID());
        this.setDocAction("--");
        this.setDocStatus("RE");
        return reverse;
    }

    public MJournal reverseAccrualIt(int GL_JournalBatch_ID) {
        this.log.info(this.toString());
        MJournal reverse = new MJournal(this);
        reverse.setGL_JournalBatch_ID(GL_JournalBatch_ID);
        reverse.setDateDoc(new Timestamp(System.currentTimeMillis()));
        reverse.set_ValueNoCheck("C_Period_ID", null);
        reverse.setDateAcct(reverse.getDateDoc());
        Object description = reverse.getDescription();
        description = description == null ? "** " + this.getDocumentNo() + " **" : (String)description + " ** " + this.getDocumentNo() + " **";
        reverse.setDescription((String)description);
        if (!reverse.save()) {
            return null;
        }
        reverse.copyLinesFrom(this, reverse.getDateAcct(), 'R');
        this.setProcessed(true);
        this.setDocAction("--");
        return reverse;
    }

    public boolean reActivateIt() {
        this.log.info(this.toString());
        this.processMessage = ModelValidationEngine.get().fireDocValidate((PO)this, 4);
        if (this.processMessage != null) {
            return false;
        }
        MPeriod.testPeriodOpen((Properties)this.getCtx(), (Timestamp)this.getDateAcct(), (int)this.getC_DocType_ID(), (int)this.getAD_Org_ID(), (String)this.get_TrxName());
        MFactAcct.deleteEx((int)Table_ID, (int)this.get_ID(), (String)this.get_TrxName());
        this.setPosted(false);
        this.setProcessed(false);
        this.setDocAction("CO");
        this.processMessage = ModelValidationEngine.get().fireDocValidate((PO)this, 12);
        return this.processMessage == null;
    }

    public String getSummary() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getDocumentNo());
        sb.append(": ").append(Msg.translate((Properties)this.getCtx(), (String)"TotalDr")).append("=").append(this.getTotalDr()).append(" ").append(Msg.translate((Properties)this.getCtx(), (String)"TotalCR")).append("=").append(this.getTotalCr()).append(" (#").append(this.getLines(false).length).append(")");
        if (this.getDescription() != null && this.getDescription().length() > 0) {
            sb.append(" - ").append(this.getDescription());
        }
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MJournal[");
        sb.append(this.get_ID()).append(",").append(this.getDescription()).append(",DR=").append(this.getTotalDr()).append(",CR=").append(this.getTotalCr()).append("]");
        return sb.toString();
    }

    public String getDocumentInfo() {
        MDocType dt = MDocType.get((Properties)this.getCtx(), (int)this.getC_DocType_ID());
        return dt.getName() + " " + this.getDocumentNo();
    }

    public File createPDF() {
        try {
            File temp = File.createTempFile(this.get_TableName() + this.get_ID() + "_", ".pdf");
            return this.createPDF(temp);
        }
        catch (Exception e) {
            this.log.severe("Could not create PDF - " + e.getMessage());
            return null;
        }
    }

    public File createPDF(File file) {
        return null;
    }

    public String getProcessMsg() {
        return this.processMessage;
    }

    public int getDoc_User_ID() {
        return this.getCreatedBy();
    }

    public BigDecimal getApprovalAmt() {
        return this.getTotalDr();
    }

    public boolean isComplete() {
        String ds = this.getDocStatus();
        return "CO".equals(ds) || "CL".equals(ds) || "RE".equals(ds);
    }
}

