/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.File;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import org.adempiere.core.domains.models.I_M_ProductionLine;
import org.adempiere.core.domains.models.X_M_Production;
import org.adempiere.core.domains.models.X_PP_Product_BOM;
import org.adempiere.core.domains.models.X_PP_Product_BOMLine;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.PeriodClosedException;
import org.compiere.acct.Doc_Production;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MAttributeSet;
import org.compiere.model.MAttributeSetInstance;
import org.compiere.model.MClient;
import org.compiere.model.MCostType;
import org.compiere.model.MDocType;
import org.compiere.model.MLocator;
import org.compiere.model.MMovement;
import org.compiere.model.MMovementLine;
import org.compiere.model.MOrderLine;
import org.compiere.model.MPeriod;
import org.compiere.model.MProduct;
import org.compiere.model.MProductionBatch;
import org.compiere.model.MProductionBatchLine;
import org.compiere.model.MProductionLine;
import org.compiere.model.MProductionLineMA;
import org.compiere.model.MProductionPlan;
import org.compiere.model.MStorage;
import org.compiere.model.MSysConfig;
import org.compiere.model.MTransaction;
import org.compiere.model.MUOM;
import org.compiere.model.MWarehouse;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.process.DocAction;
import org.compiere.process.DocumentEngine;
import org.compiere.process.DocumentReversalEnabled;
import org.compiere.process.ProcessInfo;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.eevolution.services.dsl.ProcessBuilder;

public class MProduction
extends X_M_Production
implements DocAction,
DocumentReversalEnabled {
    private static final long serialVersionUID = -8141439503963346402L;
    private static CLogger log = CLogger.getCLogger(MProduction.class);
    private int lineno;
    private MProductionBatch parent = null;
    private String m_processMsg = null;
    private boolean m_justPrepared = false;
    private boolean m_reversal = false;

    public MProduction(Properties ctx, int M_Production_ID, String trxName) {
        super(ctx, M_Production_ID, trxName);
        if (M_Production_ID == 0) {
            this.setDocStatus("DR");
            this.setDocAction("PR");
        }
    }

    public MProduction(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MProduction(MOrderLine line) {
        super(line.getCtx(), 0, line.get_TrxName());
        MProduct product = MProduct.get(this.getCtx(), line.getM_Product_ID());
        this.setAD_Client_ID(line.getAD_Client_ID());
        this.setAD_Org_ID(line.getAD_Org_ID());
        this.setMovementDate(line.getDatePromised());
        this.setM_Product_ID(line.getM_Product_ID());
        this.setProductionQty(line.getQtyOrdered().subtract(line.getQtyDelivered()));
        this.setDatePromised(line.getDatePromised());
        int locator = product.getM_Locator_ID();
        if (locator == 0) {
            locator = MWarehouse.get((Properties)this.getCtx(), (int)line.getM_Warehouse_ID()).getDefaultLocator().get_ID();
        }
        this.setM_Locator_ID(locator);
        this.setC_OrderLine_ID(line.getC_OrderLine_ID());
    }

    public MProduction(MProductionBatch batch) {
        super(batch.getCtx(), 0, batch.get_TrxName());
        this.setFromBatch(batch);
    }

    public MProductionBatch getParent(boolean reload) {
        if (this.parent == null && this.getM_ProductionBatch_ID() != 0) {
            this.parent = (MProductionBatch)this.getM_ProductionBatch();
        }
        return this.parent;
    }

    public MProductionBatch getParent() {
        return this.getParent(false);
    }

    private void processFromBatch() {
        MMovement[] moves;
        MProductionLine[] lines;
        if (this.getParent() == null) {
            throw new AdempiereException("@M_ProductionBatch_ID@ @NotFound@");
        }
        if (this.parent.isProcessed()) {
            if (this.parent.getDocStatus().equals("CL")) {
                throw new AdempiereException("@M_ProductionBatch_ID@ @closed@");
            }
            if (this.parent.getDocStatus().equals("VO")) {
                throw new AdempiereException("@M_ProductionBatch_ID@ @Voided@");
            }
            if (this.parent.getDocStatus().equals("CO") && this.parent.getQtyCompleted().compareTo(this.parent.getTargetQty()) > 0) {
                throw new AdempiereException("@QtyCompleted@ > @TargetQty@");
            }
        } else {
            throw new AdempiereException("@M_ProductionBatch_ID@ @Unprocessed@");
        }
        StringBuilder errors = new StringBuilder();
        for (MProductionLine line : lines = this.getLines_OrderedByIsEndProduct()) {
            MProduct product = (MProduct)line.getM_Product();
            MAttributeSet as = product.getAttributeSet();
            if (as != null && (as.isMandatoryAlways() || as.isSerNo() && as.isSerNoMandatory() || as.isLot() && as.isLotMandatory()) && line.getM_AttributeSetInstance_ID() == 0) {
                errors.append("@M_AttributeSet_ID@ @IsMandatory@ (@Line@ #" + line.getLine() + ", @M_Product_ID@ = " + product.getValue() + ")").append(Env.NL);
            }
            if (!this.isMustBeStocked() || line.isEndProduct() || this.isReversal() || !product.isStocked() || !line.isActive()) continue;
            String MMPolicy = product.getMMPolicy();
            MStorage[] storages = MStorage.getWarehouse(this.getCtx(), 0, product.getM_Product_ID(), line.getM_AttributeSetInstance_ID(), null, "F".equals(MMPolicy), true, line.getM_Locator_ID(), this.get_TrxName());
            BigDecimal qtyOnHand = Env.ZERO;
            if (storages != null && storages.length > 0) {
                for (MStorage storage : storages) {
                    qtyOnHand = qtyOnHand.add(storage.getQtyOnHand());
                }
            }
            log.config("qtyOnHand=" + String.valueOf(qtyOnHand) + " movementQty=" + String.valueOf(line.getMovementQty()) + " " + String.valueOf((Object)product));
            if (qtyOnHand.add(line.getMovementQty()).compareTo(Env.ZERO) >= 0) continue;
            errors.append(Msg.translate((Properties)this.getCtx(), (String)"NotEnoughStocked") + " " + product.getName() + ": " + Msg.translate((Properties)this.getCtx(), (String)"QtyAvailable") + " " + qtyOnHand.toString() + ".\n");
        }
        if (errors.length() > 0) {
            throw new AdempiereException(errors.toString());
        }
        for (MMovement move : moves = this.parent.getMovements(true)) {
            if (move.isProcessed()) continue;
            errors.append("@M_Movement_ID@ =" + move.getDocumentNo() + " @Unprocessed@");
        }
        if (errors.length() > 0) {
            throw new AdempiereException(errors.toString());
        }
        Arrays.asList(lines).forEach(productionLine -> this.createTransaction((MProductionLine)((Object)productionLine)));
        this.updateQtyHeader(false);
        this.parent.createComplementProduction();
    }

    private void updateQtyHeader(boolean isVoid) {
        if (this.getParent() == null) {
            return;
        }
        BigDecimal productionQty = this.getProductionQty();
        if (isVoid) {
            productionQty = productionQty.negate();
        }
        this.parent.setQtyReserved(this.parent.getQtyReserved().subtract(productionQty));
        this.parent.setQtyCompleted(this.parent.getQtyCompleted().add(productionQty));
        this.parent.saveEx(this.get_TrxName());
    }

    private String processFromPlan() {
        return null;
    }

    private void createTransaction(MProductionLine productionLine) {
        MProduct product = productionLine.getProduct();
        MLocator locator = MLocator.get((Properties)this.getCtx(), (int)productionLine.getM_Locator_ID());
        String movementType = productionLine.isEndProduct() ? "P+" : "P-";
        BigDecimal quantity = productionLine.getMovementQty();
        log.info("Line=" + productionLine.getLine() + " - Qty=" + String.valueOf(productionLine.getMovementQty()));
        if (product != null && product.isStocked() && product != null) {
            if (this.getReversal_ID() == 0) {
                this.checkMaterialPolicy(productionLine, movementType);
            }
            log.fine("Material Transaction");
            MTransaction transaction = null;
            if (productionLine.getM_AttributeSetInstance_ID() == 0) {
                MProductionLineMA[] list;
                for (MProductionLineMA ma : list = MProductionLineMA.get((Properties)this.getCtx(), (int)productionLine.getM_ProductionLine_ID(), (String)this.get_TrxName())) {
                    MProductionBatchLine pbLine;
                    if (productionLine.getM_AttributeSetInstance_ID() != 0 && productionLine.getM_AttributeSetInstance_ID() != ma.getM_AttributeSetInstance_ID()) continue;
                    BigDecimal quantityMA = ma.getMovementQty();
                    if (!MStorage.add(this.getCtx(), locator.getM_Warehouse_ID(), productionLine.getM_Locator_ID(), productionLine.getM_Product_ID(), ma.getM_AttributeSetInstance_ID(), 0, quantityMA.negate(), Env.ZERO, Env.ZERO, this.get_TrxName())) {
                        throw new AdempiereException("@M_Transaction_ID@ @no@ @Created@");
                    }
                    transaction = new MTransaction(this.getCtx(), productionLine.getAD_Org_ID(), movementType, productionLine.getM_Locator_ID(), productionLine.getM_Product_ID(), ma.getM_AttributeSetInstance_ID(), quantityMA.negate(), productionLine.getParent().getMovementDate(), this.get_TrxName());
                    transaction.setM_ProductionLine_ID(productionLine.getM_ProductionLine_ID());
                    BigDecimal quantityReserved = productionLine.getMovementQty();
                    if (this.getM_ProductionBatch_ID() > 0 && (pbLine = MProductionBatchLine.getbyProduct((int)this.getM_ProductionBatch_ID(), (int)productionLine.getM_Product_ID(), (Properties)this.getCtx(), (String)this.get_TrxName())) != null) {
                        pbLine.setQtyReserved(pbLine.getQtyReserved().add(quantityReserved));
                        pbLine.saveEx();
                    }
                    transaction.saveEx();
                }
            }
            if (transaction == null) {
                BigDecimal qtyreserved;
                MAttributeSetInstance asi = null;
                int reservationAttributeSetInstance_ID = productionLine.getM_AttributeSetInstance_ID();
                int transactionAttributeSetInstance_ID = productionLine.getM_AttributeSetInstance_ID();
                if (productionLine.getM_AttributeSetInstance_ID() == 0) {
                    MAttributeSet.validateAttributeSetInstanceMandatory((MProduct)product, (int)MProductionLine.Table_ID, (boolean)false, (int)productionLine.getM_AttributeSetInstance_ID());
                    asi = product.getM_AttributeSet_ID() == 0 ? MAttributeSetInstance.get(this.p_ctx, 0, product.getM_Product_ID()) : MAttributeSetInstance.create(this.p_ctx, product, this.get_TrxName());
                    productionLine.setM_AttributeSetInstance_ID(asi.getM_AttributeSetInstance_ID());
                    transactionAttributeSetInstance_ID = asi.getM_AttributeSetInstance_ID();
                    log.config("New ASI=" + String.valueOf((Object)productionLine));
                }
                if (!MStorage.add(this.getCtx(), locator.getM_Warehouse_ID(), productionLine.getM_Locator_ID(), productionLine.getM_Product_ID(), transactionAttributeSetInstance_ID, reservationAttributeSetInstance_ID, quantity, Env.ZERO, Env.ZERO, this.get_TrxName())) {
                    throw new AdempiereException("@M_Transaction_ID@ @no@ @Created@");
                }
                transaction = new MTransaction(this.getCtx(), productionLine.getAD_Org_ID(), movementType, productionLine.getM_Locator_ID(), productionLine.getM_Product_ID(), productionLine.getM_AttributeSetInstance_ID(), quantity, productionLine.getParent().getMovementDate(), this.get_TrxName());
                transaction.setM_ProductionLine_ID(productionLine.getM_ProductionLine_ID());
                transaction.saveEx();
                BigDecimal bigDecimal = qtyreserved = productionLine.isEndProduct() ? productionLine.getMovementQty() : productionLine.getMovementQty().negate();
                if (this.getM_ProductionBatch_ID() > 0) {
                    MProductionBatchLine pbLine = MProductionBatchLine.getbyProduct((int)this.getM_ProductionBatch_ID(), (int)this.getM_Product_ID(), (Properties)this.getCtx(), (String)this.get_TrxName());
                    pbLine.setQtyReserved(pbLine.getQtyReserved().subtract(qtyreserved));
                    pbLine.saveEx();
                }
            }
        }
        productionLine.setQtyReserved(productionLine.getQtyReserved().add(productionLine.getMovementQty()));
        productionLine.setProcessed(true);
        productionLine.saveEx(this.get_TrxName());
    }

    public void setProcessed(boolean Processed) {
        super.setProcessed(Processed);
        for (MProductionPlan plan : this.getProductionPlan()) {
            plan.setProcessed(Processed);
            plan.saveEx();
        }
        for (MProductionLine line : this.getLines()) {
            line.setProcessed(Processed);
            line.saveEx();
        }
    }

    public List<MProductionPlan> getProductionPlan() {
        String whereClause = "M_Production_ID=? ";
        return new Query(this.getCtx(), "M_ProductionPlan", whereClause, this.get_TrxName()).setParameters(new Object[]{this.getM_Production_ID()}).setOrderBy("Line").list();
    }

    public MProductionLine[] getLines() {
        String whereClause = "M_Production_ID=? ";
        List list = new Query(this.getCtx(), "M_ProductionLine", whereClause, this.get_TrxName()).setParameters(new Object[]{this.getM_Production_ID()}).setOrderBy("Line").list();
        return list.toArray(new MProductionLine[list.size()]);
    }

    public MProductionLine[] getLines_OrderedByIsEndProduct() {
        String whereClause = "M_Production_ID=? ";
        List list = new Query(this.getCtx(), "M_ProductionLine", whereClause, this.get_TrxName()).setParameters(new Object[]{this.getM_Production_ID()}).setOrderBy("IsEndProduct,Line").list();
        return list.toArray(new MProductionLine[list.size()]);
    }

    private void deleteLines() {
        for (MProductionLine line : this.getLines()) {
            line.deleteEx(true);
        }
    }

    protected boolean beforeDelete() {
        if (this.isProcessed()) {
            return false;
        }
        this.deleteLines();
        return true;
    }

    public boolean processIt(String processAction) {
        this.m_processMsg = null;
        DocumentEngine engine = new DocumentEngine((DocAction)this, this.getDocStatus());
        return engine.processIt(processAction, this.getDocAction());
    }

    public boolean unlockIt() {
        if (log.isLoggable(Level.INFO)) {
            log.info("unlockIt - " + this.toString());
        }
        return true;
    }

    public boolean invalidateIt() {
        if (log.isLoggable(Level.INFO)) {
            log.info(this.toString());
        }
        this.setDocAction("PR");
        return true;
    }

    public String completeIt() {
        String status;
        if (!this.m_justPrepared && !"IP".equals(status = this.prepareIt())) {
            return status;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 7);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.m_processMsg = this.validateHeader();
        if (this.getM_ProductionBatch_ID() != 0) {
            this.processFromBatch();
        } else {
            MProductionLine[] lines;
            for (MProductionLine line : lines = this.getLines_OrderedByIsEndProduct()) {
                this.createTransaction(line);
            }
        }
        if (this.m_processMsg != null) {
            return "IN";
        }
        String valid = ModelValidationEngine.get().fireDocValidate((PO)this, 9);
        if (valid != null) {
            this.m_processMsg = valid;
            return "IN";
        }
        this.setProcessed(true);
        this.setDocAction("CL");
        return "CO";
    }

    public String prepareIt() {
        if (log.isLoggable(Level.INFO)) {
            log.info(this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        MPeriod.testPeriodOpen((Properties)this.getCtx(), (Timestamp)this.getMovementDate(), (String)"MOP", (int)this.getAD_Org_ID());
        this.m_processMsg = this.validateEndProduct(this.getM_Product_ID());
        if (!Util.isEmpty((String)this.m_processMsg)) {
            return "IN";
        }
        this.m_processMsg = this.validateHeader();
        if (this.m_processMsg != null) {
            return "IN";
        }
        if (!this.isReversal()) {
            this.createLines();
            for (MProductionLine l : this.getLines_OrderedByIsEndProduct()) {
                if (l.getProduct() == null || !l.getProduct().isStocked()) continue;
                String movType = null;
                movType = l.isEndProduct() ? (l.getM_Production().getProductionQty().signum() > 0 ? "P+" : "P-") : (l.getM_Production().getProductionQty().signum() > 0 ? "P-" : "P+");
                this.checkMaterialPolicy(l, movType);
            }
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 8);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.m_justPrepared = true;
        if (!"CO".equals(this.getDocAction())) {
            this.setDocAction("CO");
        }
        return "IP";
    }

    private String validateHeader() {
        if (this.getM_Product_ID() != 0) {
            if (Optional.ofNullable(this.getProductionQty()).orElse(Env.ZERO).compareTo(Env.ZERO) == 0 && !this.isReversal()) {
                return "@ProductionQty@ = 0";
            }
            if (this.getM_Locator_ID() == 0) {
                return "@M_Locator_ID@ @NotFound@";
            }
        }
        return null;
    }

    private String validateEndProduct(int M_Product_ID) {
        String msg = this.isBOM(M_Product_ID);
        if (!Util.isEmpty((String)msg)) {
            return msg;
        }
        return null;
    }

    private String isBOM(int M_Product_ID) {
        MProduct product = MProduct.get(this.getCtx(), M_Product_ID);
        if (!product.isBOM()) {
            return "@NotBOM@ [" + product.getValue() + "-" + product.getName() + "]";
        }
        if (this.getDefaultProductBom(product, this.get_TrxName()) == null) {
            return "@NotBOMProducts@";
        }
        return null;
    }

    public boolean approveIt() {
        return true;
    }

    public boolean rejectIt() {
        return true;
    }

    public boolean voidIt() {
        if (log.isLoggable(Level.INFO)) {
            log.info(this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 2);
        if (this.m_processMsg != null) {
            return false;
        }
        if ("CL".equals(this.getDocStatus()) || "RE".equals(this.getDocStatus()) || "VO".equals(this.getDocStatus())) {
            this.m_processMsg = "Document Closed: " + this.getDocStatus();
            this.setDocAction("--");
            return false;
        }
        if (!this.isProcessed()) {
            this.setIsCreated(false);
            this.deleteLines();
            this.setProductionQty(BigDecimal.ZERO);
        } else {
            boolean accrual = false;
            try {
                MPeriod.testPeriodOpen((Properties)this.getCtx(), (Timestamp)this.getMovementDate(), (String)"MOP", (int)this.getAD_Org_ID());
            }
            catch (PeriodClosedException e) {
                accrual = true;
            }
            Doc_Production.deleteExistingProductionCosts(this);
            if (!this.zeroOutProduction()) {
                return false;
            }
            Doc_Production.createProductionCost(this);
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 10);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setProcessed(true);
        this.setDocAction("--");
        return true;
    }

    private boolean zeroOutProduction() {
        Properties ctx = this.getCtx();
        String trxName = this.get_TrxName();
        Timestamp movDate = this.getMovementDate();
        try {
            for (MProductionLine line : this.getLines()) {
                MProduct product;
                if (line.getM_Product_ID() <= 0 || (product = line.getProduct()) == null || !product.isStocked()) continue;
                MProductionLineMA[] mas = MProductionLineMA.get((Properties)ctx, (int)line.getM_ProductionLine_ID(), (String)trxName);
                if (mas != null && mas.length > 0) {
                    String inverseType = line.isEndProduct() ? "P-" : "P+";
                    for (MProductionLineMA ma : mas) {
                        BigDecimal qtyMA = ma.getMovementQty();
                        int asiId = ma.getM_AttributeSetInstance_ID();
                        if (!MStorage.add(ctx, line.getM_Locator().getM_Warehouse_ID(), line.getM_Locator_ID(), line.getM_Product_ID(), asiId, asiId, qtyMA, Env.ZERO, Env.ZERO, trxName)) {
                            throw new AdempiereException("No se pudo ajustar MStorage (ASI=" + asiId + ") l\u00ednea " + line.getLine());
                        }
                        MTransaction adj = new MTransaction(ctx, line.getAD_Org_ID(), inverseType, line.getM_Locator_ID(), line.getM_Product_ID(), asiId, qtyMA, movDate, trxName);
                        adj.setM_ProductionLine_ID(line.getM_ProductionLine_ID());
                        if (adj.save()) continue;
                        throw new AdempiereException("No se pudo crear MTransaction de ajuste (ASI=" + asiId + ") l\u00ednea " + line.getLine());
                    }
                    continue;
                }
                BigDecimal qty = line.getMovementQty();
                if (qty == null || qty.signum() == 0) continue;
                String inverseType = qty.signum() > 0 ? "P-" : "P+";
                MTransaction adj = new MTransaction(ctx, line.getAD_Org_ID(), inverseType, line.getM_Locator_ID(), line.getM_Product_ID(), line.getM_AttributeSetInstance_ID(), qty.negate(), movDate, trxName);
                adj.setM_ProductionLine_ID(line.getM_ProductionLine_ID());
                if (!adj.save()) {
                    throw new AdempiereException("No se pudo crear MTransaction de ajuste para la l\u00ednea " + line.getLine());
                }
                if (MStorage.add(ctx, line.getM_Locator().getM_Warehouse_ID(), line.getM_Locator_ID(), line.getM_Product_ID(), line.getM_AttributeSetInstance_ID(), line.getM_AttributeSetInstance_ID(), qty.negate(), Env.ZERO, Env.ZERO, trxName)) continue;
                throw new AdempiereException("No se pudo ajustar MStorage para la l\u00ednea " + line.getLine());
            }
            int deleted = DB.executeUpdate((String)"DELETE FROM Fact_Acct WHERE AD_Table_ID=? AND Record_ID=?", (Object[])new Object[]{Table_ID, this.getM_Production_ID()}, (boolean)false, (String)trxName);
            if (deleted < 0) {
                throw new AdempiereException("No fue posible limpiar Fact_Acct del documento.");
            }
            return true;
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "No se pudo anular Producci\u00f3n:", (Throwable)ex);
            this.m_processMsg = ex.getLocalizedMessage();
            return false;
        }
    }

    public boolean closeIt() {
        if (log.isLoggable(Level.INFO)) {
            log.info(this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 3);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setProcessed(true);
        this.setDocAction("--");
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 11);
        return this.m_processMsg == null;
    }

    public MProduction reverseIt(boolean isAccrual) {
        Timestamp currentDate = new Timestamp(System.currentTimeMillis());
        Optional<Timestamp> loginDateOptional = Optional.of(Env.getContextAsDate((Properties)this.getCtx(), (String)"#Date"));
        Timestamp reversalDate = isAccrual ? loginDateOptional.orElseGet(() -> currentDate) : this.getMovementDate();
        MPeriod.testPeriodOpen((Properties)this.getCtx(), (Timestamp)reversalDate, (int)this.getC_DocType_ID(), (int)this.getAD_Org_ID(), (String)this.get_TrxName());
        MProduction reversal = null;
        reversal = this.copyFrom(reversalDate);
        MDocType docType = MDocType.get((Properties)this.getCtx(), (int)this.getC_DocType_ID());
        if (docType.isCopyDocNoOnReversal()) {
            reversal.setDocumentNo(this.getDocumentNo() + Msg.getMsg((Properties)this.getCtx(), (String)"^"));
        }
        StringBuilder msgadd = new StringBuilder("{->").append(this.getDocumentNo()).append(")");
        reversal.addDescription(msgadd.toString());
        reversal.setReversal_ID(this.getM_Production_ID());
        reversal.saveEx(this.get_TrxName());
        if (!reversal.processIt("CO")) {
            this.m_processMsg = "@Reversal@ @Error@ " + reversal.getProcessMsg();
            return null;
        }
        reversal.closeIt();
        reversal.setDocStatus("RE");
        reversal.setDocAction("--");
        reversal.saveEx(this.get_TrxName());
        msgadd = new StringBuilder("(").append(reversal.getDocumentNo()).append("<-)");
        this.addDescription(msgadd.toString());
        this.setProcessed(true);
        this.setReversal_ID(reversal.getM_Production_ID());
        this.setDocStatus("RE");
        this.setDocAction("--");
        return reversal;
    }

    private MProduction copyFrom(Timestamp reversalDate) {
        MProduction to = new MProduction(this.getCtx(), 0, this.get_TrxName());
        PO.copyValues((PO)this, (PO)to, (int)this.getAD_Client_ID(), (int)this.getAD_Org_ID());
        to.set_ValueNoCheck("DocumentNo", null);
        to.setDocStatus("DR");
        to.setDocAction("CO");
        to.setMovementDate(reversalDate);
        to.setIsCreated(true);
        to.setPosted(false);
        to.setProcessed(false);
        to.setReversal(true);
        to.setProductionQty(this.getProductionQty().negate());
        to.saveEx();
        for (MProductionLine fline : this.getLines()) {
            MProductionLine tline = new MProductionLine(to);
            PO.copyValues((PO)fline, (PO)tline, (int)this.getAD_Client_ID(), (int)this.getAD_Org_ID());
            tline.setM_Production_ID(to.getM_Production_ID());
            tline.setMovementQty(fline.getMovementQty().negate());
            tline.setPlannedQty(fline.getPlannedQty().negate());
            tline.setQtyUsed(fline.getQtyUsed().negate());
            tline.setReversalLine_ID(fline.getM_ProductionLine_ID());
            tline.saveEx();
            if (tline.getM_AttributeSetInstance_ID() != 0) continue;
            MProductionLineMA[] mas = MProductionLineMA.get((Properties)this.getCtx(), (int)fline.getM_ProductionLine_ID(), (String)this.get_TrxName());
            for (int j = 0; j < mas.length; ++j) {
                MProductionLineMA ma = new MProductionLineMA(tline, mas[j].getM_AttributeSetInstance_ID(), mas[j].getMovementQty().negate());
                ma.saveEx();
            }
        }
        return to;
    }

    public boolean reverseCorrectIt() {
        if (log.isLoggable(Level.INFO)) {
            log.info(this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 5);
        if (this.m_processMsg != null) {
            return false;
        }
        MProduction reversal = this.reverseIt(false);
        if (reversal == null) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 13);
        if (this.m_processMsg != null) {
            return false;
        }
        this.m_processMsg = reversal.getDocumentNo();
        return true;
    }

    public boolean reverseAccrualIt() {
        if (log.isLoggable(Level.INFO)) {
            log.info(this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 6);
        if (this.m_processMsg != null) {
            return false;
        }
        MProduction reversal = this.reverseIt(true);
        if (reversal == null) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 14);
        if (this.m_processMsg != null) {
            return false;
        }
        this.m_processMsg = reversal.getDocumentNo();
        return true;
    }

    public MMovement createMovement() throws Exception {
        MProductionLine[] lines = this.getLines();
        if (lines.length == 0) {
            return null;
        }
        MProductionBatch batch = this.getParent();
        MMovement move = new MMovement(this.getCtx(), 0, this.get_TrxName());
        MWarehouse wh = (MWarehouse)this.getM_Locator().getM_Warehouse();
        boolean allowSameLocator = wh.get_ValueAsBoolean("IsAllowSameLocatorMove");
        move.setClientOrg((PO)this);
        move.setDescription(Msg.parseTranslation((Properties)this.getCtx(), (String)("@Created@ @from@ @M_ProductionBatch_ID@ " + batch.getDocumentNo())));
        move.set_Value("M_Warehouse_ID", (Object)wh.getM_Warehouse_ID());
        move.set_Value("M_Warehouse_To_ID", (Object)wh.getM_Warehouse_ID());
        move.set_Value("M_ProductionBatch_ID", (Object)batch.getM_ProductionBatch_ID());
        move.saveEx();
        log.fine("Movement Documentno=" + move.getDocumentNo() + " created for Production Batch=" + batch.getDocumentNo());
        for (MProductionLine line : lines) {
            if (line.isEndProduct() || line.getM_Product().isBOM() || !line.getM_Product().isStocked()) {
                log.fine("End Product. No need to move." + line.getM_Product().getValue());
                continue;
            }
            if (Env.ZERO.compareTo(line.getMovementQty()) == 0) {
                log.fine("No quantity to to move." + line.getM_Product().getValue());
                continue;
            }
            if (this.getM_Locator_ID() == line.getM_Product().getM_Locator_ID() && !allowSameLocator) {
                throw new AdempiereUserError("CannotUseSameLocator");
            }
            MMovementLine moveLine = new MMovementLine(move);
            moveLine.setM_LocatorTo_ID(this.getM_Locator_ID());
            moveLine.setM_Locator_ID(line.getM_Product().getM_Locator_ID());
            moveLine.setM_Product_ID(line.getM_Product_ID());
            moveLine.setM_AttributeSetInstance_ID(line.getM_AttributeSetInstance_ID());
            moveLine.setM_AttributeSetInstanceTo_ID(line.getM_AttributeSetInstance_ID());
            moveLine.setMovementQty(line.getMovementQty().negate());
            moveLine.saveEx();
        }
        return move;
    }

    public void addDescription(String description) {
        String desc = this.getDescription();
        if (desc == null) {
            this.setDescription(description);
        } else {
            StringBuilder msgd = new StringBuilder(desc).append(" | ").append(description);
            this.setDescription(msgd.toString());
        }
    }

    public boolean reActivateIt() {
        return false;
    }

    public String getSummary() {
        return this.getDocumentNo();
    }

    public String getDocumentInfo() {
        return this.getDocumentNo();
    }

    public File createPDF() {
        return null;
    }

    public String getProcessMsg() {
        return this.m_processMsg;
    }

    public int getDoc_User_ID() {
        return this.getCreatedBy();
    }

    public int getC_Currency_ID() {
        return MClient.get((Properties)this.getCtx()).getC_Currency_ID();
    }

    public BigDecimal getApprovalAmt() {
        return BigDecimal.ZERO;
    }

    protected boolean beforeSave(boolean newRecord) {
        if (this.getReversal_ID() != 0) {
            return true;
        }
        if (this.getC_DocType_ID() == 0) {
            int C_DocType_ID = MDocType.getDocType((String)"MMP", (int)this.getAD_Org_ID());
            if (C_DocType_ID == 0) {
                C_DocType_ID = MDocType.getDocType((String)"MMP");
            }
            if (C_DocType_ID == 0) {
                throw new AdempiereException("@C_DocType_ID@ @NotFound@");
            }
            this.setC_DocType_ID(C_DocType_ID);
        }
        if (this.is_ValueChanged("M_ProductionBatch_ID") && !this.isProcessed() && !this.isReversal()) {
            this.setFromBatch(this.getParent(true));
        }
        if (this.is_ValueChanged("ProductionQty") && !this.isProcessed() && this.isCreated() && !this.isReversal()) {
            this.setIsCreated(false);
        }
        BigDecimal newQty = Env.ZERO;
        if (this.getC_DocType().getName().toLowerCase().contains("desempaque")) {
            BigDecimal packOutQty = (BigDecimal)this.get_Value("PackOutQty") == null ? Env.ZERO : (BigDecimal)this.get_Value("PackOutQty");
            this.setProductionQty(packOutQty.abs().negate());
            for (MProductionLine pl : this.getLines()) {
                newQty = pl.isEndProduct() ? pl.getMovementQty().abs().negate() : pl.getMovementQty().abs();
                DB.executeUpdateEx((String)"UPDATE M_ProductionLine SET MovementQty=? WHERE M_ProductionLine_ID=?;", (Object[])new Object[]{newQty, pl.getM_ProductionLine_ID()}, (String)this.get_TrxName());
            }
        } else {
            this.setProductionQty(this.getProductionQty().abs());
            for (MProductionLine pl : this.getLines()) {
                newQty = pl.isEndProduct() ? pl.getMovementQty().abs() : pl.getMovementQty().abs().negate();
                DB.executeUpdateEx((String)"UPDATE M_ProductionLine SET MovementQty=? WHERE M_ProductionLine_ID=?;", (Object[])new Object[]{newQty, pl.getM_ProductionLine_ID()}, (String)this.get_TrxName());
            }
        }
        return true;
    }

    private void setFromBatch(MProductionBatch batch) {
        if (batch.getPP_Product_BOM_ID() != 0) {
            this.setPP_Product_BOM_ID(batch.getPP_Product_BOM_ID());
        }
        this.setM_ProductionBatch_ID(batch.getM_ProductionBatch_ID());
        this.setClientOrg((PO)batch);
        this.setM_Product_ID(batch.getM_Product_ID());
        this.setDatePromised(batch.getMovementDate());
        this.setMovementDate(batch.getMovementDate());
        this.setM_Locator_ID(batch.getM_Locator_ID());
        this.setProductionQty(batch.getTargetQty().subtract(batch.getQtyCompleted()));
        this.setC_Activity_ID(batch.getC_Activity_ID());
        this.setC_Project_ID(batch.getC_Project_ID());
        this.setC_Campaign_ID(batch.getC_Campaign_ID());
        this.setUser1_ID(batch.getUser1_ID());
        this.setUser2_ID(batch.getUser2_ID());
        if (this.getDescription() == null) {
            this.setDescription(Msg.parseTranslation((Properties)this.getCtx(), (String)("@Created@ @from@ @M_ProductionBatch_ID@ " + batch.getDocumentNo())));
        }
        log.info("M_Production_ID=" + this.getM_Production_ID() + " created");
    }

    public void setReversal(boolean reversal) {
        this.m_reversal = reversal;
    }

    public boolean isReversal() {
        return this.m_reversal;
    }

    public void checkMaterialPolicy(MProductionLine pLine, String MovementType) {
        int no = pLine.deleteMA();
        if (no > 0) {
            log.config("Delete old #" + no);
        }
        boolean needSave = false;
        MProduct product = pLine.getProduct();
        if (product.getM_AttributeSet_ID() == 0) {
            return;
        }
        String MMPolicy = product.getMMPolicy();
        Timestamp minGuaranteeDate = this.getMovementDate();
        MProductionLineMA storages = MStorage.getWarehouse(this.getCtx(), pLine.getM_Locator().getM_Warehouse_ID(), pLine.getM_Product_ID(), pLine.getM_AttributeSetInstance_ID(), minGuaranteeDate, "F".equals(MMPolicy), true, pLine.getM_Locator_ID(), this.get_TrxName());
        BigDecimal qtyToDeliver = pLine.getMovementQty().negate();
        MProductionLineMA lastMA = null;
        if (pLine.getM_AttributeSetInstance_ID() > 0) {
            MProductionLineMA ma = new MProductionLineMA(pLine, pLine.getM_AttributeSetInstance_ID(), qtyToDeliver);
            ma.saveEx();
            qtyToDeliver = Env.ZERO;
        } else {
            for (MProductionLineMA storage : storages) {
                MProductionLineMA ma;
                if (storage.getQtyOnHand().compareTo(qtyToDeliver) >= 0) {
                    ma = new MProductionLineMA(pLine, storage.getM_AttributeSetInstance_ID(), qtyToDeliver);
                    ma.saveEx();
                    qtyToDeliver = Env.ZERO;
                } else {
                    ma = new MProductionLineMA(pLine, storage.getM_AttributeSetInstance_ID(), storage.getQtyOnHand());
                    ma.saveEx();
                    qtyToDeliver = qtyToDeliver.subtract(storage.getQtyOnHand());
                    log.fine(String.valueOf(ma) + ", QtyToDeliver=" + String.valueOf(qtyToDeliver));
                    lastMA = ma;
                }
                if (qtyToDeliver.signum() == 0) break;
            }
        }
        if (qtyToDeliver.signum() != 0) {
            if (MSysConfig.getBooleanValue((String)"VALID_STOCK_PRODUCTION_MATERIAL", (boolean)false, (int)this.getAD_Client_ID()) && !this.getC_DocType().getName().toLowerCase().contains("desempaque") && !pLine.isEndProduct()) {
                throw new AdempiereException("Sin Stock producto " + product.getName() + ".");
            }
            if (lastMA == null) {
                MAttributeSet.validateAttributeSetInstanceMandatory((MProduct)product, (int)I_M_ProductionLine.Table_ID, (boolean)false, (int)pLine.getM_AttributeSetInstance_ID());
                MAttributeSetInstance asi = MAttributeSetInstance.create(this.getCtx(), product, this.get_TrxName());
                int M_AttributeSetInstance_ID = asi.getM_AttributeSetInstance_ID();
                MProductionLineMA ma = new MProductionLineMA(pLine, M_AttributeSetInstance_ID, qtyToDeliver);
                ma.saveEx();
                log.fine("##: " + String.valueOf(ma));
            } else {
                lastMA.setMovementQty(lastMA.getMovementQty().add(qtyToDeliver));
                lastMA.saveEx();
                log.fine("##: " + String.valueOf(lastMA));
            }
        }
        if (needSave) {
            pLine.saveEx();
        }
    }

    private void createLines() {
        if (this.isCreated()) {
            return;
        }
        this.isBOM(this.getM_Product_ID());
        this.recalculate();
        this.deleteLines();
        this.createLines(this.isMustBeStocked());
        this.setIsCreated(true);
        this.saveEx();
        MProductionBatch batch = this.getParent();
        if (batch != null) {
            batch.setQtyOrdered(this.getProductionQty());
            batch.saveEx();
        }
    }

    public String createLines(boolean mustBeStocked) {
        this.lineno = 100;
        String error = "";
        MProduct finishedProduct = new MProduct(this.getCtx(), this.getM_Product_ID(), this.get_TrxName());
        MAttributeSet as = finishedProduct.getAttributeSet();
        MProductionLine line = new MProductionLine(this);
        line.setLine(this.lineno);
        line.setM_Product_ID(finishedProduct.getM_Product_ID());
        line.setM_Locator_ID(this.getM_Locator_ID());
        line.setMovementQty(this.getProductionQty());
        line.setPlannedQty(this.getProductionQty());
        line.saveEx();
        error = this.createBOM(mustBeStocked, finishedProduct, this.getProductionQty());
        return error;
    }

    private List<Integer> getProductBomLines(int productBomId) {
        return new Query(this.getCtx(), "PP_Product_BOMLine", "PP_Product_BOM_ID=?", this.get_TrxName()).setParameters(new Object[]{productBomId}).setClient_ID().setOnlyActiveRecords(true).setOrderBy("Line").getIDsAsList();
    }

    private X_PP_Product_BOM getDefaultProductBom(MProduct product, String trxName) {
        return (X_PP_Product_BOM)new Query(product.getCtx(), "PP_Product_BOM", "M_Product_ID=? AND Value=?", trxName).setParameters(new Object[]{product.getM_Product_ID(), product.getValue()}).setOnlyActiveRecords(true).setOnlyActiveRecords(true).setClient_ID().first();
    }

    private String createBOM(boolean mustBeStocked, MProduct finishedProduct, BigDecimal requiredQty) {
        AtomicInteger defaultLocator = new AtomicInteger(0);
        X_PP_Product_BOM bom = null;
        bom = this.getPP_Product_BOM_ID() != 0 ? new X_PP_Product_BOM(this.getCtx(), this.getPP_Product_BOM_ID(), this.get_TrxName()) : this.getDefaultProductBom(finishedProduct, this.get_TrxName());
        this.getProductBomLines(bom.getPP_Product_BOM_ID()).forEach(productBomLineId -> {
            MProduct bomproduct;
            X_PP_Product_BOMLine bomLine = new X_PP_Product_BOMLine(this.getCtx(), productBomLineId.intValue(), this.get_TrxName());
            BigDecimal BOMMovementQty = this.getQty(bomLine, true).multiply(requiredQty);
            int precision = MUOM.getPrecision((Properties)this.getCtx(), (int)bomLine.getC_UOM_ID());
            if (BOMMovementQty.scale() > precision) {
                BOMMovementQty = BOMMovementQty.setScale(precision, RoundingMode.HALF_UP);
            }
            if ((bomproduct = new MProduct(this.getCtx(), bomLine.getM_Product_ID(), this.get_TrxName())).isBOM() && bomproduct.isPhantom()) {
                this.createBOM(mustBeStocked, bomproduct, BOMMovementQty);
            } else {
                defaultLocator.set(bomproduct.getM_Locator_ID());
                if (defaultLocator.get() == 0) {
                    defaultLocator.set(this.getM_Locator_ID());
                }
                if (!bomproduct.isStocked()) {
                    MProductionLine BOMLine = null;
                    BOMLine = new MProductionLine(this);
                    BOMLine.setLine(this.lineno);
                    BOMLine.setM_Product_ID(bomproduct.getM_Product_ID());
                    BOMLine.setM_Locator_ID(defaultLocator.get());
                    BOMLine.setQtyUsed(BOMMovementQty);
                    BOMLine.setPlannedQty(BOMMovementQty);
                    BOMLine.setMovementQty(BOMMovementQty.negate());
                    BOMLine.saveEx(this.get_TrxName());
                    this.lineno += 10;
                } else if (BOMMovementQty.signum() == 0) {
                    MProductionLine BOMLine = null;
                    BOMLine = new MProductionLine(this);
                    BOMLine.setLine(this.lineno);
                    BOMLine.setM_Product_ID(bomproduct.getM_Product_ID());
                    BOMLine.setM_Locator_ID(defaultLocator.get());
                    BOMLine.setQtyUsed(BOMMovementQty);
                    BOMLine.setPlannedQty(BOMMovementQty);
                    BOMLine.saveEx(this.get_TrxName());
                    this.lineno += 10;
                } else {
                    MProductionLine BOMLine = null;
                    BOMLine = new MProductionLine(this);
                    BOMLine.setLine(this.lineno);
                    BOMLine.setM_Product_ID(bomproduct.getM_Product_ID());
                    BOMLine.setM_Locator_ID(defaultLocator.get());
                    BOMLine.setPlannedQty(BOMMovementQty);
                    BOMLine.setQtyReserved(BOMMovementQty);
                    BOMLine.setMovementQty(BOMMovementQty.negate());
                    BOMLine.saveEx(this.get_TrxName());
                    this.lineno += 10;
                }
            }
        });
        return "";
    }

    private String recalculate() {
        int M_Warehouse_ID;
        MProduct product = MProduct.get(this.getCtx(), this.getM_Product_ID());
        MAcctSchema as = MClient.get((Properties)this.getCtx()).getAcctSchema();
        MCostType ct = MCostType.getByMethodCosting((MAcctSchema)as, (String)as.getCostingMethod());
        String costingLevel = product.getCostingLevel(as);
        if (!as.getM_CostType().getCostingMethod().equals("S")) {
            return "";
        }
        int AD_Org_ID = costingLevel.equals("O") ? this.getAD_Org_ID() : 0;
        int n = M_Warehouse_ID = costingLevel.equals("W") ? this.getM_Locator().getM_Warehouse_ID() : 0;
        if (!as.getM_CostType().getCostingMethod().equals("S")) {
            return "";
        }
        ProcessInfo processInfo = ProcessBuilder.create((Properties)this.getCtx()).process(Integer.valueOf(53062)).withRecordId(Integer.valueOf(Table_ID), Integer.valueOf(this.getM_Product_ID())).withParameter("C_AcctSchema_ID", (Object)as.getC_AcctSchema_ID()).withParameter("S_Resource_ID", (Object)as.getC_AcctSchema_ID()).withParameter("", (Object)as.getCostingMethod()).withParameter("M_CostType_ID", (Object)ct.getM_CostType_ID()).withParameter("ADOrg_ID", (Object)AD_Org_ID).withParameter("M_Warehouse_ID", (Object)M_Warehouse_ID).withParameter("CostingMethod", (Object)as.getCostingMethod()).withoutTransactionClose().execute(this.get_TrxName());
        if (processInfo.isError()) {
            throw new AdempiereException(processInfo.getSummary());
        }
        log.info(processInfo.getSummary());
        return "";
    }

    public BigDecimal getQty(X_PP_Product_BOMLine bLine, boolean includeScrapQty) {
        int precision = MUOM.getPrecision((Properties)this.getCtx(), (int)bLine.getC_UOM_ID());
        BigDecimal qty = bLine.isQtyPercentage() ? bLine.getQtyBatch().divide(Env.ONEHUNDRED, precision += 2, RoundingMode.HALF_UP) : bLine.getQtyBOM();
        if (includeScrapQty) {
            BigDecimal scrapDec = bLine.getScrap().divide(Env.ONEHUNDRED, 12, RoundingMode.UP);
            qty = qty.divide(Env.ONE.subtract(scrapDec), precision, RoundingMode.HALF_UP);
        }
        return qty;
    }
}

