/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Optional;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.core.domains.models.X_C_BPartner;
import org.adempiere.core.domains.models.X_C_ProjectMember;
import org.adempiere.core.domains.models.X_C_ProjectMemberType;
import org.adempiere.core.domains.models.X_I_BPartner;
import org.adempiere.exceptions.DBException;
import org.adempiere.process.ImportProcess;
import org.compiere.model.MBPBankAccount;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MContactInterest;
import org.compiere.model.MLocation;
import org.compiere.model.MProject;
import org.compiere.model.MUser;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Msg;

public class ImportBPartner
extends SvrProcess
implements ImportProcess {
    private int m_AD_Client_ID = 0;
    private boolean m_deleteOldImported = false;
    private boolean p_IsValidateOnly = false;
    private Timestamp m_DateValue = null;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i = 0; i < para.length; ++i) {
            String name = para[i].getParameterName();
            if (name.equals("AD_Client_ID")) {
                this.m_AD_Client_ID = ((BigDecimal)para[i].getParameter()).intValue();
                continue;
            }
            if (name.equals("DeleteOldImported")) {
                this.m_deleteOldImported = "Y".equals(para[i].getParameter());
                continue;
            }
            if (name.equals("IsValidateOnly")) {
                this.p_IsValidateOnly = para[i].getParameterAsBoolean();
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
        if (this.m_DateValue == null) {
            this.m_DateValue = new Timestamp(System.currentTimeMillis());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String doIt() throws Exception {
        StringBuilder sql = null;
        int no = 0;
        String clientCheck = this.getWhereClause();
        if (this.m_deleteOldImported) {
            sql = new StringBuilder("DELETE I_BPartner WHERE I_IsImported='Y'").append(clientCheck);
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            this.log.fine("Delete Old Impored =" + no);
        }
        sql = new StringBuilder("UPDATE I_BPartner SET AD_Client_ID = COALESCE (AD_Client_ID, ").append(this.m_AD_Client_ID).append("), AD_Org_ID = COALESCE (AD_Org_ID, 0), IsActive = COALESCE (IsActive, 'Y'), Created = COALESCE (Created, SysDate), CreatedBy = COALESCE (CreatedBy, 0), Updated = COALESCE (Updated, SysDate), UpdatedBy = COALESCE (UpdatedBy, 0), I_ErrorMsg = ' ', I_IsImported = 'N' WHERE I_IsImported<>'Y' OR I_IsImported IS NULL");
        no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Reset=" + no);
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, null, null, 10);
        sql = new StringBuilder("UPDATE I_BPartner i SET GroupValue=(SELECT MAX(Value) FROM C_BP_Group g WHERE g.IsDefault='Y' AND g.AD_Client_ID=i.AD_Client_ID) ");
        sql.append("WHERE GroupValue IS NULL AND C_BP_Group_ID IS NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set Group Default=" + no);
        sql = new StringBuilder("UPDATE I_BPartner i SET C_BP_Group_ID=(SELECT C_BP_Group_ID FROM C_BP_Group g WHERE i.GroupValue=g.Value AND g.AD_Client_ID=i.AD_Client_ID) WHERE C_BP_Group_ID IS NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set Group=" + no);
        sql = new StringBuilder("UPDATE I_BPartner SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=" + Msg.parseTranslation((Properties)this.getCtx(), (String)"@Invalid@ @C_BP_Group_ID@") + ", ' WHERE C_BP_Group_ID IS NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        this.log.config("Invalid Group=" + no);
        sql = new StringBuilder("UPDATE I_BPartner i SET C_Country_ID=(SELECT C_Country_ID FROM C_Country c WHERE UPPER(i.CountryCode)=UPPER(c.CountryCode) AND c.AD_Client_ID IN (0, i.AD_Client_ID)) WHERE C_Country_ID IS NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set Country=" + no);
        sql = new StringBuilder("UPDATE I_BPartner SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=" + Msg.parseTranslation((Properties)this.getCtx(), (String)"@Invalid@ @C_Country_ID@") + ", ' WHERE C_Country_ID IS NULL AND (City IS NOT NULL OR Address1 IS NOT NULL) AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        this.log.config("Invalid Country=" + no);
        sql = new StringBuilder("UPDATE I_BPartner i Set RegionName=(SELECT MAX(Name) FROM C_Region r WHERE r.IsDefault='Y' AND r.C_Country_ID=i.C_Country_ID AND r.AD_Client_ID IN (0, i.AD_Client_ID)) ");
        sql.append("WHERE RegionName IS NULL AND C_Region_ID IS NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set Region Default=" + no);
        sql = new StringBuilder("UPDATE I_BPartner i Set C_Region_ID=(SELECT C_Region_ID FROM C_Region r WHERE UPPER(r.Name)=UPPER(i.RegionName) AND r.C_Country_ID=i.C_Country_ID AND r.AD_Client_ID IN (0, i.AD_Client_ID)) WHERE C_Region_ID IS NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set Region=" + no);
        sql = new StringBuilder("UPDATE I_BPartner i SET BirthCountry_ID=(SELECT C_Country_ID FROM C_Country c WHERE i.BirthCountryCode=c.CountryCode AND c.AD_Client_ID IN (0, i.AD_Client_ID)) WHERE BirthCountry_ID IS NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set Country=" + no);
        sql = new StringBuilder("UPDATE I_BPartner SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=" + Msg.parseTranslation((Properties)this.getCtx(), (String)"@Invalid@ @BirthCountry_ID@") + ", ' WHERE BirthCountry_ID IS NULL AND BirthCity IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        this.log.config("Invalid Country=" + no);
        sql = new StringBuilder("UPDATE I_BPartner i Set BirthRegionName=(SELECT MAX(Name) FROM C_Region r WHERE r.IsDefault='Y' AND r.C_Country_ID=i.BirthCountry_ID AND r.AD_Client_ID IN (0, i.AD_Client_ID)) ");
        sql.append("WHERE BirthRegionName IS NULL AND BirthRegion_ID IS NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set Region Default=" + no);
        sql = new StringBuilder("UPDATE I_BPartner i Set BirthRegion_ID=(SELECT C_Region_ID FROM C_Region r WHERE UPPER(r.Name)=UPPER(i.BirthRegionName) AND r.C_Country_ID=i.BirthCountry_ID AND r.AD_Client_ID IN (0, i.AD_Client_ID)) WHERE BirthRegion_ID IS NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set Region=" + no);
        sql = new StringBuilder("UPDATE I_BPartner i SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=" + Msg.parseTranslation((Properties)this.getCtx(), (String)"@Invalid@ @C_Country_ID@") + ", ' WHERE C_Region_ID IS NULL  AND EXISTS (SELECT * FROM C_Country c WHERE c.C_Country_ID=i.C_Country_ID AND c.HasRegion='Y') AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        this.log.config("Invalid Region=" + no);
        sql = new StringBuilder("UPDATE I_BPartner i SET C_Greeting_ID=(SELECT C_Greeting_ID FROM C_Greeting g WHERE UPPER(i.BPContactGreeting)=UPPER(g.Name) AND g.AD_Client_ID IN (0, i.AD_Client_ID)) WHERE C_Greeting_ID IS NULL AND BPContactGreeting IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set Greeting=" + no);
        sql = new StringBuilder("UPDATE I_BPartner i SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=" + Msg.parseTranslation((Properties)this.getCtx(), (String)"@Invalid@ @C_Greeting_ID@") + ", ' WHERE C_Greeting_ID IS NULL AND BPContactGreeting IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        this.log.config("Invalid Greeting=" + no);
        sql = new StringBuilder("UPDATE I_BPartner i SET C_BPartner_ID=(SELECT MAX(C_BPartner_ID) FROM AD_User u WHERE UPPER(i.EMail)=UPPER(u.EMail) AND UPPER(i.ContactName)=UPPER(u.Name) AND u.AD_Client_ID=i.AD_Client_ID AND EXISTS (SELECT 1 FROM C_BPartner bp WHERE bp.C_BPartner_ID = u.C_BPartner_ID AND bp.Value = i.Value)) WHERE i.EMail IS NOT NULL AND I_IsImported='N'").append(clientCheck);
        no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Found EMail User=" + no);
        sql = new StringBuilder("UPDATE I_BPartner i SET C_BPartner_ID=(SELECT MAX(C_BPartner_ID) FROM AD_User u WHERE UPPER(i.EMail)=UPPER(u.EMail) AND u.AD_Client_ID=i.AD_Client_ID AND EXISTS (SELECT 1 FROM C_BPartner bp WHERE bp.C_BPartner_ID = u.C_BPartner_ID AND bp.Value = i.Value)) WHERE i.C_BPartner_ID IS NULL AND i.EMail IS NOT NULL AND I_IsImported='N'").append(clientCheck);
        no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Found EMail User=" + no);
        sql = new StringBuilder("UPDATE I_BPartner i SET AD_User_ID=(SELECT MAX(AD_User_ID) FROM AD_User u WHERE UPPER(i.EMail)=UPPER(u.EMail) AND UPPER(i.ContactName)=UPPER(u.Name) AND u.AD_Client_ID=i.AD_Client_ID AND EXISTS (SELECT 1 FROM C_BPartner bp WHERE bp.C_BPartner_ID = u.C_BPartner_ID AND bp.Value = i.Value)) WHERE i.EMail IS NOT NULL AND I_IsImported='N'").append(clientCheck);
        no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Found EMail User=" + no);
        sql = new StringBuilder("UPDATE I_BPartner i SET AD_User_ID=(SELECT MAX(AD_User_ID) FROM AD_User u WHERE UPPER(i.EMail)=UPPER(u.EMail) AND u.AD_Client_ID=i.AD_Client_ID AND EXISTS (SELECT 1 FROM C_BPartner bp WHERE bp.C_BPartner_ID = u.C_BPartner_ID AND bp.Value = i.Value)) WHERE i.AD_User_ID IS NULL AND i.EMail IS NOT NULL AND I_IsImported='N'").append(clientCheck);
        no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Found EMail User=" + no);
        sql = new StringBuilder("UPDATE I_BPartner i SET C_BPartner_ID=(SELECT C_BPartner_ID FROM C_BPartner p WHERE UPPER(i.Value)=UPPER(p.Value) AND p.AD_Client_ID=i.AD_Client_ID) WHERE C_BPartner_ID IS NULL AND Value IS NOT NULL AND I_IsImported='N'").append(clientCheck);
        no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Found BPartner=" + no);
        sql = new StringBuilder("UPDATE I_BPartner i SET AD_User_ID=(SELECT MAX(AD_User_ID) FROM AD_User c WHERE UPPER(i.ContactName)=UPPER(c.Name) AND i.C_BPartner_ID=c.C_BPartner_ID AND c.AD_Client_ID=i.AD_Client_ID) WHERE C_BPartner_ID IS NOT NULL AND AD_User_ID IS NULL AND ContactName IS NOT NULL AND I_IsImported='N'").append(clientCheck);
        no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Found Contact=" + no);
        sql = new StringBuilder("UPDATE  I_BPartner i SET C_Project_ID = (SELECT C_Project_ID FROM C_Project p WHERE UPPER(p.Value) = UPPER(i.ProjectValue)) WHERE i.ProjectValue IS NOT NULL AND I_IsImported='N'");
        no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Project =" + no);
        sql = new StringBuilder("UPDATE  I_BPartner i SET C_ProjectMemberType_ID = (SELECT C_ProjectMemberType_ID FROM C_ProjectMemberType pmt WHERE UPPER(pmt.Value) = UPPER(i.ProjectMemberTypeValue)) WHERE i.IsProjectMember='Y' AND I_IsImported='N'");
        no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Project Member Type =" + no);
        sql = new StringBuilder("UPDATE I_BPartner i SET C_BPartner_Location_ID=(SELECT C_BPartner_Location_ID FROM C_BPartner_Location bpl INNER JOIN C_Location l ON (bpl.C_Location_ID=l.C_Location_ID) WHERE i.C_BPartner_ID=bpl.C_BPartner_ID AND bpl.AD_Client_ID=i.AD_Client_ID AND (i.Address1=l.Address1 OR (i.Address1 IS NULL AND l.Address1 IS NULL)) AND (i.Address2=l.Address2 OR (i.Address2 IS NULL AND l.Address2 IS NULL)) AND (i.Address3=l.Address3 OR (i.Address3 IS NULL AND l.Address3 IS NULL)) AND (i.Address4=l.Address4 OR (i.Address4 IS NULL AND l.Address4 IS NULL)) AND (i.City=l.City OR (i.City IS NULL AND l.City IS NULL)) AND (i.Postal=l.Postal OR (i.Postal IS NULL AND l.Postal IS NULL)) AND (i.Postal_Add=l.Postal_Add OR (l.Postal_Add IS NULL AND l.Postal_Add IS NULL)) AND i.C_Region_ID=l.C_Region_ID AND i.C_Country_ID=l.C_Country_ID) WHERE C_BPartner_ID IS NOT NULL AND C_BPartner_Location_ID IS NULL AND I_IsImported='N'").append(clientCheck);
        no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Found Location=" + no);
        sql = new StringBuilder("UPDATE I_BPartner i SET R_InterestArea_ID=(SELECT R_InterestArea_ID FROM R_InterestArea ia WHERE UPPER(i.InterestAreaName)=UPPER(ia.Name) AND ia.AD_Client_ID=i.AD_Client_ID) WHERE R_InterestArea_ID IS NULL AND InterestAreaName IS NOT NULL AND I_IsImported='N'").append(clientCheck);
        no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set Interest Area=" + no);
        sql = new StringBuilder("UPDATE I_BPartner SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=" + Msg.parseTranslation((Properties)this.getCtx(), (String)"@FillMandatory@ @Value@") + ", ' WHERE Value IS NULL  AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        this.log.config("Value is mandatory=" + no);
        sql = new StringBuilder("UPDATE I_BPartner i SET C_Bank_ID=(SELECT MAX(C_Bank_ID) FROM C_Bank b WHERE UPPER(i.BankName)=UPPER(b.Name) AND b.AD_Client_ID=i.AD_Client_ID) WHERE C_Bank_ID IS NULL AND BankName IS NOT NULL AND IsACH='Y' AND I_IsImported='N'").append(clientCheck);
        no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set Bank=" + no);
        sql = new StringBuilder("UPDATE I_BPartner SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=" + Msg.parseTranslation((Properties)this.getCtx(), (String)"@Invalid@ @C_Bank_ID@") + ", ' WHERE C_Bank_ID IS NULL AND BankName IS NOT NULL AND IsACH='Y' AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        this.log.config("Invalid Country=" + no);
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, null, null, 20);
        this.commitEx();
        if (this.p_IsValidateOnly) {
            return "Validated";
        }
        int noInsert = 0;
        int noUpdate = 0;
        sql = new StringBuilder("SELECT * FROM I_BPartner WHERE I_IsImported='N'").append(clientCheck);
        sql.append(" ORDER BY Value, I_BPartner_ID");
        Object whereClause = "";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
            rs = pstmt.executeQuery();
            String Old_BPValue = "";
            MBPartner bp = null;
            MBPartnerLocation bpl = null;
            while (rs.next()) {
                MUser user;
                X_I_BPartner importPartner;
                block68: {
                    block70: {
                        int cityID;
                        block72: {
                            block73: {
                                block71: {
                                    MLocation location;
                                    block69: {
                                        String New_BPValue;
                                        block67: {
                                            New_BPValue = rs.getString("Value");
                                            importPartner = new X_I_BPartner(this.getCtx(), rs, this.get_TrxName());
                                            this.log.fine("I_BPartner_ID=" + importPartner.getI_BPartner_ID() + ", C_BPartner_ID=" + importPartner.getC_BPartner_ID() + ", C_BPartner_Location_ID=" + importPartner.getC_BPartner_Location_ID() + ", AD_User_ID=" + importPartner.getAD_User_ID());
                                            if (!New_BPValue.equals(Old_BPValue)) {
                                                bp = null;
                                                if (importPartner.getC_BPartner_ID() == 0) {
                                                    bp = new MBPartner(importPartner);
                                                    ModelValidationEngine.get().fireImportValidate((ImportProcess)this, (PO)importPartner, (PO)bp, 40);
                                                    if (importPartner.getBirthCountry_ID() > 0) {
                                                        this.setPlaceOfBirthId(importPartner, bp);
                                                    }
                                                    this.setTypeOfBPartner(importPartner, bp);
                                                    this.applyCreditFromImport(importPartner, bp);
                                                    if (bp.save()) {
                                                        importPartner.setC_BPartner_ID(bp.getC_BPartner_ID());
                                                        this.log.finest("Insert BPartner - " + bp.getC_BPartner_ID());
                                                        ++noInsert;
                                                        break block67;
                                                    } else {
                                                        sql = new StringBuilder("UPDATE I_BPartner i SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||").append("'Cannot Insert BPartner, ' ").append("WHERE I_BPartner_ID=").append(importPartner.getI_BPartner_ID());
                                                        DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
                                                        continue;
                                                    }
                                                }
                                                bp = new MBPartner(this.getCtx(), importPartner.getC_BPartner_ID(), this.get_TrxName());
                                                if (importPartner.getName() != null) {
                                                    bp.setName(importPartner.getName());
                                                    bp.setName2(importPartner.getName2());
                                                }
                                                if (importPartner.getDUNS() != null) {
                                                    bp.setDUNS(importPartner.getDUNS());
                                                }
                                                if (importPartner.getTaxID() != null) {
                                                    bp.setTaxID(importPartner.getTaxID());
                                                }
                                                if (importPartner.getNAICS() != null) {
                                                    bp.setNAICS(importPartner.getNAICS());
                                                }
                                                if (importPartner.getDescription() != null) {
                                                    bp.setDescription(importPartner.getDescription());
                                                }
                                                if (importPartner.getC_BP_Group_ID() != 0) {
                                                    bp.setC_BP_Group_ID(importPartner.getC_BP_Group_ID());
                                                }
                                                if (importPartner.getBirthday() != null) {
                                                    bp.setBirthday(importPartner.getBirthday());
                                                }
                                                if (importPartner.getFathersName() != null) {
                                                    bp.setFathersName(importPartner.getFathersName());
                                                }
                                                if (importPartner.getBloodGroup() != null) {
                                                    bp.setBloodGroup(importPartner.getBloodGroup());
                                                }
                                                if (importPartner.getGender() != null) {
                                                    bp.setGender(importPartner.getGender());
                                                }
                                                ModelValidationEngine.get().fireImportValidate((ImportProcess)this, (PO)importPartner, (PO)bp, 40);
                                                if (importPartner.getBirthCountry_ID() > 0) {
                                                    this.setPlaceOfBirthId(importPartner, bp);
                                                }
                                                this.setTypeOfBPartner(importPartner, bp);
                                                this.applyCreditFromImport(importPartner, bp);
                                                if (bp.save()) {
                                                    this.log.finest("Update BPartner - " + bp.getC_BPartner_ID());
                                                    ++noUpdate;
                                                    break block67;
                                                } else {
                                                    sql = new StringBuilder("UPDATE I_BPartner i SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||").append("'Cannot Update BPartner, ' ").append("WHERE I_BPartner_ID=").append(importPartner.getI_BPartner_ID());
                                                    DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
                                                    continue;
                                                }
                                            }
                                            importPartner.setC_BPartner_ID(bp.getC_BPartner_ID());
                                            importPartner.save();
                                        }
                                        Old_BPValue = New_BPValue;
                                        whereClause = " EXISTS(SELECT 1 FROM C_Location l, I_BPartner i WHERE l.C_Location_ID = C_BPartner_Location.C_Location_ID AND i.I_BPartner_ID = " + importPartner.getI_BPartner_ID();
                                        if (importPartner.getAddress1() != null && !importPartner.getAddress1().isEmpty()) {
                                            whereClause = (String)whereClause + " AND l.Address1 = i.Address1";
                                        }
                                        if (importPartner.getAddress2() != null && !importPartner.getAddress2().isEmpty()) {
                                            whereClause = (String)whereClause + " AND l.Address2 = i.Address2";
                                        }
                                        if (importPartner.getAddress3() != null && !importPartner.getAddress3().isEmpty()) {
                                            whereClause = (String)whereClause + " AND l.Address3 = i.Address3";
                                        }
                                        if (importPartner.getAddress4() != null && !importPartner.getAddress4().isEmpty()) {
                                            whereClause = (String)whereClause + " AND l.Address4 = i.Address4";
                                        }
                                        if (importPartner.getCity() != null && !importPartner.getCity().isEmpty()) {
                                            whereClause = (String)whereClause + " AND l.City = i.City";
                                        }
                                        if (importPartner.getC_Region_ID() != 0) {
                                            whereClause = (String)whereClause + " AND l.C_Region_ID = i.C_Region_ID";
                                        }
                                        if (importPartner.getC_Country_ID() != 0) {
                                            whereClause = (String)whereClause + " AND l.C_Country_ID = i.C_Country_ID";
                                        }
                                        if (importPartner.getPostal() != null && !importPartner.getPostal().isEmpty()) {
                                            whereClause = (String)whereClause + " AND l.Postal = i.Postal";
                                        }
                                        if (importPartner.getPostal_Add() != null && !importPartner.getPostal_Add().isEmpty()) {
                                            whereClause = (String)whereClause + " AND l.Postal_Add = i.Postal_Add";
                                        }
                                        whereClause = (String)whereClause + ")";
                                        bpl = Arrays.stream(MBPartnerLocation.getForBPartner(this.getCtx(), importPartner.getC_BPartner_ID(), (String)whereClause, importPartner.get_TrxName())).findFirst().orElse(null);
                                        if (bpl == null) break block69;
                                        location = new MLocation(this.getCtx(), bpl.getC_Location_ID(), this.get_TrxName());
                                        location.setC_Country_ID(importPartner.getC_Country_ID());
                                        location.setC_Region_ID(importPartner.getC_Region_ID());
                                        location.setCity(importPartner.getCity());
                                        location.setAddress1(importPartner.getAddress1());
                                        location.setAddress2(importPartner.getAddress2());
                                        location.setAddress3(importPartner.getAddress3());
                                        location.setAddress4(importPartner.getAddress4());
                                        location.setPostal(importPartner.getPostal());
                                        location.setPostal_Add(importPartner.getPostal_Add());
                                        if (!location.save()) {
                                            this.log.warning("Location not updated");
                                        } else {
                                            bpl.setC_Location_ID(location.getC_Location_ID());
                                        }
                                        if (importPartner.getPhone() != null) {
                                            bpl.setPhone(importPartner.getPhone());
                                        }
                                        if (importPartner.getPhone2() != null) {
                                            bpl.setPhone2(importPartner.getPhone2());
                                        }
                                        if (importPartner.getFax() != null) {
                                            bpl.setFax(importPartner.getFax());
                                        }
                                        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, (PO)importPartner, (PO)bpl, 40);
                                        bpl.saveEx();
                                        break block70;
                                    }
                                    if (importPartner.getC_Country_ID() == 0 || importPartner.getAddress1() == null || importPartner.getCity() == null) break block70;
                                    location = new MLocation(this.getCtx(), importPartner.getC_Country_ID(), importPartner.getC_Region_ID(), importPartner.getCity(), this.get_TrxName());
                                    location.setAddress1(importPartner.getAddress1());
                                    location.setAddress2(importPartner.getAddress2());
                                    location.setAddress3(importPartner.getAddress3());
                                    location.setAddress4(importPartner.getAddress4());
                                    location.setPostal(importPartner.getPostal());
                                    location.setPostal_Add(importPartner.getPostal_Add());
                                    if (!location.save()) break block71;
                                    this.log.finest("Insert Location - " + location.getC_Location_ID());
                                    bpl = new MBPartnerLocation(bp);
                                    bpl.setC_Location_ID(location.getC_Location_ID());
                                    cityID = DB.getSQLValue((String)this.get_TrxName(), (String)"SELECT MAX(C_City_ID) FROM C_City WHERE C_Country_ID=? AND UPPER(Name)=UPPER(?)", (Object[])new Object[]{importPartner.getC_Country_ID(), importPartner.getCity()});
                                    if (cityID > 0) break block72;
                                    break block73;
                                }
                                this.rollback();
                                --noInsert;
                                sql = new StringBuilder("UPDATE I_BPartner i SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||").append("'Cannot Insert Location, ' ").append("WHERE I_BPartner_ID=").append(importPartner.getI_BPartner_ID());
                                DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
                                continue;
                            }
                            this.rollback();
                            --noInsert;
                            sql = new StringBuilder("UPDATE I_BPartner i SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||").append("'Ciudad no encontrada, ' ").append("WHERE I_BPartner_ID=").append(importPartner.getI_BPartner_ID());
                            DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
                            continue;
                        }
                        bpl.setC_City_ID(cityID);
                        bpl.setC_Region_ID(importPartner.getC_Region_ID());
                        bpl.setC_Country_ID(importPartner.getC_Country_ID());
                        bpl.setAddress1(importPartner.getAddress1());
                        bpl.setPhone(importPartner.getPhone());
                        bpl.setPhone2(importPartner.getPhone2());
                        bpl.setFax(importPartner.getFax());
                        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, (PO)importPartner, (PO)bpl, 40);
                        if (bpl.save()) {
                            this.log.finest("Insert BP Location - " + bpl.getC_BPartner_Location_ID());
                            importPartner.setC_BPartner_Location_ID(bpl.getC_BPartner_Location_ID());
                        } else {
                            this.rollback();
                            --noInsert;
                            sql = new StringBuilder("UPDATE I_BPartner i SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||").append("'Cannot Insert BPLocation, ' ").append("WHERE I_BPartner_ID=").append(importPartner.getI_BPartner_ID());
                            DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
                            continue;
                        }
                    }
                    user = null;
                    if (importPartner.getAD_User_ID() != 0) {
                        String name;
                        user = new MUser(this.getCtx(), importPartner.getAD_User_ID(), this.get_TrxName());
                        if (user.getC_BPartner_ID() == 0) {
                            user.setC_BPartner_ID(bp.getC_BPartner_ID());
                        } else if (user.getC_BPartner_ID() != bp.getC_BPartner_ID()) {
                            this.rollback();
                            --noInsert;
                            sql = new StringBuilder("UPDATE I_BPartner i SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||").append("'BP of User <> BP, ' ").append("WHERE I_BPartner_ID=").append(importPartner.getI_BPartner_ID());
                            DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
                            continue;
                        }
                        if (importPartner.getC_Greeting_ID() != 0) {
                            user.setC_Greeting_ID(importPartner.getC_Greeting_ID());
                        }
                        if ((name = importPartner.getContactName()) == null || name.length() == 0) {
                            name = importPartner.getEMail();
                        }
                        user.setName(name);
                        if (importPartner.getTitle() != null) {
                            user.setTitle(importPartner.getTitle());
                        }
                        if (importPartner.getContactDescription() != null) {
                            user.setDescription(importPartner.getContactDescription());
                        }
                        if (importPartner.getComments() != null) {
                            user.setComments(importPartner.getComments());
                        }
                        if (importPartner.getPhone() != null) {
                            user.setPhone(importPartner.getPhone());
                        }
                        if (importPartner.getPhone2() != null) {
                            user.setPhone2(importPartner.getPhone2());
                        }
                        if (importPartner.getFax() != null) {
                            user.setFax(importPartner.getFax());
                        }
                        if (importPartner.getEMail() != null) {
                            user.setEMail(importPartner.getEMail());
                        }
                        if (importPartner.getBirthday() != null) {
                            user.setBirthday(importPartner.getBirthday());
                        }
                        if (bpl != null) {
                            user.setC_BPartner_Location_ID(bpl.getC_BPartner_Location_ID());
                        }
                        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, (PO)importPartner, (PO)user, 40);
                        if (user.save()) {
                            this.log.finest("Update BP Contact - " + user.getAD_User_ID());
                            this.setProjectInfo(importPartner, user);
                            break block68;
                        } else {
                            this.rollback();
                            --noInsert;
                            sql = new StringBuilder("UPDATE I_BPartner i SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||").append("'Cannot Update BP Contact, ' ").append("WHERE I_BPartner_ID=").append(importPartner.getI_BPartner_ID());
                            DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
                            continue;
                        }
                    }
                    if (importPartner.getContactName() != null || importPartner.getEMail() != null) {
                        String name;
                        user = new MUser((X_C_BPartner)bp);
                        if (importPartner.getC_Greeting_ID() != 0) {
                            user.setC_Greeting_ID(importPartner.getC_Greeting_ID());
                        }
                        if ((name = importPartner.getContactName()) == null || name.length() == 0) {
                            name = importPartner.getEMail();
                        }
                        user.setName(name);
                        user.setTitle(importPartner.getTitle());
                        user.setDescription(importPartner.getContactDescription());
                        user.setComments(importPartner.getComments());
                        user.setPhone(importPartner.getPhone());
                        user.setPhone2(importPartner.getPhone2());
                        user.setFax(importPartner.getFax());
                        user.setEMail(importPartner.getEMail());
                        user.setBirthday(importPartner.getBirthday());
                        if (bpl != null) {
                            user.setC_BPartner_Location_ID(bpl.getC_BPartner_Location_ID());
                        }
                        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, (PO)importPartner, (PO)user, 40);
                        if (user.save()) {
                            this.log.finest("Insert BP Contact - " + user.getAD_User_ID());
                            importPartner.setAD_User_ID(user.getAD_User_ID());
                            this.setProjectInfo(importPartner, user);
                        } else {
                            this.rollback();
                            --noInsert;
                            sql = new StringBuilder("UPDATE I_BPartner i SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||").append("'Cannot Insert BPContact, ' ").append("WHERE I_BPartner_ID=").append(importPartner.getI_BPartner_ID());
                            DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
                            continue;
                        }
                    }
                }
                if (importPartner.getR_InterestArea_ID() != 0 && user != null) {
                    MContactInterest ci = MContactInterest.get((Properties)this.getCtx(), (int)importPartner.getR_InterestArea_ID(), (int)user.getAD_User_ID(), (boolean)true, (String)this.get_TrxName());
                    ci.saveEx();
                }
                whereClause = "IsACH = 'Y' AND EXISTS (SELECT 1 FROM I_BPartner i WHERE i.I_BPartner_ID = " + importPartner.getI_BPartner_ID() + " AND i.A_Name = C_BP_BankAccount.A_Name";
                if (importPartner.isACH()) {
                    whereClause = (String)whereClause + " AND C_Bank_ID = i.C_Bank_ID";
                }
                whereClause = (String)whereClause + ")";
                MBPBankAccount bpBankAccount = MBPBankAccount.getByPartner((Properties)this.getCtx(), (int)importPartner.getC_BPartner_ID(), (String)whereClause, (String)importPartner.get_TrxName()).stream().findFirst().orElse(new MBPBankAccount(this.getCtx(), 0, this.get_TrxName()));
                if (importPartner.isACH() && importPartner.getC_Bank_ID() != 0 && importPartner.getA_Name() != null || !importPartner.isACH() && importPartner.getA_Name() != null) {
                    bpBankAccount.setC_BPartner_ID(importPartner.getC_BPartner_ID());
                    bpBankAccount.setIsACH(importPartner.isACH());
                    bpBankAccount.setIsACH(importPartner.isACH());
                    bpBankAccount.setCreditCardType(importPartner.getCreditCardType());
                    bpBankAccount.setCreditCardNumber(importPartner.getCreditCardNumber());
                    bpBankAccount.setCreditCardVV(importPartner.getCreditCardVV());
                    bpBankAccount.setCreditCardExpMM(importPartner.getCreditCardExpMM());
                    bpBankAccount.setCreditCardExpYY(importPartner.getCreditCardExpYY());
                    bpBankAccount.setBPBankAcctUse(importPartner.getBPBankAcctUse());
                    bpBankAccount.setIBAN(importPartner.getIBAN());
                    bpBankAccount.setC_Bank_ID(importPartner.getC_Bank_ID());
                    bpBankAccount.setBankAccountType(importPartner.getBankAccountType());
                    bpBankAccount.setRoutingNo(importPartner.getRoutingNo());
                    bpBankAccount.setAccountNo(importPartner.getAccountNo());
                    bpBankAccount.setA_Name(importPartner.getA_Name());
                    bpBankAccount.setA_Street(importPartner.getA_Street());
                    bpBankAccount.setA_City(importPartner.getA_City());
                    bpBankAccount.setA_Zip(importPartner.getA_Zip());
                    bpBankAccount.setA_State(importPartner.getA_State());
                    bpBankAccount.setA_Country(importPartner.getA_Country());
                    bpBankAccount.setA_Ident_DL(importPartner.getA_Ident_DL());
                    bpBankAccount.setA_Ident_SSN(importPartner.getA_Ident_SSN());
                    bpBankAccount.setA_EMail(importPartner.getA_EMail());
                    bpBankAccount.setR_AvsAddr(importPartner.getR_AvsAddr());
                    bpBankAccount.setR_AvsZip(importPartner.getR_AvsZip());
                    bpBankAccount.save();
                    importPartner.setC_BP_BankAccount_ID(bpBankAccount.getC_BP_BankAccount_ID());
                }
                importPartner.setI_IsImported(true);
                importPartner.setProcessed(true);
                importPartner.setProcessing(false);
                importPartner.saveEx();
                this.commitEx();
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
        }
        catch (SQLException e) {
            try {
                this.rollback();
                throw new DBException((Exception)e, sql.toString());
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                sql = new StringBuilder("UPDATE I_BPartner SET I_IsImported='N', Updated=SysDate WHERE I_IsImported<>'Y'").append(clientCheck);
                no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
                this.addLog(0, null, new BigDecimal(no), "@Errors@");
                this.addLog(0, null, new BigDecimal(noInsert), "@C_BPartner_ID@: @Inserted@");
                this.addLog(0, null, new BigDecimal(noUpdate), "@C_BPartner_ID@: @Updated@");
                throw throwable;
            }
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        sql = new StringBuilder("UPDATE I_BPartner SET I_IsImported='N', Updated=SysDate WHERE I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        this.addLog(0, null, new BigDecimal(no), "@Errors@");
        this.addLog(0, null, new BigDecimal(noInsert), "@C_BPartner_ID@: @Inserted@");
        this.addLog(0, null, new BigDecimal(noUpdate), "@C_BPartner_ID@: @Updated@");
        return "";
    }

    private void setProjectInfo(X_I_BPartner impportPartner, MUser user) {
        Optional<MProject> projectOptional;
        if (impportPartner.isProjectManager()) {
            user.setIsProjectManager(true);
            projectOptional = Optional.ofNullable((MProject)impportPartner.getC_Project());
            projectOptional.ifPresent(project -> {
                if (project.getProjectManager_ID() <= 0) {
                    project.setProjectManager_ID(user.get_ID());
                    project.saveEx();
                }
            });
        }
        if (impportPartner.isProjectMember()) {
            user.setIsProjectMember(true);
            projectOptional = Optional.ofNullable((MProject)impportPartner.getC_Project());
            projectOptional.ifPresent(project -> {
                Optional<X_C_ProjectMemberType> projectMemberTyoeOptinal = Optional.ofNullable((X_C_ProjectMemberType)impportPartner.getC_ProjectMemberType());
                X_C_ProjectMember projectMember = new X_C_ProjectMember(this.getCtx(), 0, this.get_TrxName());
                projectMember.setC_Project_ID(project.getC_Project_ID());
                projectMember.setAD_User_ID(user.get_ID());
                projectMember.setNotificationType(user.getNotificationType());
                projectMemberTyoeOptinal.ifPresent(projectMemberType -> projectMember.setC_ProjectMemberType_ID(projectMemberType.getC_ProjectMemberType_ID()));
                projectMember.saveEx();
            });
        }
    }

    public String getWhereClause() {
        return " AND AD_Client_ID=" + this.m_AD_Client_ID;
    }

    public String getImportTableName() {
        return "I_BPartner";
    }

    private void setPlaceOfBirthId(X_I_BPartner impBP, MBPartner partner) {
        int placeOfBirthId = impBP.getPlaceOfBirth_ID();
        if (placeOfBirthId == 0 && impBP.getC_BPartner_ID() > 0) {
            placeOfBirthId = partner.getPlaceOfBirth_ID();
        }
        MLocation location = new MLocation(this.getCtx(), placeOfBirthId, this.get_TrxName());
        location.setC_Country_ID(impBP.getBirthCountry_ID());
        location.setC_Region_ID(impBP.getBirthRegion_ID());
        location.setCity(impBP.getBirthCity());
        location.setPostal(impBP.getBirthPostal());
        if (!location.save()) {
            this.log.warning("Location not updated");
        }
        impBP.setPlaceOfBirth_ID(location.getC_Location_ID());
        partner.setPlaceOfBirth_ID(location.getC_Location_ID());
    }

    private void setTypeOfBPartner(X_I_BPartner impBP, MBPartner bp) {
        if (impBP.isVendor()) {
            bp.setIsVendor(true);
            bp.setIsCustomer(false);
        }
        if (impBP.isEmployee()) {
            bp.setIsEmployee(true);
            bp.setIsCustomer(false);
        }
        if (impBP.isCustomer()) {
            bp.setIsCustomer(true);
        }
    }

    private void applyCreditFromImport(X_I_BPartner imp, MBPartner bp) {
        BigDecimal creditLimit = null;
        try {
            Object v = imp.get_Value("i_so_creditlimit");
            if (v instanceof BigDecimal) {
                creditLimit = (BigDecimal)v;
            } else if (v != null) {
                creditLimit = new BigDecimal(v.toString());
            }
        }
        catch (Exception v) {
            // empty catch block
        }
        if (creditLimit != null) {
            bp.setSO_CreditLimit(creditLimit);
        }
        String creditStatus = null;
        try {
            Object s = imp.get_Value("i_socreditstatus");
            if (s != null) {
                creditStatus = s.toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (creditStatus != null && creditStatus.trim().length() > 0) {
            bp.setSOCreditStatus(creditStatus.trim());
        }
    }
}

