/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.compiere.model.MBPartner;
import org.compiere.model.MClient;
import org.compiere.model.MDocType;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MInvoiceSchedule;
import org.compiere.model.MLocation;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.Query;
import org.compiere.process.InvoiceGenerateAbstract;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Language;

public class InvoiceGenerate
extends InvoiceGenerateAbstract {
    private MInvoice invoice = null;
    private MInOut m_ship = null;
    private int m_created = 0;
    private int m_line = 0;
    private MBPartner businessPartner = null;

    protected void prepare() {
        super.prepare();
        if (this.getDocAction() == null) {
            this.setDocAction("CO");
        }
        if (this.getDateInvoiced() == null) {
            this.setDateInvoiced(Env.getContextAsDate((Properties)this.getCtx(), (String)"#Date"));
        }
        if (this.getDateInvoiced() == null) {
            this.setDateInvoiced(new Timestamp(System.currentTimeMillis()));
        }
        if (!"CO".equals(this.getDocAction())) {
            this.setDocAction("PR");
        }
    }

    protected String doIt() throws Exception {
        this.log.info("Selection=" + this.isSelection() + ", DateInvoiced=" + String.valueOf(this.getDateInvoiced()) + ", AD_Org_ID=" + this.getOrgId() + ", C_BPartner_ID=" + this.getBPartnerId() + ", C_Order_ID=" + this.getOrderId() + ", DocAction=" + this.getDocAction() + ", Consolidate=" + this.isConsolidateDocument());
        String message = null;
        if (this.isSelection()) {
            message = this.generate(new Query(this.getCtx(), "C_Order", "DocStatus='CO' AND IsSOTrx='Y' AND C_Order_ID IN" + this.getSelectionKeys().toString().replace('[', '(').replace(']', ')'), this.get_TrxName()).setClient_ID().setOrderBy("M_Warehouse_ID, PriorityRule, C_BPartner_ID, Bill_Location_ID, C_Order_ID").list());
        } else {
            StringBuffer whereAdded = new StringBuffer();
            ArrayList<Integer> parameters = new ArrayList<Integer>();
            if (this.getOrgId() != 0) {
                whereAdded.append(" AND AD_Org_ID=?");
                parameters.add(this.getOrgId());
            }
            if (this.getBPartnerId() != 0) {
                whereAdded.append(" AND C_BPartner_ID=?");
                parameters.add(this.getBPartnerId());
            }
            if (this.getOrderId() != 0) {
                whereAdded.append(" AND C_Order_ID=?");
                parameters.add(this.getOrderId());
            }
            whereAdded.append(" AND EXISTS(SELECT 1 FROM C_OrderLine ol WHERE C_Order.C_Order_ID = ol.C_Order_ID AND ol.QtyOrdered <> ol.QtyInvoiced) ");
            whereAdded.append("AND EXISTS(SELECT 1 FROM C_DocType dt WHERE dt.C_DocType_ID = C_Order.C_DocType_ID AND dt.DocBaseType='SOO' AND dt.DocSubTypeSO NOT IN ('ON','OB','WR'))");
            message = this.generate(new Query(this.getCtx(), "C_Order", "DocStatus IN('CO','CL') AND IsSOTrx='Y' " + String.valueOf(whereAdded), this.get_TrxName()).setParameters(parameters).setClient_ID().setOrderBy("M_Warehouse_ID, PriorityRule, C_BPartner_ID, Bill_Location_ID, C_Order_ID").list());
        }
        return message;
    }

    private String generate(List<MOrder> orderList) {
        AtomicInteger counter = new AtomicInteger(0);
        orderList.forEach(order -> {
            counter.getAndIncrement();
            if (!this.isConsolidateDocument() || this.invoice != null && this.invoice.getC_BPartner_Location_ID() != order.getBill_Location_ID()) {
                this.completeInvoice();
            }
            boolean completeOrder = "O".equals(order.getInvoiceRule());
            boolean doInvoice = false;
            if ("S".equals(order.getInvoiceRule())) {
                this.businessPartner = new MBPartner(this.getCtx(), order.getBill_BPartner_ID(), null);
                if (this.businessPartner.getC_InvoiceSchedule_ID() == 0) {
                    this.log.warning("BPartner has no Schedule - set to After Delivery");
                    order.setInvoiceRule("D");
                    order.saveEx();
                } else {
                    MInvoiceSchedule is = MInvoiceSchedule.get((Properties)this.getCtx(), (int)this.businessPartner.getC_InvoiceSchedule_ID(), (String)this.get_TrxName());
                    doInvoice = is.canInvoice(order.getDateOrdered(), order.getGrandTotal());
                }
            }
            if (doInvoice || "D".equals(order.getInvoiceRule())) {
                Arrays.asList(order.getShipments()).stream().filter(shipment -> shipment.isComplete() && !shipment.getDocStatus().equals("RE")).forEach(shipment -> {
                    Arrays.asList(shipment.getLines(false)).stream().filter(shipmentLine -> order.isOrderLine(shipmentLine.getC_OrderLine_ID())).filter(shipmentLine -> !shipmentLine.isInvoiced()).forEach(shipmentLine -> this.createLine((MOrder)((Object)order), (MInOut)((Object)((Object)shipment)), (MInOutLine)((Object)((Object)((Object)shipmentLine)))));
                    this.m_line += 1000;
                });
            } else {
                Arrays.asList(order.getLines(true, null)).stream().filter(orderLine -> orderLine.getQtyOrdered().subtract(orderLine.getQtyInvoiced()).compareTo(Env.ZERO) != 0 && (orderLine.getM_Product_ID() != 0 || orderLine.getC_Charge_ID() != 0)).forEach(orderLine -> {
                    boolean fullyDelivered;
                    BigDecimal toInvoice = orderLine.getQtyOrdered().subtract(orderLine.getQtyInvoiced());
                    boolean bl = fullyDelivered = orderLine.getQtyOrdered().compareTo(orderLine.getQtyDelivered()) == 0;
                    if (completeOrder && !fullyDelivered) {
                        this.log.fine("Failed CompleteOrder - " + String.valueOf(orderLine));
                        this.addLog("Failed CompleteOrder - " + String.valueOf(orderLine));
                    } else if ("I".equals(order.getInvoiceRule())) {
                        this.log.fine("Immediate - ToInvoice=" + String.valueOf(toInvoice) + " - " + String.valueOf(orderLine));
                        BigDecimal quantityEntered = toInvoice;
                        if (orderLine.getQtyEntered().compareTo(orderLine.getQtyOrdered()) != 0) {
                            quantityEntered = toInvoice.multiply(orderLine.getQtyEntered()).divide(orderLine.getQtyOrdered(), 12, RoundingMode.HALF_UP);
                        }
                        this.createLine((MOrder)((Object)order), (MOrderLine)((Object)((Object)orderLine)), toInvoice, quantityEntered);
                    } else {
                        this.log.fine("Failed: " + order.getInvoiceRule() + " - ToInvoice=" + String.valueOf(toInvoice) + " - " + String.valueOf(orderLine));
                        this.addLog("Failed: " + order.getInvoiceRule() + " - ToInvoice=" + String.valueOf(toInvoice) + " - " + String.valueOf(orderLine));
                    }
                });
                if ("I".equals(order.getInvoiceRule())) {
                    this.m_line += 1000;
                }
            }
            if (completeOrder && "O".equals(order.getInvoiceRule())) {
                Arrays.asList(order.getShipments()).stream().filter(shipment -> shipment.isComplete() && !shipment.getDocStatus().equals("RE")).forEach(shipment -> {
                    Arrays.asList(shipment.getLines(false)).stream().filter(shipmentLine -> order.isOrderLine(shipmentLine.getC_OrderLine_ID()) && !shipmentLine.isInvoiced()).forEach(shipmentLine -> this.createLine((MOrder)((Object)order), (MInOut)((Object)((Object)shipment)), (MInOutLine)((Object)((Object)((Object)shipmentLine)))));
                    this.m_line += 1000;
                });
            }
        });
        this.completeInvoice();
        return "@Created@ = " + this.m_created + " @of@ " + String.valueOf(counter);
    }

    private void createLine(MOrder order, MOrderLine orderLine, BigDecimal qtyInvoiced, BigDecimal qtyEntered) {
        if (this.invoice == null) {
            this.invoice = new MInvoice(order, 0, this.getDateInvoiced());
            this.invoice.saveEx();
        }
        MInvoiceLine line = new MInvoiceLine(this.invoice);
        line.setOrderLine(orderLine);
        line.setQtyInvoiced(qtyInvoiced);
        line.setQtyEntered(qtyEntered);
        line.setLine(this.m_line + orderLine.getLine());
        line.setC_Tax_ID(orderLine.getC_Tax_ID());
        line.saveEx();
        this.log.fine(line.toString());
    }

    private void createLine(MOrder order, MInOut ship, MInOutLine sLine) {
        if (this.invoice == null) {
            this.invoice = new MInvoice(order, 0, this.getDateInvoiced());
            this.invoice.saveEx();
        }
        if (this.m_ship == null || this.m_ship.getM_InOut_ID() != ship.getM_InOut_ID()) {
            MDocType dt = MDocType.get((Properties)this.getCtx(), (int)ship.getC_DocType_ID());
            if (this.businessPartner == null || this.businessPartner.getC_BPartner_ID() != ship.getC_BPartner_ID()) {
                this.businessPartner = new MBPartner(this.getCtx(), ship.getC_BPartner_ID(), this.get_TrxName());
            }
            MClient client = MClient.get((Properties)this.getCtx(), (int)order.getAD_Client_ID());
            String AD_Language = client.getAD_Language();
            if (client.isMultiLingualDocument() && this.businessPartner.getAD_Language() != null) {
                AD_Language = this.businessPartner.getAD_Language();
            }
            if (AD_Language == null) {
                AD_Language = Language.getBaseAD_Language();
            }
            SimpleDateFormat format = DisplayType.getDateFormat((int)15, (Language)Language.getLanguage((String)AD_Language));
            String reference = dt.getPrintName(this.businessPartner.getAD_Language()) + ": " + ship.getDocumentNo() + " - " + format.format(ship.getMovementDate());
            this.m_ship = ship;
            MInvoiceLine line = new MInvoiceLine(this.invoice);
            line.setIsDescription(true);
            line.setDescription(reference);
            line.setC_Tax_ID(sLine.getC_OrderLine().getC_Tax_ID());
            line.setLine(this.m_line + sLine.getLine() - 2);
            line.saveEx();
            if (order.getBill_Location_ID() != ship.getC_BPartner_Location_ID()) {
                MLocation addr = MLocation.getBPLocation((Properties)this.getCtx(), (int)ship.getC_BPartner_Location_ID(), null);
                line = new MInvoiceLine(this.invoice);
                line.setIsDescription(true);
                line.setDescription(addr.toString());
                line.setLine(this.m_line + sLine.getLine() - 1);
                line.setC_Tax_ID(sLine.getC_OrderLine().getC_Tax_ID());
                line.saveEx();
            }
        }
        MInvoiceLine line = new MInvoiceLine(this.invoice);
        line.setShipLine(sLine);
        if (sLine.sameOrderLineUOM()) {
            line.setQtyEntered(sLine.getQtyEntered());
        } else {
            line.setQtyEntered(sLine.getMovementQty());
        }
        line.setQtyInvoiced(sLine.getMovementQty());
        line.setLine(this.m_line + sLine.getLine());
        String toBeInvoiced = sLine.get_ValueAsString("ToBeInvoiced");
        if ("N".equals(toBeInvoiced)) {
            line.setPriceEntered(Env.ZERO);
            line.setPriceActual(Env.ZERO);
            line.setPriceLimit(Env.ZERO);
            line.setPriceList(Env.ZERO);
            line.setLineNetAmt(Env.ZERO);
            line.setIsDescription(true);
        }
        line.saveEx();
        sLine.setIsInvoiced(true);
        sLine.saveEx();
        this.log.fine(line.toString());
    }

    private void completeInvoice() {
        if (this.invoice != null) {
            if (!this.invoice.processIt(this.getDocAction())) {
                this.log.warning("completeInvoice - failed: " + this.invoice.getProcessMsg());
                this.addLog(this.invoice.getProcessMsg());
            }
            this.invoice.saveEx();
            this.addLog(this.invoice.getC_Invoice_ID(), this.invoice.getDateInvoiced(), null, this.invoice.getDocumentNo());
            this.getProcessInfo().setRecord_ID(this.invoice.getC_Invoice_ID());
            ++this.m_created;
        }
        this.invoice = null;
        this.m_ship = null;
        this.m_line = 0;
    }
}

