/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.hr.process;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.adempiere.core.domains.models.X_I_HR_Movement;
import org.compiere.model.MBPartner;
import org.compiere.model.Query;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.eevolution.hr.model.MHRConcept;
import org.eevolution.hr.model.MHRMovement;
import org.eevolution.hr.process.ImportPayrollMovementsAbstract;

public class ImportPayrollMovements
extends ImportPayrollMovementsAbstract {
    protected void prepare() {
        super.prepare();
    }

    protected String doIt() throws Exception {
        this.characterFormatFix();
        if (this.isDeleteOldImported()) {
            Arrays.stream(this.getPayrollImportMovementIds(true, true, null)).parallel().forEach(recordId -> {
                X_I_HR_Movement importPayrollMovement = new X_I_HR_Movement(this.getCtx(), recordId, null);
                importPayrollMovement.deleteEx(true);
            });
        }
        ConcurrentHashMap cache = new ConcurrentHashMap();
        int[] movementIds = this.getPayrollImportMovementIds(false, false, null);
        ExecutorService executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        AtomicInteger importedRecord = new AtomicInteger(0);
        AtomicInteger withErrors = new AtomicInteger(0);
        for (int recordId2 : movementIds) {
            executor.submit(() -> Trx.run(trxName -> {
                X_I_HR_Movement importPayrollMovement = new X_I_HR_Movement(this.getCtx(), recordId2, trxName);
                this.fillIdValuesWithCache(importPayrollMovement, cache);
                if (this.importRecord(importPayrollMovement)) {
                    importedRecord.incrementAndGet();
                } else {
                    withErrors.incrementAndGet();
                }
            }));
        }
        executor.shutdown();
        executor.awaitTermination(1L, TimeUnit.HOURS);
        DB.executeUpdate((String)"update HR_Movement m set HR_Payroll_ID= (SELECT max(HR_Payroll_ID) FROM HR_Employee e WHERE e.C_BPartner_ID=m.C_BPartner_ID) Where HR_Movement_ID in (SELECT HR_Movement_ID FROM I_HR_Movement)", (String)this.get_TrxName());
        DB.executeUpdate((String)"update HR_Movement m set HR_Process_ID = (SELECT max(p.HR_Process_ID) FROM HR_Process p WHERE m.HR_Payroll_ID=p.HR_Payroll_ID ) where HR_Movement_ID in (SELECT HR_Movement_ID FROM I_HR_Movement )", (String)this.get_TrxName());
        DB.executeUpdate((String)"UPDATE HR_Movement SET IsManual='Y' WHERE HR_Movement_ID IN (SELECT HR_Movement_ID FROM I_HR_Movement )", (String)this.get_TrxName());
        DB.executeUpdate((String)"DELETE FROM I_HR_Movement WHERE HR_Movement_ID IS NOT NULL", (String)this.get_TrxName());
        return "@HR_Movement_ID@ @Import@ @Records@ " + importedRecord.get() + " @Errors@ " + withErrors.get();
    }

    private void characterFormatFix() {
        String sql = "UPDATE I_HR_Movement SET ProcessName = regexp_replace(ProcessName, '[^\\x20-\\x7E]', '', 'g'),bpartner_value = regexp_replace(bpartner_value, '[^\\x20-\\x7E]', '', 'g'),ConceptValue = regexp_replace(ConceptValue, '[^\\x20-\\x7E]', '', 'g') WHERE AD_Client_ID=?";
        this.log.config("SQL Correccion de caracteres=>" + sql);
        int count = DB.executeUpdate((String)sql, (int)Env.getAD_Client_ID((Properties)this.getCtx()), (String)this.get_TrxName());
        this.log.config("Se aplica correccion de caracteres a " + count + " registro(s).");
        try {
            DB.commit((boolean)true, (String)this.get_TrxName());
        }
        catch (IllegalStateException | SQLException e) {
            e.printStackTrace();
        }
    }

    private void fillIdValuesWithCache(X_I_HR_Movement importPayrollMovement, Map<String, Integer> cache) {
        StringBuilder messageError = new StringBuilder();
        importPayrollMovement.setI_ErrorMsg("");
        String processName = importPayrollMovement.getProcessName();
        cache.computeIfAbsent(processName, name -> this.getId("HR_Process", "Name= ?", name));
        importPayrollMovement.setHR_Process_ID(cache.getOrDefault(processName, 0).intValue());
        if (importPayrollMovement.getHR_Process_ID() <= 0) {
            messageError.append("@HR_Process_ID@ @NotFound@ ");
        }
        String partnerValue = importPayrollMovement.getBPartner_Value();
        cache.computeIfAbsent(partnerValue, value -> this.getId("C_BPartner", "Value= ?", value));
        int partnerId = cache.getOrDefault(partnerValue, 0);
        if (partnerId > 0) {
            MBPartner partner = new MBPartner(this.getCtx(), partnerId, importPayrollMovement.get_TrxName());
            if (!partner.isEmployee()) {
                messageError.append(", @IsEmployee@ @NotValid@ @C_BPartner_ID@ ").append(partner.getName());
            } else {
                importPayrollMovement.setC_BPartner_ID(partnerId);
            }
        } else {
            messageError.append(", @C_BPartner_ID@ @NotFound@ ");
        }
        String conceptValue = importPayrollMovement.getConceptValue();
        cache.computeIfAbsent(conceptValue, value -> this.getId("HR_Concept", "Value= ? AND IsManual= ? AND IsActive= ?", value.trim(), true, true));
        int conceptId = cache.getOrDefault(conceptValue, 0);
        if (conceptId > 0) {
            MHRConcept concept = new MHRConcept(this.getCtx(), conceptId, importPayrollMovement.get_TrxName());
            if ("E".equals(concept.getType())) {
                messageError.append(", @HR_Concept_ID@ @NotValid@ ").append(concept.getName());
            } else {
                importPayrollMovement.setHR_Concept_ID(conceptId);
            }
        } else {
            messageError.append("@HR_Concept_ID@ @NotFound@ ");
        }
        if (importPayrollMovement.getValidFrom() == null) {
            messageError.append(", @ValidFrom@ @FillMandatory@ ");
        }
        if (importPayrollMovement.getValidTo() == null) {
            importPayrollMovement.setValidTo(importPayrollMovement.getValidFrom());
        }
        if (messageError.length() > 0) {
            this.setImportError(importPayrollMovement, messageError.toString()).saveEx(importPayrollMovement.get_TrxName());
        }
        importPayrollMovement.saveEx();
    }

    private boolean importRecord(X_I_HR_Movement importPayrollMovement) {
        if (importPayrollMovement.getI_ErrorMsg() != null && !importPayrollMovement.getI_ErrorMsg().isEmpty()) {
            importPayrollMovement.setProcessed(false);
            importPayrollMovement.setI_IsImported(false);
            importPayrollMovement.saveEx();
            return false;
        }
        MHRMovement payrollMovement = new MHRMovement(this.getCtx(), 0, importPayrollMovement.get_TrxName());
        payrollMovement.setHR_Process_ID(importPayrollMovement.getHR_Process_ID());
        payrollMovement.setC_BPartner_ID(importPayrollMovement.getC_BPartner_ID());
        payrollMovement.setHR_Concept_ID(importPayrollMovement.getHR_Concept_ID());
        payrollMovement.setValidFrom(importPayrollMovement.getValidFrom());
        payrollMovement.setValidTo(importPayrollMovement.getValidTo());
        payrollMovement.setQty(importPayrollMovement.getQty());
        payrollMovement.setAmount(importPayrollMovement.getAmount());
        payrollMovement.setProcessed(true);
        payrollMovement.saveEx(importPayrollMovement.get_TrxName());
        importPayrollMovement.setHR_Movement_ID(payrollMovement.getHR_Movement_ID());
        importPayrollMovement.setI_IsImported(true);
        importPayrollMovement.setProcessed(true);
        importPayrollMovement.setI_ErrorMsg("");
        importPayrollMovement.saveEx(importPayrollMovement.get_TrxName());
        return true;
    }

    private int getId(String tableName, String whereClause, Object ... parameters) {
        return new Query(this.getCtx(), tableName, whereClause, this.get_TrxName()).setClient_ID().setParameters(parameters).firstId();
    }

    private X_I_HR_Movement setImportError(X_I_HR_Movement importPayrollMovement, String error) {
        importPayrollMovement.setI_ErrorMsg(Msg.parseTranslation((Properties)this.getCtx(), (String)error));
        this.addLog(importPayrollMovement.getI_HR_Movement_ID(), importPayrollMovement.getValidFrom(), importPayrollMovement.getAmount(), importPayrollMovement.getI_ErrorMsg());
        return importPayrollMovement;
    }

    private int[] getPayrollImportMovementIds(boolean isImported, boolean isProcessed, String trxName) {
        String whereClause = "I_IsImported=? AND Processed=?";
        return new Query(this.getCtx(), "I_HR_Movement", whereClause, trxName).setClient_ID().setOnlyActiveRecords(true).setParameters(new Object[]{isImported, isProcessed}).getIDs();
    }
}

