/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.manufacturing.process;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import org.adempiere.core.domains.models.I_M_CostType;
import org.adempiere.engine.CostEngine;
import org.adempiere.engine.CostEngineFactory;
import org.adempiere.engine.IDocumentLine;
import org.compiere.acct.Doc;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MCostDetail;
import org.compiere.model.MCostElement;
import org.compiere.model.MCostType;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInventoryLine;
import org.compiere.model.MLandedCostAllocation;
import org.compiere.model.MMatchInv;
import org.compiere.model.MMatchPO;
import org.compiere.model.MMovementLine;
import org.compiere.model.MProduction;
import org.compiere.model.MProductionLine;
import org.compiere.model.MTransaction;
import org.compiere.model.PO;
import org.compiere.process.DocAction;
import org.compiere.util.DB;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Trx;
import org.eevolution.manufacturing.model.MPPCostCollector;
import org.eevolution.manufacturing.process.GenerateCostDetailAbstract;
import org.eevolution.manufacturing.services.StandardCostCollector;

public class GenerateCostDetail
extends GenerateCostDetailAbstract {
    private ArrayList<Object> deleteParameters;
    private ArrayList<Object> resetCostParameters;
    private List<MAcctSchema> acctSchemas = new ArrayList<MAcctSchema>();
    private List<MCostType> costTypes = new ArrayList<MCostType>();
    private List<MCostElement> costElements = new ArrayList<MCostElement>();
    private StringBuffer deleteCostDetailWhereClause;
    private StringBuffer resetCostWhereClause;
    private boolean rePostIt = false;
    private final LinkedHashSet<DocRef> docsToPost = new LinkedHashSet();

    protected void prepare() {
        super.prepare();
        this.rePostIt = this.getParameterAsBoolean("IsPostImmediate");
        if (this.getDateAcct() != null) {
            this.setup();
        }
    }

    protected String doIt() throws Exception {
        this.generateCostDetail();
        return "@Ok@";
    }

    private void deleteCostDetail(String trxName) throws SQLException {
        StringBuffer sqlDelete = new StringBuffer("DELETE FROM M_CostDetail WHERE ");
        sqlDelete.append(this.deleteCostDetailWhereClause);
        DB.executeUpdateEx((String)sqlDelete.toString(), (Object[])this.deleteParameters.toArray(), (String)trxName);
    }

    private void resetCostDimension(String costingMethod, String trxName) throws SQLException {
        StringBuffer sqlReset = new StringBuffer("UPDATE M_Cost SET ");
        if ("I".equals(costingMethod)) {
            sqlReset.append("CurrentCostPrice").append("=0.0,");
            sqlReset.append("CurrentCostPriceLL").append("= 0.0,");
        }
        sqlReset.append("CurrentQty").append("= 0.0,");
        sqlReset.append("CumulatedAmt").append("= 0.0,");
        sqlReset.append("CumulatedAmtLL").append("= 0.0,");
        sqlReset.append("CumulatedQty").append("= 0.0 ");
        sqlReset.append(" WHERE ").append(this.resetCostWhereClause);
        DB.executeUpdateEx((String)sqlReset.toString(), (Object[])this.resetCostParameters.toArray(), (String)trxName);
    }

    private void setup() {
        if (this.getAcctSchemaId() > 0) {
            this.acctSchemas.add(MAcctSchema.get((Properties)this.getCtx(), (int)this.getAcctSchemaId(), (String)this.get_TrxName()));
        } else {
            this.acctSchemas = Arrays.asList(MAcctSchema.getClientAcctSchema((Properties)this.getCtx(), (int)this.getAD_Client_ID(), (String)this.get_TrxName()));
        }
        if (this.getCostTypeId() > 0) {
            this.costTypes.add(new MCostType(this.getCtx(), this.getCostTypeId(), this.get_TrxName()));
        } else {
            this.costTypes = MCostType.get((Properties)this.getCtx(), (String)this.get_TrxName());
        }
        if (this.getCostElementId() > 0) {
            this.costElements.add(MCostElement.get((Properties)this.getCtx(), (int)this.getCostElementId()));
        } else {
            this.costElements = MCostElement.getCostElement((Properties)this.getCtx(), (String)this.get_TrxName());
        }
    }

    private void applyCriteria(int accountSchemaId, int costTypeId, int costElementId, int productId, Timestamp dateAccount, Timestamp dateAccountTo) {
        this.deleteParameters = new ArrayList();
        this.resetCostParameters = new ArrayList();
        this.deleteCostDetailWhereClause = new StringBuffer("1=1");
        this.resetCostWhereClause = new StringBuffer("1=1");
        if (accountSchemaId > 0) {
            this.deleteCostDetailWhereClause.append(" AND ").append("C_AcctSchema_ID").append("=? ");
            this.deleteParameters.add(accountSchemaId);
            this.resetCostWhereClause.append(" AND ").append("C_AcctSchema_ID").append("=? ");
            this.resetCostParameters.add(accountSchemaId);
        }
        if (costTypeId > 0) {
            this.deleteCostDetailWhereClause.append(" AND ").append("M_CostType_ID").append("=? ");
            this.deleteParameters.add(costTypeId);
            this.resetCostWhereClause.append(" AND ").append("M_CostType_ID").append("=? ");
            this.resetCostParameters.add(costTypeId);
        }
        if (costElementId > 0) {
            this.deleteCostDetailWhereClause.append(" AND ").append("M_CostElement_ID").append("=? ");
            this.deleteParameters.add(costElementId);
            this.resetCostWhereClause.append(" AND ").append("M_CostElement_ID").append("=? ");
            this.resetCostParameters.add(costElementId);
        }
        if (productId > 0) {
            this.deleteCostDetailWhereClause.append(" AND ").append("M_Product_ID").append("=? ");
            this.deleteParameters.add(productId);
            this.resetCostWhereClause.append(" AND ").append("M_Product_ID").append("=? ");
            this.resetCostParameters.add(productId);
        }
        if (dateAccount != null) {
            this.deleteCostDetailWhereClause.append(" AND ").append("DateAcct").append(">=? ");
            this.deleteParameters.add(dateAccount);
        }
        if (dateAccountTo != null) {
            this.deleteCostDetailWhereClause.append(" AND ").append("DateAcct").append("<=? ");
            this.deleteParameters.add(dateAccountTo);
        }
        this.resetCostWhereClause.append(" AND EXISTS ( SELECT 1 FROM RV_Transaction WHERE M_Product_ID=? AND DateAcct>=? AND DateAcct<?::timestamp + interval '1 day')");
        this.resetCostParameters.add(productId);
        this.resetCostParameters.add(dateAccount);
        this.resetCostParameters.add(dateAccountTo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateCostDetail() {
        KeyNamePair[] transactions = this.getTransactionIdsByDateAcct();
        Integer process = 0;
        Integer productId = 0;
        Trx dbTransaction = null;
        try {
            for (KeyNamePair keyNamePair : transactions) {
                int count = 0;
                int transactionId = keyNamePair.getKey();
                int transactionProductId = Integer.valueOf(keyNamePair.getName());
                if (productId != transactionProductId) {
                    if (dbTransaction != null) {
                        dbTransaction.commit(true);
                        dbTransaction.close();
                    }
                    ++count;
                    productId = transactionProductId;
                    dbTransaction = Trx.get((String)productId.toString(), (boolean)true);
                    for (MAcctSchema accountSchema : this.acctSchemas) {
                        for (MCostType costType : this.costTypes) {
                            for (MCostElement costElement : this.costElements) {
                                this.applyCriteria(accountSchema.getC_AcctSchema_ID(), costType.getM_CostType_ID(), costElement.getM_CostElement_ID(), productId, this.getDateAcct(), this.getDateAcctTo());
                                this.deleteCostDetail(dbTransaction.getTrxName());
                                this.resetCostDimension(costType.getCostingMethod(), dbTransaction.getTrxName());
                                this.generateCostCollectorNotTransaction(accountSchema, costType, productId, dbTransaction.getTrxName());
                            }
                        }
                    }
                }
                MTransaction transaction = new MTransaction(this.getCtx(), transactionId, dbTransaction.getTrxName());
                for (MAcctSchema accountSchema : this.acctSchemas) {
                    for (MCostType costType : this.costTypes) {
                        for (MCostElement costElement : this.costElements) {
                            this.generateCostDetail(accountSchema, costType, costElement, transaction);
                        }
                    }
                }
                Integer n = process;
                process = process + 1;
            }
            if (dbTransaction != null) {
                dbTransaction.commit(true);
                dbTransaction.close();
                dbTransaction = null;
            }
        }
        catch (Exception e) {
            if (dbTransaction != null) {
                dbTransaction.rollback();
                dbTransaction.close();
                dbTransaction = null;
                e.printStackTrace();
                this.addLog(e.getMessage());
            }
        }
        finally {
            if (dbTransaction != null) {
                dbTransaction.commit();
                dbTransaction.close();
                dbTransaction = null;
            }
        }
        this.postCollectedDocumentsOnce();
    }

    public void generateCostDetail(MAcctSchema accountSchema, MCostType costType, MCostElement costElement, MTransaction transaction) {
        CostEngine engine = CostEngineFactory.getCostEngine((int)accountSchema.getAD_Client_ID());
        engine.createCostDetail(accountSchema, costType, costElement, transaction, transaction.getDocumentLine(), true);
        engine.clearAccounting(accountSchema, transaction);
        if (this.rePostIt) {
            this.collectDocToPost(transaction);
        }
        if ("V+".equals(transaction.getMovementType())) {
            MInOutLine line = (MInOutLine)transaction.getDocumentLine();
            MLandedCostAllocation.getOfInOutline((MInOutLine)line, (int)costElement.getM_CostElement_ID()).stream().forEach(allocation -> {
                if ((allocation.getDateAcct().after(this.getDateAcct()) || allocation.getDateAcct().equals(this.getDateAcct())) && (allocation.getDateAcct().before(this.getDateAcctTo()) || allocation.getDateAcct().equals(this.getDateAcctTo()))) {
                    CostEngineFactory.getCostEngine((int)accountSchema.getAD_Client_ID()).createCostDetail(accountSchema, costType, costElement, transaction, (IDocumentLine)allocation, true);
                }
            });
        }
    }

    private void generateCostCollectorNotTransaction(MAcctSchema accountSchema, MCostType costType, int productId, String trxName) throws SQLException {
        List costCollectors = StandardCostCollector.getCostCollectorNotTransaction((Properties)this.getCtx(), (int)productId, (Timestamp)this.getDateAcct(), (Timestamp)this.getDateAcctTo(), (String)trxName);
        for (MPPCostCollector costCollector : costCollectors) {
            for (MCostDetail costDetail : StandardCostCollector.getByCollectorCost((MPPCostCollector)costCollector)) {
                costDetail.deleteEx(true);
            }
            CostEngineFactory.getCostEngine((int)this.getAD_Client_ID()).clearAccounting(accountSchema, (I_M_CostType)costType, (PO)costCollector, productId, costCollector.getDateAcct());
            if ("120".equals(costCollector.getCostCollectorType())) {
                StandardCostCollector.createUsageVariances((MPPCostCollector)costCollector);
                continue;
            }
            if ("130".equals(costCollector.getCostCollectorType())) {
                StandardCostCollector.createMethodVariancesFromActivityControl((MPPCostCollector)costCollector);
                continue;
            }
            if ("140".equals(costCollector.getCostCollectorType())) {
                StandardCostCollector.createRateVariances((MPPCostCollector)costCollector);
                continue;
            }
            if (!"160".equals(costCollector.getCostCollectorType())) continue;
            StandardCostCollector.createActivityControl((MPPCostCollector)costCollector);
        }
    }

    private KeyNamePair[] getTransactionIdsByDateAcct() {
        StringBuilder sql = new StringBuilder();
        ArrayList<Comparable<Integer>> parameters = new ArrayList<Comparable<Integer>>();
        StringBuilder whereClause = new StringBuilder("WHERE ");
        whereClause.append("AD_Client_ID").append("=").append(this.getAD_Client_ID()).append(" AND ");
        if (this.getProductId() > 0) {
            whereClause.append("M_Product_ID").append("=?").append(" AND ");
            parameters.add(Integer.valueOf(this.getProductId()));
        }
        if (this.getProductCategoryId() > 0) {
            whereClause.append("M_Product_Category_ID").append("=?").append(" AND ");
            parameters.add(Integer.valueOf(this.getProductCategoryId()));
        }
        whereClause.append("DateAcct").append(" >=? ");
        parameters.add(this.getDateAcct());
        if (this.getDateAcctTo() != null) {
            whereClause.append(" AND ").append("DateAcct").append(" < ?::timestamp + interval '1 day'");
            parameters.add(this.getDateAcctTo());
        }
        whereClause.append(" AND IsActive='Y' AND DocStatus NOT IN ('VO','RE') ");
        sql.append("SELECT M_Transaction_ID , M_Product_ID FROM RV_Transaction ").append((CharSequence)whereClause).append(" ORDER BY lowlevel desc, M_Product_ID , DATE_TRUNC('day',DateAcct), SortPhase ,M_Transaction_ID ");
        return DB.getKeyNamePairs((String)this.get_TrxName(), (String)sql.toString(), (boolean)false, (Object[])parameters.toArray());
    }

    private void collectDocToPost(MTransaction trx) {
        IDocumentLine line = trx.getDocumentLine();
        if (line == null) {
            return;
        }
        DocAction header = null;
        if (line instanceof MInOutLine) {
            header = ((MInOutLine)line).getParent();
        } else if (line instanceof MMovementLine) {
            header = ((MMovementLine)line).getParent();
        } else if (line instanceof MInventoryLine) {
            header = ((MInventoryLine)line).getParent();
        } else if (line instanceof MProductionLine) {
            header = new MProduction(this.getCtx(), ((MProductionLine)line).getM_Production_ID(), trx.get_TrxName());
        } else if (line instanceof MMatchPO) {
            header = (MMatchPO)line;
        } else if (line instanceof MMatchInv) {
            header = (MMatchInv)line;
        } else if (line instanceof MPPCostCollector) {
            header = (MPPCostCollector)line;
        } else if (line instanceof PO) {
            PO poLine = (PO)line;
            try {
                Object p = poLine.getClass().getMethod("getParent", new Class[0]).invoke((Object)poLine, new Object[0]);
                if (p instanceof PO) {
                    header = (PO)p;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (header == null) {
                header = poLine;
            }
        }
        if (header != null && header.get_ID() > 0) {
            this.docsToPost.add(new DocRef(header.get_Table_ID(), header.get_ID()));
        }
    }

    private void postCollectedDocumentsOnce() {
        if (!this.rePostIt || this.docsToPost.isEmpty()) {
            return;
        }
        MAcctSchema[] schemas = this.acctSchemas.toArray(new MAcctSchema[0]);
        for (DocRef d : this.docsToPost) {
            try {
                Doc.postImmediate(schemas, d.adTableId, d.recordId, true, null);
            }
            catch (Exception e) {
                this.log.warning("Post error Table=" + d.adTableId + " Record=" + d.recordId + " => " + e.getMessage());
                this.addLog("Post error Table=" + d.adTableId + " Record=" + d.recordId + ": " + e.getMessage());
            }
        }
    }

    private static final class DocRef {
        final int adTableId;
        final int recordId;

        DocRef(int adTableId, int recordId) {
            this.adTableId = adTableId;
            this.recordId = recordId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof DocRef)) {
                return false;
            }
            DocRef d = (DocRef)o;
            return this.adTableId == d.adTableId && this.recordId == d.recordId;
        }

        public int hashCode() {
            return Objects.hash(this.adTableId, this.recordId);
        }
    }
}

