/*
 * Decompiled with CFR 0.152.
 */
package org.spin.queue.notification.support;

import java.io.File;
import java.util.Arrays;
import java.util.Properties;
import org.adempiere.core.domains.models.X_AD_UserMail;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MAttachment;
import org.compiere.model.MClient;
import org.compiere.model.MEMailConfig;
import org.compiere.model.MOrg;
import org.compiere.model.MOrgInfo;
import org.compiere.model.MUser;
import org.compiere.util.CLogger;
import org.compiere.util.DigestOfFile;
import org.compiere.util.EMail;
import org.compiere.util.Env;
import org.spin.queue.notification.model.MADNotificationQueue;
import org.spin.queue.notification.support.INotification;

public class EMailSender
implements INotification {
    private int registrationId = 0;
    private CLogger log = CLogger.getCLogger(EMailSender.class);

    public int getAppRegistrationId() {
        return this.registrationId;
    }

    public void setAppRegistrationId(int registrationId) {
        this.registrationId = registrationId;
        this.log.fine("set Registration: " + registrationId);
    }

    public String testConnection() {
        this.log.fine("Test connection");
        return "Ok";
    }

    public void sendNotification(MADNotificationQueue notification) {
        StringBuffer errorMessage = new StringBuffer();
        notification.getRecipients().forEach(recipient -> {
            MOrg organization;
            MOrgInfo organizationInformation;
            int eMailConfigurationId = 0;
            String eMailUser = null;
            String eMailPassword = null;
            MUser notificationUser = new MUser(notification.getCtx(), notification.getCreatedBy(), notification.get_TrxName());
            StringBuffer recipientErrorMessage = new StringBuffer();
            MClient client = MClient.get((Properties)notification.getCtx(), (int)notification.getAD_Client_ID());
            eMailConfigurationId = notificationUser.getAD_EMailConfig_ID();
            eMailUser = notificationUser.getEMailUser();
            eMailPassword = notificationUser.getEMailUserPW();
            if ((eMailConfigurationId <= 0 || eMailUser == null || eMailUser.isEmpty() || eMailPassword == null || eMailPassword.isEmpty()) && notification.getAD_Org_ID() > 0 && (organizationInformation = (organization = MOrg.get((Properties)notification.getCtx(), (int)notification.getAD_Org_ID())).getInfo()) != null && organizationInformation.get_ID() > 0) {
                eMailConfigurationId = organizationInformation.getAD_EMailConfig_ID();
                eMailUser = organizationInformation.getEMail();
                eMailPassword = organizationInformation.getRequestUserPW();
            }
            if (eMailConfigurationId <= 0 || eMailUser == null || eMailUser.isEmpty() || eMailPassword == null || eMailPassword.isEmpty()) {
                eMailUser = client.getRequestEMail();
                eMailPassword = client.getRequestUserPW();
                eMailConfigurationId = client.getAD_EMailConfig_ID();
            }
            if (eMailConfigurationId <= 0 || eMailUser == null || eMailUser.isEmpty() || eMailPassword == null || eMailPassword.isEmpty()) {
                this.log.warning("@AD_EMailConfig_ID@ @NotFound@");
                if (errorMessage.length() > 0) {
                    errorMessage.append(Env.NL);
                }
                errorMessage.append("@AD_EMailConfig_ID@ @NotFound@");
            } else {
                EMail email = new EMail(client, eMailConfigurationId, eMailUser, recipient.getAccountName(), notification.getDescription(), notification.getText(), false);
                if (!email.isValid() && !email.isValid(true)) {
                    this.log.warning("NOT VALID - " + String.valueOf(email));
                    if (recipientErrorMessage.length() > 0) {
                        recipientErrorMessage.append(Env.NL);
                    }
                    recipientErrorMessage.append("NOT VALID - " + String.valueOf(email));
                    recipient.setIsActive(false);
                } else {
                    boolean isSent;
                    MEMailConfig eMailConfig = MEMailConfig.get((Properties)notification.getCtx(), (int)eMailConfigurationId);
                    if (eMailConfig.isSmtpAuthorization()) {
                        email.createAuthenticator(eMailUser, eMailPassword);
                    }
                    email.setSubject(notification.getDescription());
                    email.setMessageHTML(notification.getText());
                    MAttachment attachment = notification.getAttachment();
                    if (attachment != null && attachment.getAD_Attachment_ID() > 0) {
                        Arrays.asList(attachment.getEntries()).forEach(entry -> {
                            String localFile = System.getProperty("java.io.tmpdir") + System.getProperty("file.separator") + entry.getName();
                            String downloadedLocalFile = System.getProperty("java.io.tmpdir") + System.getProperty("file.separator") + "TMP" + entry.getName();
                            File reportFile = new File(localFile);
                            if (reportFile.exists()) {
                                String entryMD5hash;
                                String localMD5hash = DigestOfFile.GetLocalMD5Hash((File)reportFile);
                                if (localMD5hash.equals(entryMD5hash = DigestOfFile.getMD5Hash((byte[])entry.getData()))) {
                                    email.addAttachment(entry.getFile(reportFile));
                                    this.log.info(reportFile.getAbsolutePath());
                                } else {
                                    this.log.info(" report on server is different that local one, download and replace");
                                    File downloadedFile = new File(downloadedLocalFile);
                                    email.addAttachment(entry.getFile(reportFile));
                                    this.log.info(reportFile.getAbsolutePath());
                                    if (!reportFile.delete()) {
                                        throw new AdempiereException("Cannot delete temporary file " + reportFile.toString());
                                    }
                                    if (!downloadedFile.renameTo(reportFile)) {
                                        throw new AdempiereException("Cannot rename temporary file " + downloadedFile.toString() + " to " + reportFile.toString());
                                    }
                                }
                            } else {
                                email.addAttachment(entry.getFile(reportFile));
                                this.log.info(reportFile.getAbsolutePath());
                            }
                        });
                    }
                    if (isSent = "OK".equals(email.send())) {
                        this.log.fine("EMail Sent: " + recipient.getAccountName());
                        recipient.setProcessed(true);
                    } else {
                        recipient.setIsActive(false);
                        if (recipientErrorMessage.length() > 0) {
                            recipientErrorMessage.append(Env.NL);
                        }
                        recipientErrorMessage.append("Error: Sending to: " + recipient.getAccountName());
                    }
                    if (recipient.getAD_User_ID() > 0) {
                        X_AD_UserMail userMail = new X_AD_UserMail(notification.getCtx(), 0, notification.get_TrxName());
                        userMail.setAD_Org_ID(notification.getAD_Org_ID());
                        userMail.setAD_User_ID(recipient.getAD_User_ID());
                        userMail.setSubject(email.getSubject());
                        userMail.setMailText(email.getMessageCRLF());
                        if (email.isSentOK()) {
                            userMail.setMessageID(email.getMessageID());
                        } else {
                            userMail.setMessageID(email.getSentMsg());
                            userMail.setIsDelivered("N");
                        }
                        userMail.saveEx();
                    }
                }
                if (recipientErrorMessage.length() > 0) {
                    errorMessage.append(recipientErrorMessage);
                    recipient.setErrorMsg(recipientErrorMessage.toString());
                }
                if (recipient.is_Changed()) {
                    recipient.saveEx();
                }
            }
        });
    }
}

